/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "bs" locale.
 */
public class LocalizedNamesImpl_bs extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "VI",
        "AS",
        "UM",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BW",
        "BO",
        "BA",
        "CX",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "TD",
        "CF",
        "CZ",
        "CL",
        "ME",
        "DK",
        "CD",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EZ",
        "EU",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GH",
        "GG",
        "GI",
        "GR",
        "GD",
        "GL",
        "GE",
        "GU",
        "GP",
        "GY",
        "GT",
        "GN",
        "GW",
        "HT",
        "HM",
        "NL",
        "HN",
        "HK",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "TL",
        "IT",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "GS",
        "KR",
        "SS",
        "ZA",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "QA",
        "KZ",
        "KE",
        "CN",
        "CY",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "XK",
        "CR",
        "CU",
        "CK",
        "CW",
        "KW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "HU",
        "MX",
        "FM",
        "MM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "DE",
        "NO",
        "NC",
        "NZ",
        "CI",
        "AX",
        "OM",
        "TC",
        "WF",
        "AC",
        "BV",
        "CP",
        "IM",
        "NF",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "RE",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "SN",
        "EA",
        "SL",
        "SG",
        "SX",
        "SY",
        "US",
        "KP",
        "MP",
        "SK",
        "SI",
        "SB",
        "SO",
        "ES",
        "RS",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "PM",
        "VC",
        "CH",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UG",
        "UN",
        "AE",
        "UA",
        "UY",
        "UZ",
        "QO",
        "VU",
        "VA",
        "GB",
        "VE",
        "VN",
        "XA",
        "XB",
        "ZM",
        "EH",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Svijet");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Sjeverna Amerika");
    namesMap.put("005", "Južna Amerika");
    namesMap.put("009", "Okeanija");
    namesMap.put("011", "Zapadna Afrika");
    namesMap.put("013", "Srednja Amerika");
    namesMap.put("014", "Istočna Afrika");
    namesMap.put("015", "Sjeverna Afrika");
    namesMap.put("017", "Srednja Afrika");
    namesMap.put("018", "Južna Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Sjeverni dio Amerike");
    namesMap.put("029", "Karibi");
    namesMap.put("030", "Istočna Azija");
    namesMap.put("034", "Južna Azija");
    namesMap.put("035", "Jugoistočna Azija");
    namesMap.put("039", "Južna Evropa");
    namesMap.put("053", "Australazija");
    namesMap.put("054", "Melanezija");
    namesMap.put("057", "Mikronezijska regija");
    namesMap.put("061", "Polinezija");
    namesMap.put("142", "Azija");
    namesMap.put("143", "Srednja Azija");
    namesMap.put("145", "Zapadna Azija");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "Istočna Evropa");
    namesMap.put("154", "Sjeverna Evropa");
    namesMap.put("155", "Zapadna Evropa");
    namesMap.put("202", "Subsaharska Afrika");
    namesMap.put("419", "Latinska Amerika");
    namesMap.put("AC", "Ostrvo Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Ujedinjeni Arapski Emirati");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigva i Barbuda");
    namesMap.put("AI", "Angvila");
    namesMap.put("AL", "Albanija");
    namesMap.put("AM", "Armenija");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AS", "Američka Samoa");
    namesMap.put("AT", "Austrija");
    namesMap.put("AU", "Australija");
    namesMap.put("AX", "Olandska ostrva");
    namesMap.put("AZ", "Azerbejdžan");
    namesMap.put("BA", "Bosna i Hercegovina");
    namesMap.put("BD", "Bangladeš");
    namesMap.put("BE", "Belgija");
    namesMap.put("BG", "Bugarska");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "Sveti Bartolomej");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolivija");
    namesMap.put("BQ", "Karipska Holandija");
    namesMap.put("BS", "Bahami");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Ostrvo Buve");
    namesMap.put("BW", "Bocvana");
    namesMap.put("BY", "Bjelorusija");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosova (Keelingova) ostrva");
    namesMap.put("CD", "Demokratska Republika Kongo");
    namesMap.put("CF", "Centralnoafrička Republika");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Švicarska");
    namesMap.put("CI", "Obala Slonovače");
    namesMap.put("CK", "Kukova ostrva");
    namesMap.put("CL", "Čile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CO", "Kolumbija");
    namesMap.put("CP", "Ostrvo Kliperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kape Verde");
    namesMap.put("CW", "Kurasao");
    namesMap.put("CX", "Božićno ostrvo");
    namesMap.put("CY", "Kipar");
    namesMap.put("CZ", "Češka");
    namesMap.put("DE", "Njemačka");
    namesMap.put("DG", "Dijego Garsija");
    namesMap.put("DJ", "Džibuti");
    namesMap.put("DK", "Danska");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikanska Republika");
    namesMap.put("DZ", "Alžir");
    namesMap.put("EA", "Seuta i Melilja");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estonija");
    namesMap.put("EG", "Egipat");
    namesMap.put("EH", "Zapadna Sahara");
    namesMap.put("ER", "Eritreja");
    namesMap.put("ES", "Španija");
    namesMap.put("ET", "Etiopija");
    namesMap.put("EU", "Evropska unija");
    namesMap.put("EZ", "Eurozona");
    namesMap.put("FI", "Finska");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Folklandska ostrva");
    namesMap.put("FM", "Mikronezija");
    namesMap.put("FO", "Farska ostrva");
    namesMap.put("FR", "Francuska");
    namesMap.put("GB", "Velika Britanija");
    namesMap.put("GE", "Gruzija");
    namesMap.put("GF", "Francuska Gvajana");
    namesMap.put("GG", "Gernzi");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grenland");
    namesMap.put("GM", "Gambija");
    namesMap.put("GN", "Gvineja");
    namesMap.put("GP", "Gvadalupe");
    namesMap.put("GQ", "Ekvatorijalna Gvineja");
    namesMap.put("GR", "Grčka");
    namesMap.put("GS", "Južna Džordžija i Južna Sendvič ostrva");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GW", "Gvineja-Bisao");
    namesMap.put("GY", "Gvajana");
    namesMap.put("HK", "Hong Kong (SAR Kina)");
    namesMap.put("HM", "Herd i arhipelag MekDonald");
    namesMap.put("HR", "Hrvatska");
    namesMap.put("HU", "Mađarska");
    namesMap.put("IC", "Kanarska ostrva");
    namesMap.put("ID", "Indonezija");
    namesMap.put("IE", "Irska");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Ostrvo Man");
    namesMap.put("IN", "Indija");
    namesMap.put("IO", "Britanska Teritorija u Indijskom Okeanu");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italija");
    namesMap.put("JM", "Jamajka");
    namesMap.put("KE", "Kenija");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komori");
    namesMap.put("KN", "Sveti Kits i Nevis");
    namesMap.put("KP", "Sjeverna Koreja");
    namesMap.put("KR", "Južna Koreja");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanska ostrva");
    namesMap.put("KZ", "Kazahstan");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sveta Lucija");
    namesMap.put("LI", "Lihtenštajn");
    namesMap.put("LK", "Šri Lanka");
    namesMap.put("LR", "Liberija");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litvanija");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Latvija");
    namesMap.put("LY", "Libija");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavija");
    namesMap.put("ME", "Crna Gora");
    namesMap.put("MF", "Sveti Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Maršalova ostrva");
    namesMap.put("MK", "Makedonija");
    namesMap.put("MM", "Mjanmar");
    namesMap.put("MN", "Mongolija");
    namesMap.put("MO", "Makao (SAR Kina)");
    namesMap.put("MP", "Sjeverna Marijanska ostrva");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritanija");
    namesMap.put("MS", "Monserat");
    namesMap.put("MU", "Mauricijus");
    namesMap.put("MV", "Maldivi");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malezija");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibija");
    namesMap.put("NC", "Nova Kaledonija");
    namesMap.put("NF", "Ostrvo Norfolk");
    namesMap.put("NG", "Nigerija");
    namesMap.put("NI", "Nikaragva");
    namesMap.put("NL", "Holandija");
    namesMap.put("NO", "Norveška");
    namesMap.put("NZ", "Novi Zeland");
    namesMap.put("PF", "Francuska Polinezija");
    namesMap.put("PG", "Papua Nova Gvineja");
    namesMap.put("PH", "Filipini");
    namesMap.put("PL", "Poljska");
    namesMap.put("PM", "Sveti Petar i Mikelon");
    namesMap.put("PN", "Pitkernska Ostrva");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PS", "Palestinska Teritorija");
    namesMap.put("PY", "Paragvaj");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Vanjska Okeanija");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Rumunija");
    namesMap.put("RS", "Srbija");
    namesMap.put("RU", "Rusija");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudijska Arabija");
    namesMap.put("SB", "Solomonska Ostrva");
    namesMap.put("SC", "Sejšeli");
    namesMap.put("SE", "Švedska");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Sveta Helena");
    namesMap.put("SI", "Slovenija");
    namesMap.put("SJ", "Svalbard i Jan Majen");
    namesMap.put("SK", "Slovačka");
    namesMap.put("SL", "Sijera Leone");
    namesMap.put("SO", "Somalija");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Južni Sudan");
    namesMap.put("ST", "Sao Tome i Principe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SX", "Sint Marten");
    namesMap.put("SY", "Sirija");
    namesMap.put("SZ", "Svazilend");
    namesMap.put("TC", "Ostrva Turks i Kaikos");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francuske Južne Teritorije");
    namesMap.put("TH", "Tajland");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TL", "Istočni Timor");
    namesMap.put("TN", "Tunis");
    namesMap.put("TR", "Turska");
    namesMap.put("TT", "Trinidad i Tobago");
    namesMap.put("TW", "Tajvan");
    namesMap.put("TZ", "Tanzanija");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UM", "Američka Vanjska Ostrva");
    namesMap.put("UN", "Ujedinjene Nacije");
    namesMap.put("US", "Sjedinjene Američke Države");
    namesMap.put("UY", "Urugvaj");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Sveti Vinsent i Grenadin");
    namesMap.put("VE", "Venecuela");
    namesMap.put("VG", "Britanska Djevičanska ostrva");
    namesMap.put("VI", "Američka Djevičanska ostrva");
    namesMap.put("VN", "Vijetnam");
    namesMap.put("WF", "Ostrva Valis i Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("YT", "Majote");
    namesMap.put("ZA", "Južnoafrička Republika");
    namesMap.put("ZM", "Zambija");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Nepoznata oblast");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Svijet",
        "002": "Afrika",
        "003": "Sjeverna Amerika",
        "005": "Južna Amerika",
        "009": "Okeanija",
        "011": "Zapadna Afrika",
        "013": "Srednja Amerika",
        "014": "Istočna Afrika",
        "015": "Sjeverna Afrika",
        "017": "Srednja Afrika",
        "018": "Južna Afrika",
        "019": "Amerika",
        "021": "Sjeverni dio Amerike",
        "029": "Karibi",
        "030": "Istočna Azija",
        "034": "Južna Azija",
        "035": "Jugoistočna Azija",
        "039": "Južna Evropa",
        "053": "Australazija",
        "054": "Melanezija",
        "057": "Mikronezijska regija",
        "061": "Polinezija",
        "142": "Azija",
        "143": "Srednja Azija",
        "145": "Zapadna Azija",
        "150": "Evropa",
        "151": "Istočna Evropa",
        "154": "Sjeverna Evropa",
        "155": "Zapadna Evropa",
        "202": "Subsaharska Afrika",
        "419": "Latinska Amerika",
        "AC": "Ostrvo Ascension",
        "AD": "Andora",
        "AE": "Ujedinjeni Arapski Emirati",
        "AF": "Afganistan",
        "AG": "Antigva i Barbuda",
        "AI": "Angvila",
        "AL": "Albanija",
        "AM": "Armenija",
        "AQ": "Antarktika",
        "AS": "Američka Samoa",
        "AT": "Austrija",
        "AU": "Australija",
        "AX": "Olandska ostrva",
        "AZ": "Azerbejdžan",
        "BA": "Bosna i Hercegovina",
        "BD": "Bangladeš",
        "BE": "Belgija",
        "BG": "Bugarska",
        "BH": "Bahrein",
        "BL": "Sveti Bartolomej",
        "BN": "Brunej",
        "BO": "Bolivija",
        "BQ": "Karipska Holandija",
        "BS": "Bahami",
        "BT": "Butan",
        "BV": "Ostrvo Buve",
        "BW": "Bocvana",
        "BY": "Bjelorusija",
        "CA": "Kanada",
        "CC": "Kokosova (Keelingova) ostrva",
        "CD": "Demokratska Republika Kongo",
        "CF": "Centralnoafrička Republika",
        "CG": "Kongo",
        "CH": "Švicarska",
        "CI": "Obala Slonovače",
        "CK": "Kukova ostrva",
        "CL": "Čile",
        "CM": "Kamerun",
        "CN": "Kina",
        "CO": "Kolumbija",
        "CP": "Ostrvo Kliperton",
        "CR": "Kostarika",
        "CU": "Kuba",
        "CV": "Kape Verde",
        "CW": "Kurasao",
        "CX": "Božićno ostrvo",
        "CY": "Kipar",
        "CZ": "Češka",
        "DE": "Njemačka",
        "DG": "Dijego Garsija",
        "DJ": "Džibuti",
        "DK": "Danska",
        "DM": "Dominika",
        "DO": "Dominikanska Republika",
        "DZ": "Alžir",
        "EA": "Seuta i Melilja",
        "EC": "Ekvador",
        "EE": "Estonija",
        "EG": "Egipat",
        "EH": "Zapadna Sahara",
        "ER": "Eritreja",
        "ES": "Španija",
        "ET": "Etiopija",
        "EU": "Evropska unija",
        "EZ": "Eurozona",
        "FI": "Finska",
        "FJ": "Fidži",
        "FK": "Folklandska ostrva",
        "FM": "Mikronezija",
        "FO": "Farska ostrva",
        "FR": "Francuska",
        "GB": "Velika Britanija",
        "GE": "Gruzija",
        "GF": "Francuska Gvajana",
        "GG": "Gernzi",
        "GH": "Gana",
        "GL": "Grenland",
        "GM": "Gambija",
        "GN": "Gvineja",
        "GP": "Gvadalupe",
        "GQ": "Ekvatorijalna Gvineja",
        "GR": "Grčka",
        "GS": "Južna Džordžija i Južna Sendvič ostrva",
        "GT": "Gvatemala",
        "GW": "Gvineja-Bisao",
        "GY": "Gvajana",
        "HK": "Hong Kong (SAR Kina)",
        "HM": "Herd i arhipelag MekDonald",
        "HR": "Hrvatska",
        "HU": "Mađarska",
        "IC": "Kanarska ostrva",
        "ID": "Indonezija",
        "IE": "Irska",
        "IL": "Izrael",
        "IM": "Ostrvo Man",
        "IN": "Indija",
        "IO": "Britanska Teritorija u Indijskom Okeanu",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italija",
        "JM": "Jamajka",
        "KE": "Kenija",
        "KG": "Kirgistan",
        "KH": "Kambodža",
        "KM": "Komori",
        "KN": "Sveti Kits i Nevis",
        "KP": "Sjeverna Koreja",
        "KR": "Južna Koreja",
        "KW": "Kuvajt",
        "KY": "Kajmanska ostrva",
        "KZ": "Kazahstan",
        "LB": "Liban",
        "LC": "Sveta Lucija",
        "LI": "Lihtenštajn",
        "LK": "Šri Lanka",
        "LR": "Liberija",
        "LS": "Lesoto",
        "LT": "Litvanija",
        "LU": "Luksemburg",
        "LV": "Latvija",
        "LY": "Libija",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavija",
        "ME": "Crna Gora",
        "MF": "Sveti Martin",
        "MG": "Madagaskar",
        "MH": "Maršalova ostrva",
        "MK": "Makedonija",
        "MM": "Mjanmar",
        "MN": "Mongolija",
        "MO": "Makao (SAR Kina)",
        "MP": "Sjeverna Marijanska ostrva",
        "MQ": "Martinik",
        "MR": "Mauritanija",
        "MS": "Monserat",
        "MU": "Mauricijus",
        "MV": "Maldivi",
        "MW": "Malavi",
        "MX": "Meksiko",
        "MY": "Malezija",
        "MZ": "Mozambik",
        "NA": "Namibija",
        "NC": "Nova Kaledonija",
        "NF": "Ostrvo Norfolk",
        "NG": "Nigerija",
        "NI": "Nikaragva",
        "NL": "Holandija",
        "NO": "Norveška",
        "NZ": "Novi Zeland",
        "PF": "Francuska Polinezija",
        "PG": "Papua Nova Gvineja",
        "PH": "Filipini",
        "PL": "Poljska",
        "PM": "Sveti Petar i Mikelon",
        "PN": "Pitkernska Ostrva",
        "PR": "Porto Riko",
        "PS": "Palestinska Teritorija",
        "PY": "Paragvaj",
        "QA": "Katar",
        "QO": "Vanjska Okeanija",
        "RE": "Reunion",
        "RO": "Rumunija",
        "RS": "Srbija",
        "RU": "Rusija",
        "RW": "Ruanda",
        "SA": "Saudijska Arabija",
        "SB": "Solomonska Ostrva",
        "SC": "Sejšeli",
        "SE": "Švedska",
        "SG": "Singapur",
        "SH": "Sveta Helena",
        "SI": "Slovenija",
        "SJ": "Svalbard i Jan Majen",
        "SK": "Slovačka",
        "SL": "Sijera Leone",
        "SO": "Somalija",
        "SR": "Surinam",
        "SS": "Južni Sudan",
        "ST": "Sao Tome i Principe",
        "SV": "Salvador",
        "SX": "Sint Marten",
        "SY": "Sirija",
        "SZ": "Svazilend",
        "TC": "Ostrva Turks i Kaikos",
        "TD": "Čad",
        "TF": "Francuske Južne Teritorije",
        "TH": "Tajland",
        "TJ": "Tadžikistan",
        "TL": "Istočni Timor",
        "TN": "Tunis",
        "TR": "Turska",
        "TT": "Trinidad i Tobago",
        "TW": "Tajvan",
        "TZ": "Tanzanija",
        "UA": "Ukrajina",
        "UM": "Američka Vanjska Ostrva",
        "UN": "Ujedinjene Nacije",
        "US": "Sjedinjene Američke Države",
        "UY": "Urugvaj",
        "VA": "Vatikan",
        "VC": "Sveti Vinsent i Grenadin",
        "VE": "Venecuela",
        "VG": "Britanska Djevičanska ostrva",
        "VI": "Američka Djevičanska ostrva",
        "VN": "Vijetnam",
        "WF": "Ostrva Valis i Futuna",
        "YE": "Jemen",
        "YT": "Majote",
        "ZA": "Južnoafrička Republika",
        "ZM": "Zambija",
        "ZW": "Zimbabve",
        "ZZ": "Nepoznata oblast"
    };
  }-*/;
}
