/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockInEllipse;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.image.RotatedEllipse;

class USymbolUsecase
extends USymbol {
    private final boolean isBusiness;

    public USymbolUsecase(boolean isBusiness) {
        this.isBusiness = isBusiness;
    }

    @Override
    public SName[] getSNames() {
        if (this.isBusiness) {
            return new SName[]{SName.usecase, SName.business};
        }
        return new SName[]{SName.usecase};
    }

    private void specialBusiness(UGraphic ug, UEllipse frontier) {
        RotatedEllipse rotatedEllipse = new RotatedEllipse(frontier, 0.7853981633974483);
        double theta1 = 0.3490658503988659;
        double theta2 = rotatedEllipse.getOtherTheta(0.3490658503988659);
        UEllipse frontier2 = frontier.scale(0.99);
        XPoint2D p1 = frontier2.getPointAtAngle(-0.3490658503988659);
        XPoint2D p2 = frontier2.getPointAtAngle(-theta2);
        this.drawLine(ug, p1, p2);
    }

    private void drawLine(UGraphic ug, XPoint2D p1, XPoint2D p2) {
        ug = ug.apply(UTranslate.point(p1));
        ug.draw(new ULine(p2.getX() - p1.getX(), p2.getY() - p1.getY()));
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){
            final TextBlock tmp;
            final TextBlock desc;
            {
                this.tmp = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                this.desc = USymbolUsecase.this.isBusiness ? TextBlockUtils.withMargin(this.tmp, 7.0, 0.0) : this.tmp;
            }

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                ug = symbolContext.apply(ug);
                TextBlockInEllipse ellipse = new TextBlockInEllipse(this.desc, stringBounder);
                MyUGraphicEllipse ug2 = new MyUGraphicEllipse(ug, 0.0, 0.0, ellipse.getUEllipse());
                ellipse.drawU(ug2);
                if (USymbolUsecase.this.isBusiness) {
                    USymbolUsecase.this.specialBusiness(ug, ellipse.getUEllipse());
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        throw new UnsupportedOperationException();
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicEllipse(ug, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic ug, double startingX, double yTheoricalPosition, UEllipse ellipse) {
            super(ug);
            this.startingX = startingX;
            this.ellipse = ellipse;
            this.yTheoricalPosition = yTheoricalPosition;
        }

        private double getNormalized(double y) {
            if (y < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((y -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return y;
        }

        private double getStartingXInternal(double y) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(y));
        }

        private double getEndingXInternal(double y) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(y));
        }

        private Stencil getStencil2(UTranslate translate) {
            final double dy = translate.getDy();
            return new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return this.getStartingXInternal(y + dy);
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return this.getEndingXInternal(y + dy);
                }
            };
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UStroke stroke = UStroke.withThickness(1.5);
            line.drawLineInternal(ug.apply(translate), this.getStencil2(translate), 0.0, stroke);
        }
    }
}

