/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Locale;
import java.util.Map;
import org.jreleaser.util.StringUtils;

public interface Http {
    public String getUsername();

    public String getPassword();

    public Authorization getAuthorization();

    public Map<String, String> getHeaders();

    public static enum Authorization {
        NONE,
        BASIC,
        BEARER;


        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Authorization of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Authorization.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }

    public static enum Method {
        PUT,
        POST;


        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Method of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Method.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

