/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AlwaysEncodeBodyContract;
import feign.DefaultContract;
import feign.Feign;
import feign.FeignIgnore;
import feign.MethodMetadata;
import feign.Request;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Contract {
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> var1);

    @Deprecated
    public static class Default
    extends DefaultContract {
    }

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
            Util.checkState(targetType.getTypeParameters().length == 0, "Parameterized types unsupported: %s", targetType.getSimpleName());
            Util.checkState(targetType.getInterfaces().length <= 1, "Only single inheritance supported: %s", targetType.getSimpleName());
            LinkedHashMap<String, MethodMetadata> result = new LinkedHashMap<String, MethodMetadata>();
            for (Method method : targetType.getMethods()) {
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault(method) || method.isAnnotationPresent(FeignIgnore.class)) continue;
                MethodMetadata metadata = this.parseAndValidateMetadata(targetType, method);
                if (result.containsKey(metadata.configKey())) {
                    Type overridingReturnType;
                    MethodMetadata existingMetadata = (MethodMetadata)result.get(metadata.configKey());
                    Type existingReturnType = existingMetadata.returnType();
                    Type resolvedType = Types.resolveReturnType(existingReturnType, overridingReturnType = metadata.returnType());
                    if (!resolvedType.equals(overridingReturnType)) continue;
                    result.put(metadata.configKey(), metadata);
                    continue;
                }
                result.put(metadata.configKey(), metadata);
            }
            return new ArrayList<MethodMetadata>(result.values());
        }

        @Deprecated
        public MethodMetadata parseAndValidateMetadata(Method method) {
            return this.parseAndValidateMetadata(method.getDeclaringClass(), method);
        }

        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
            MethodMetadata data = new MethodMetadata();
            data.targetType(targetType);
            data.method(method);
            data.returnType(Types.resolve(targetType, targetType, method.getGenericReturnType()));
            data.configKey(Feign.configKey(targetType, method));
            if (AlwaysEncodeBodyContract.class.isAssignableFrom(this.getClass())) {
                data.alwaysEncodeBody(true);
            }
            if (targetType.getInterfaces().length == 1) {
                this.processAnnotationOnClass(data, targetType.getInterfaces()[0]);
            }
            this.processAnnotationOnClass(data, targetType);
            for (Annotation methodAnnotation : method.getAnnotations()) {
                this.processAnnotationOnMethod(data, methodAnnotation, method);
            }
            if (data.isIgnored()) {
                return data;
            }
            Util.checkState(data.template().method() != null, "Method %s not annotated with HTTP method type (ex. GET, POST)%s", data.configKey(), data.warnings());
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int count = parameterAnnotations.length;
            for (int i = 0; i < count; ++i) {
                boolean isHttpAnnotation = false;
                if (parameterAnnotations[i] != null) {
                    isHttpAnnotation = this.processAnnotationsOnParameter(data, parameterAnnotations[i], i);
                }
                if (isHttpAnnotation) {
                    data.ignoreParamater(i);
                }
                if ("kotlin.coroutines.Continuation".equals(parameterTypes[i].getName())) {
                    data.ignoreParamater(i);
                }
                if (parameterTypes[i] == URI.class) {
                    data.urlIndex(i);
                    continue;
                }
                if (isHttpAnnotation || Request.Options.class.isAssignableFrom(parameterTypes[i])) continue;
                if (data.isAlreadyProcessed(i)) {
                    Util.checkState(data.formParams().isEmpty() || data.bodyIndex() == null, "Body parameters cannot be used with form parameters.%s", data.warnings());
                    continue;
                }
                if (data.alwaysEncodeBody()) continue;
                Util.checkState(data.formParams().isEmpty(), "Body parameters cannot be used with form parameters.%s", data.warnings());
                Util.checkState(data.bodyIndex() == null, "Method has too many Body parameters: %s%s", method, data.warnings());
                data.bodyIndex(i);
                data.bodyType(Types.resolve(targetType, targetType, genericParameterTypes[i]));
            }
            if (data.headerMapIndex() != null && Map.class.isAssignableFrom(parameterTypes[data.headerMapIndex()])) {
                BaseContract.checkMapKeys("HeaderMap", genericParameterTypes[data.headerMapIndex()]);
            }
            if (data.queryMapIndex() != null && Map.class.isAssignableFrom(parameterTypes[data.queryMapIndex()])) {
                BaseContract.checkMapKeys("QueryMap", genericParameterTypes[data.queryMapIndex()]);
            }
            return data;
        }

        private static void checkMapString(String name, Class<?> type, Type genericType) {
            Util.checkState(Map.class.isAssignableFrom(type), "%s parameter must be a Map: %s", name, type);
            BaseContract.checkMapKeys(name, genericType);
        }

        private static void checkMapKeys(String name, Type genericType) {
            Class keyClass = null;
            if (ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
                Type[] parameterTypes = ((ParameterizedType)genericType).getActualTypeArguments();
                keyClass = (Class)parameterTypes[0];
            } else if (genericType instanceof Class) {
                Type[] interfaces;
                for (Type extended : interfaces = ((Class)genericType).getGenericInterfaces()) {
                    if (!ParameterizedType.class.isAssignableFrom(extended.getClass())) continue;
                    Type[] parameterTypes = ((ParameterizedType)extended).getActualTypeArguments();
                    keyClass = (Class)parameterTypes[0];
                    break;
                }
            }
            if (keyClass != null) {
                Util.checkState(String.class.equals(keyClass), "%s key must be a String: %s", name, keyClass.getSimpleName());
            }
        }

        protected abstract void processAnnotationOnClass(MethodMetadata var1, Class<?> var2);

        protected abstract void processAnnotationOnMethod(MethodMetadata var1, Annotation var2, Method var3);

        protected abstract boolean processAnnotationsOnParameter(MethodMetadata var1, Annotation[] var2, int var3);

        protected void nameParam(MethodMetadata data, String name, int i) {
            ArrayList<String> names = data.indexToName().containsKey(i) ? data.indexToName().get(i) : new ArrayList<String>();
            names.add(name);
            data.indexToName().put(i, names);
        }
    }
}

