/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
public enum DigestAlgorithm {
    SHA1("SHA-1"),
    MD5("MD5"),
    SHA256("SHA-256"),
    SHA512("SHA-512");

    private static final Supplier<MessageDigest> CLOSED_DIGEST;
    private static final int MAX_CACHED_DIGESTS = 10000;
    private final String algorithmName;
    private final Deque<MessageDigest> digestCache = new LinkedBlockingDeque<MessageDigest>(10000);

    private DigestAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public CloseableMessageDigest getDigest() {
        MessageDigest digest = this.digestCache.pollFirst();
        if (digest != null) {
            digest.reset();
            return new CloseableMessageDigest(digest);
        }
        return new CloseableMessageDigest(this.newDigest());
    }

    private MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to fetch message digest instance for Algorithm " + this.algorithmName + ": " + e.getMessage(), e);
        }
    }

    @SdkTestInternalApi
    static void clearCaches() {
        for (DigestAlgorithm value : DigestAlgorithm.values()) {
            value.digestCache.clear();
        }
    }

    static {
        CLOSED_DIGEST = () -> {
            throw new IllegalStateException("This message digest is closed.");
        };
    }

    public final class CloseableMessageDigest
    implements SdkAutoCloseable,
    Cloneable {
        private Supplier<MessageDigest> digest = () -> digest;
        private byte[] messageDigest;

        private CloseableMessageDigest(MessageDigest digest) {
        }

        public MessageDigest messageDigest() {
            return this.digest.get();
        }

        public byte[] digest() {
            if (this.messageDigest != null) {
                return this.messageDigest;
            }
            this.messageDigest = this.messageDigest().digest();
            this.close();
            return this.messageDigest;
        }

        public void close() {
            if (this.digest == CLOSED_DIGEST) {
                return;
            }
            DigestAlgorithm.this.digestCache.offerFirst(this.digest.get());
            this.digest = CLOSED_DIGEST;
        }

        public CloseableMessageDigest clone() {
            try {
                return new CloseableMessageDigest((MessageDigest)this.digest.get().clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Clone was not supported by this digest type.", e);
            }
        }
    }
}

