/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.ConstructorCache;
import software.amazon.awssdk.checksums.internal.CrcCloneOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.CrcCombineOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.SdkCrc32CChecksum;
import software.amazon.awssdk.checksums.internal.XxHashChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.crt.checksums.CRC32C;
import software.amazon.awssdk.crt.checksums.CRC64NVME;
import software.amazon.awssdk.utils.ClassLoaderHelper;
import software.amazon.awssdk.utils.Lazy;

@SdkInternalApi
public final class ChecksumProvider {
    private static final String CRT_CRC32C_CLASS_PATH = "software.amazon.awssdk.crt.checksums.CRC32C";
    private static final String JAVA_CRC32C_CLASS_PATH = "java.util.zip.CRC32C";
    private static final ConstructorCache CONSTRUCTOR_CACHE = new ConstructorCache();
    private static final String CRT_CRC64NVME_PATH = "software.amazon.awssdk.crt.checksums.CRC64NVME";
    private static final String CRT_XXHASH_PATH = "software.amazon.awssdk.crt.checksums.XXHash";
    private static final String CRT_MODULE = "software.amazon.awssdk.crt:aws-crt";
    private static Lazy<Boolean> isXxHashAvailable = ChecksumProvider.checkCrtAvailability("software.amazon.awssdk.crt.checksums.XXHash");
    private static Lazy<Boolean> isCrc64NvmeAvailable = ChecksumProvider.checkCrtAvailability("software.amazon.awssdk.crt.checksums.CRC64NVME");
    private static Lazy<Boolean> isCrc32CAvailable = ChecksumProvider.checkCrtAvailability("software.amazon.awssdk.crt.checksums.CRC32C");

    private ChecksumProvider() {
    }

    private static Lazy<Boolean> checkCrtAvailability(String fqcn) {
        return new Lazy(() -> {
            try {
                ClassLoaderHelper.loadClass((String)fqcn, (boolean)false, (Class[])new Class[0]);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        });
    }

    static SdkChecksum createSdkBasedCrc32C() {
        SdkCrc32CChecksum sdkChecksum = SdkCrc32CChecksum.create();
        return new CrcCloneOnMarkChecksum(sdkChecksum);
    }

    public static SdkChecksum crc32cImplementation() {
        SdkChecksum checksum = ChecksumProvider.createJavaCrc32C();
        if (checksum == null) {
            checksum = ChecksumProvider.createCrtCrc32C();
        }
        return checksum != null ? checksum : ChecksumProvider.createSdkBasedCrc32C();
    }

    static SdkChecksum createCrtCrc32C() {
        if (!((Boolean)isCrc32CAvailable.getValue()).booleanValue()) {
            return null;
        }
        CRC32C checksumInstance = new CRC32C();
        return new CrcCloneOnMarkChecksum((Checksum)checksumInstance);
    }

    static SdkChecksum crc64NvmeCrtImplementation() {
        if (!((Boolean)isCrc64NvmeAvailable.getValue()).booleanValue()) {
            throw new RuntimeException("Could not load software.amazon.awssdk.crt.checksums.CRC64NVME. Add dependency on 'software.amazon.awssdk.crt:aws-crt' module to enable CRC64NVME feature.");
        }
        return new CrcCloneOnMarkChecksum((Checksum)new CRC64NVME());
    }

    public static SdkChecksum xxHash64CrtImplementation() {
        return ChecksumProvider.crtXxHash(DefaultChecksumAlgorithm.XXHASH64);
    }

    public static SdkChecksum xxHash3CrtImplementation() {
        return ChecksumProvider.crtXxHash(DefaultChecksumAlgorithm.XXHASH3);
    }

    public static SdkChecksum xxHash128CrtImplementation() {
        return ChecksumProvider.crtXxHash(DefaultChecksumAlgorithm.XXHASH128);
    }

    static SdkChecksum crtXxHash(ChecksumAlgorithm algorithm) {
        if (!((Boolean)isXxHashAvailable.getValue()).booleanValue()) {
            throw new RuntimeException(String.format("Could not load %s for algorithm: %s. Add dependency on '%s' module.", CRT_XXHASH_PATH, algorithm.algorithmId(), CRT_MODULE));
        }
        return new XxHashChecksum(algorithm);
    }

    static SdkChecksum createJavaCrc32C() {
        return CONSTRUCTOR_CACHE.getConstructor(JAVA_CRC32C_CLASS_PATH).map(constructor -> {
            try {
                return new CrcCombineOnMarkChecksum((Checksum)constructor.newInstance(new Object[0]), SdkCrc32CChecksum::combine);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate java.util.zip.CRC32C", e);
            }
        }).orElse(null);
    }
}

