/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Http;
import org.jreleaser.model.internal.common.HttpDelegate;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public final class ArtifactoryUploader
extends AbstractUploader<org.jreleaser.model.api.upload.ArtifactoryUploader, ArtifactoryUploader>
implements Http {
    private static final long serialVersionUID = 3514827122618864142L;
    private final HttpDelegate delegate = new HttpDelegate();
    private final List<ArtifactoryRepository> repositories = new ArrayList<ArtifactoryRepository>();
    private String host;
    @JsonIgnore
    private final org.jreleaser.model.api.upload.ArtifactoryUploader immutable = new org.jreleaser.model.api.upload.ArtifactoryUploader(){
        private static final long serialVersionUID = -2363532627193458751L;
        private List<? extends ArtifactoryUploader.ArtifactoryRepository> repositories;

        public String getHost() {
            return ArtifactoryUploader.this.host;
        }

        public String getUsername() {
            return ArtifactoryUploader.this.getUsername();
        }

        public String getPassword() {
            return ArtifactoryUploader.this.getPassword();
        }

        public Http.Authorization getAuthorization() {
            return ArtifactoryUploader.this.getAuthorization();
        }

        public List<? extends ArtifactoryUploader.ArtifactoryRepository> getRepositories() {
            if (null == this.repositories) {
                this.repositories = ArtifactoryUploader.this.repositories.stream().map(ArtifactoryRepository::asImmutable).collect(Collectors.toList());
            }
            return this.repositories;
        }

        public String getType() {
            return ArtifactoryUploader.this.getType();
        }

        public String getName() {
            return ArtifactoryUploader.this.getName();
        }

        public boolean isSnapshotSupported() {
            return ArtifactoryUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return ArtifactoryUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return ArtifactoryUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return ArtifactoryUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return ArtifactoryUploader.this.isChecksums();
        }

        public boolean isCatalogs() {
            return ArtifactoryUploader.this.isCatalogs();
        }

        public Active getActive() {
            return ArtifactoryUploader.this.getActive();
        }

        public boolean isEnabled() {
            return ArtifactoryUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArtifactoryUploader.this.asMap(full));
        }

        public String getPrefix() {
            return ArtifactoryUploader.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ArtifactoryUploader.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return ArtifactoryUploader.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return ArtifactoryUploader.this.getReadTimeout();
        }
    };

    public ArtifactoryUploader() {
        super("artifactory");
    }

    @Override
    public org.jreleaser.model.api.upload.ArtifactoryUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ArtifactoryUploader source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.delegate.merge(source.delegate);
        this.setRepositories(this.merge(this.repositories, source.repositories));
    }

    public Map<String, String> getHeaders() {
        return this.delegate.getHeaders();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public Http.Authorization getAuthorization() {
        return this.delegate.getAuthorization();
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.delegate.setAuthorization(authorization);
    }

    @Override
    public void setAuthorization(String authorization) {
        this.delegate.setAuthorization(authorization);
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        if (null == this.delegate.getAuthorization()) {
            this.delegate.setAuthorization(Http.Authorization.BEARER);
        }
        return this.delegate.getAuthorization();
    }

    public List<ArtifactoryRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<ArtifactoryRepository> repositories) {
        this.repositories.clear();
        this.repositories.addAll(repositories);
    }

    public void addRepository(ArtifactoryRepository repository) {
        if (null != repository) {
            this.repositories.add(repository);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        this.delegate.asMap(props);
        List repositories = this.repositories.stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!repositories.isEmpty()) {
            props.put("repositories", repositories);
        }
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context, context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, TemplateContext props, Artifact artifact) {
        return this.resolveUrl(context, props, artifact);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context, context.fullProps(), artifact);
    }

    private String resolveUrl(JReleaserContext context, TemplateContext props, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
        p.set("artifactoryHost", (Object)this.host);
        Optional<ArtifactoryRepository> repository = this.repositories.stream().filter(r -> r.handles(artifact)).findFirst();
        if (repository.isPresent()) {
            p.set("repositoryPath", (Object)repository.get().getPath());
            String url = "{{artifactoryHost}}/{{repositoryPath}}";
            return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)url, (TemplateContext)p);
        }
        return "";
    }

    public static final class ArtifactoryRepository
    extends AbstractActivatable<ArtifactoryRepository>
    implements Domain {
        private static final long serialVersionUID = -8740453953809523210L;
        private final Set<FileType> fileTypes = new LinkedHashSet<FileType>();
        private String path;
        @JsonIgnore
        private final ArtifactoryUploader.ArtifactoryRepository immutable = new ArtifactoryUploader.ArtifactoryRepository(){
            private static final long serialVersionUID = -954690979964972109L;

            public String getPath() {
                return path;
            }

            public Set<FileType> getFileTypes() {
                return Collections.unmodifiableSet(this.getFileTypes());
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public ArtifactoryUploader.ArtifactoryRepository asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(ArtifactoryRepository source) {
            super.merge(source);
            this.path = this.merge(this.path, source.path);
            this.setFileTypes(source.fileTypes);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Set<FileType> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(Set<FileType> fileTypes) {
            this.fileTypes.clear();
            this.fileTypes.addAll(fileTypes);
        }

        public void addFileType(FileType fileType) {
            this.fileTypes.add(fileType);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("active", this.getActive());
            map.put("path", this.path);
            map.put("fileTypes", this.fileTypes);
            return map;
        }

        public boolean handles(Artifact artifact) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.fileTypes.isEmpty()) {
                return true;
            }
            String artifactFileName = artifact.getResolvedPath().getFileName().toString();
            String artifactName = StringUtils.getFilename((String)artifactFileName, (Collection)FileType.getSupportedExtensions());
            String archiveFormat = artifactFileName.substring(artifactName.length() + 1);
            FileType fileType = FileType.of((String)archiveFormat);
            return this.fileTypes.contains(fileType);
        }
    }
}

