/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.packagers.DockerConfiguration;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public interface DockerConfiguration
extends Domain,
ExtraProperties,
Activatable {
    public static final String TYPE = "docker";
    public static final String DEFAULT_ENTRYPOINT = "[\"/{{distributionArtifactRootEntryName}}/bin/{{distributionExecutableUnix}}\"]";

    public String getTemplateDirectory();

    public void setTemplateDirectory(String var1);

    public List<String> getSkipTemplates();

    public void setSkipTemplates(List<String> var1);

    public void addSkipTemplates(List<String> var1);

    public void addSkipTemplate(String var1);

    public String getBaseImage();

    public void setBaseImage(String var1);

    public String getEntrypoint();

    public void setEntrypoint(String var1);

    public String getCmd();

    public void setCmd(String var1);

    public Map<String, String> getLabels();

    public void setLabels(Map<String, String> var1);

    public void addLabels(Map<String, String> var1);

    public void addLabel(String var1, String var2);

    public Set<String> getImageNames();

    public void setImageNames(Set<String> var1);

    public void addImageName(String var1);

    public List<String> getBuildArgs();

    public void setBuildArgs(List<String> var1);

    public void addBuildArg(String var1);

    public List<String> getPreCommands();

    public void setPreCommands(List<String> var1);

    public List<String> getPostCommands();

    public void setPostCommands(List<String> var1);

    public Set<? extends Registry> getRegistries();

    public void setRegistries(Set<? extends Registry> var1);

    public void addRegistry(Registry var1);

    public boolean isUseLocalArtifact();

    public void setUseLocalArtifact(Boolean var1);

    public boolean isUseLocalArtifactSet();

    public DockerConfiguration.DockerCommand getCommand();

    public void setCommand(DockerConfiguration.DockerCommand var1);

    public void setCommand(String var1);

    public Buildx getBuildx();

    public void setBuildx(Buildx var1);

    public static final class Buildx
    extends AbstractModelObject<Buildx>
    implements Domain {
        private static final long serialVersionUID = -1508943969111212467L;
        private final List<String> createBuilderFlags = new ArrayList<String>();
        private final List<String> platforms = new ArrayList<String>();
        private Boolean enabled;
        private Boolean createBuilder;
        @JsonIgnore
        private final DockerConfiguration.Buildx immutable = new DockerConfiguration.Buildx(){
            private static final long serialVersionUID = -6178190371465420854L;

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public boolean isCreateBuilder() {
                return this.isCreateBuilder();
            }

            public List<String> getCreateBuilderFlags() {
                return Collections.unmodifiableList(createBuilderFlags);
            }

            public List<String> getPlatforms() {
                return Collections.unmodifiableList(platforms);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public DockerConfiguration.Buildx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Buildx source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.createBuilder = this.merge(this.createBuilder, source.createBuilder);
            this.setCreateBuilderFlags(this.merge(this.createBuilderFlags, source.createBuilderFlags));
            this.setPlatforms(this.merge(this.platforms, source.platforms));
        }

        public List<String> getCreateBuilderFlags() {
            return this.createBuilderFlags;
        }

        public void setCreateBuilderFlags(List<String> createBuilderFlags) {
            this.createBuilderFlags.clear();
            this.createBuilderFlags.addAll(createBuilderFlags);
        }

        public List<String> getPlatforms() {
            return this.platforms;
        }

        public void setPlatforms(List<String> platforms) {
            this.platforms.clear();
            this.platforms.addAll(platforms);
        }

        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public boolean isCreateBuilder() {
            return null == this.createBuilder || this.createBuilder != false;
        }

        public void setCreateBuilder(Boolean createBuilder) {
            this.createBuilder = createBuilder;
        }

        public boolean isCreateBuilderSet() {
            return null != this.createBuilder;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("createBuilder", this.isCreateBuilder());
            map.put("createBuilderFlags", this.createBuilderFlags);
            map.put("platforms", this.platforms);
            return map;
        }
    }

    public static final class Registry
    extends AbstractActivatable<Registry>
    implements Domain,
    Comparable<Registry> {
        public static final String DEFAULT_NAME = "DEFAULT";
        private static final long serialVersionUID = -1752312309985279497L;
        private String server;
        private String serverName = "DEFAULT";
        private String repositoryName;
        private String username;
        private String password;
        private Boolean externalLogin;
        @JsonIgnore
        private final DockerConfiguration.Registry immutable = new DockerConfiguration.Registry(){
            private static final long serialVersionUID = -5747348498530533170L;

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public String getServer() {
                return server;
            }

            public String getServerName() {
                return serverName;
            }

            public String getRepositoryName() {
                return repositoryName;
            }

            public String getUsername() {
                return username;
            }

            public String getPassword() {
                return password;
            }

            public boolean isExternalLogin() {
                return this.isExternalLogin();
            }

            public int compareTo(DockerConfiguration.Registry o) {
                if (null == o) {
                    return -1;
                }
                return serverName.compareTo(o.getServerName());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public DockerConfiguration.Registry asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Registry source) {
            super.merge(source);
            this.server = this.merge(this.server, source.server);
            this.serverName = this.merge(this.serverName, source.serverName);
            this.repositoryName = this.merge(this.repositoryName, source.repositoryName);
            this.username = this.merge(this.username, source.username);
            this.password = this.merge(this.password, source.password);
            this.externalLogin = this.merge(this.externalLogin, source.externalLogin);
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isExternalLogin() {
            return null != this.externalLogin && this.externalLogin != false;
        }

        public void setExternalLogin(Boolean externalLogin) {
            this.externalLogin = externalLogin;
        }

        public boolean isExternalLoginSet() {
            return null != this.externalLogin;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("active", this.getActive());
            map.put("server", this.server);
            map.put("serverName", this.serverName);
            map.put("repositoryName", this.repositoryName);
            map.put("username", this.username);
            map.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
            map.put("externalLogin", this.isExternalLogin());
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Registry that = (Registry)o;
            String sn1 = this.serverName.equals(DEFAULT_NAME) ? "docker.io" : this.serverName;
            String sn2 = that.serverName.equals(DEFAULT_NAME) ? "docker.io" : that.serverName;
            return sn1.equals(sn2);
        }

        public int hashCode() {
            return Objects.hash(this.serverName.equals(DEFAULT_NAME) ? "docker.io" : this.serverName);
        }

        @Override
        public int compareTo(Registry o) {
            if (null == o) {
                return -1;
            }
            String sn1 = this.serverName.equals(DEFAULT_NAME) ? "docker.io" : this.serverName;
            String sn2 = o.serverName.equals(DEFAULT_NAME) ? "docker.io" : o.serverName;
            return sn1.compareTo(sn2);
        }
    }
}

