/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import org.gradle.api.Describable;

public class InstallationLocation
implements Describable {
    private final File location;
    private final String source;
    private final boolean autoDetected;
    private final boolean autoProvisioned;

    public static InstallationLocation userDefined(File location, String source) {
        return new InstallationLocation(location, source, false, false);
    }

    public static InstallationLocation autoDetected(File location, String source) {
        return new InstallationLocation(location, source, true, false);
    }

    public static InstallationLocation autoProvisioned(File location, String source) {
        return new InstallationLocation(location, source, true, true);
    }

    private InstallationLocation(File location, String source, boolean autoDetected, boolean autoProvisioned) {
        this.location = location;
        this.source = source;
        this.autoDetected = autoDetected;
        this.autoProvisioned = autoProvisioned;
    }

    public File getLocation() {
        return this.location;
    }

    public String getDisplayName() {
        return "'" + this.location.getAbsolutePath() + "' (" + this.source + ")" + (this.autoDetected ? " auto-detected" : "") + (this.autoProvisioned ? " auto-provisioned" : "");
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean isAutoDetected() {
        return this.autoDetected;
    }

    public boolean isAutoProvisioned() {
        return this.autoProvisioned;
    }

    public InstallationLocation withLocation(File location) {
        return new InstallationLocation(location, this.source, this.autoDetected, this.autoProvisioned);
    }
}

