/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.SimpleBufferSource;
import com.terracottatech.frs.io.WrappingChunk;
import com.terracottatech.frs.io.nio.FileChannelReadOpener;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.MappedReadbackStrategy;
import com.terracottatech.frs.io.nio.MinimalReadbackStrategy;
import com.terracottatech.frs.io.nio.NIOAccessMethod;
import com.terracottatech.frs.io.nio.NIOSegment;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.io.nio.PositionLostException;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.WrappedFileChannel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class ReadOnlySegment
extends NIOSegment
implements Closeable {
    private FileChannel source;
    private final FileChannelReadOpener opener;
    private final NIOAccessMethod method;
    private ReadbackStrategy strategy;
    private final Direction dir;
    private volatile long length = 0L;

    ReadOnlySegment(NIOStreamImpl parent, NIOAccessMethod strat, File buffer, Direction dir) throws IOException, HeaderException {
        super(parent, buffer);
        this.dir = dir;
        this.method = strat;
        this.opener = new FileChannelReadOpener(this.getFile());
    }

    public synchronized ReadOnlySegment load(BufferSource src) throws IOException {
        if (this.strategy == null) {
            if (src == null) {
                src = new SimpleBufferSource();
            }
            try {
                this.strategy = this.dir == Direction.RANDOM ? this.openForRandomAccess(src) : this.openForReplay(src);
            }
            catch (HeaderException h) {
                throw new IOException(h);
            }
        }
        return this;
    }

    private void readFullyFirstBytes(ByteBuffer buffer) throws IOException {
        int startPosition = buffer.position();
        while (buffer.hasRemaining()) {
            try {
                this.source.read(buffer);
            }
            catch (PositionLostException e) {
                this.source.position(buffer.position() - startPosition);
            }
        }
    }

    private ReadbackStrategy openForReplay(BufferSource src) throws IOException, HeaderException {
        this.source = new WrappedFileChannel(this.opener.open(), this.opener);
        this.length = this.source.size();
        if (this.length < 42L) {
            throw new HeaderException("bad header", this);
        }
        ByteBuffer header = src.getBuffer(42);
        this.readFullyFirstBytes(header);
        header.flip();
        this.readFileHeader(new WrappingChunk(header));
        src.returnBuffer(header);
        while (true) {
            try {
                if (this.method == NIOAccessMethod.MAPPED) {
                    return new MappedReadbackStrategy(this.source, Direction.REVERSE, this.opener);
                }
                if (this.method == NIOAccessMethod.STREAM) {
                    return new MinimalReadbackStrategy(Direction.REVERSE, this.getMinimumMarker(), this.source, src, this.opener);
                }
                throw new RuntimeException("unrecognized readback method");
            }
            catch (PositionLostException e) {
                this.source.position(42L);
                continue;
            }
            break;
        }
    }

    private ReadbackStrategy openForRandomAccess(BufferSource src) throws IOException, HeaderException {
        this.source = new WrappedFileChannel(this.opener.open(), this.opener);
        this.length = this.source.size();
        if (this.length < 42L) {
            throw new HeaderException("bad header", this);
        }
        ByteBuffer header = src.getBuffer(42);
        this.readFullyFirstBytes(header);
        header.flip();
        this.readFileHeader(new WrappingChunk(header));
        src.returnBuffer(header);
        while (true) {
            try {
                if (this.method == NIOAccessMethod.MAPPED) {
                    return new MappedReadbackStrategy(this.source, Direction.RANDOM, this.opener);
                }
                if (this.method == NIOAccessMethod.STREAM) {
                    return new MinimalReadbackStrategy(Direction.RANDOM, this.getMinimumMarker(), this.source, src, this.opener);
                }
                throw new RuntimeException("unrecognized readback method");
            }
            catch (PositionLostException ple) {
                this.source.position(42L);
                continue;
            }
            break;
        }
    }

    public Chunk scan(long marker) throws IOException {
        return this.strategy.scan(marker);
    }

    public long getMaximumMarker() throws IOException {
        return this.strategy.getMaximumMarker();
    }

    public boolean isClosed() {
        return this.strategy == null;
    }

    public boolean isComplete() {
        return this.strategy.isConsistent();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.strategy instanceof Closeable) {
            ((Closeable)((Object)this.strategy)).close();
        } else {
            this.opener.close();
        }
        this.strategy = null;
        this.source = null;
    }

    @Override
    public String toString() {
        return "ReadOnlySegment{strategy=" + this.strategy + "}\n\t" + super.toString();
    }

    public Chunk next(Direction dir) throws IOException {
        if (this.strategy.hasMore(dir)) {
            return this.strategy.iterate(dir);
        }
        throw new IOException("segment bounds");
    }

    public boolean hasMore(Direction dir) throws IOException {
        return this.strategy.hasMore(dir);
    }

    @Override
    public long size() {
        try {
            return this.strategy.size();
        }
        catch (IOException ioe) {
            return -1L;
        }
    }
}

