/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqsequence;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemBaseIterator;
import net.xqj.core.xqsequence.XQSequenceBase;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public final class ForwardOnlyXQSequence
extends XQSequenceBase {
    protected XQItemBaseIterator iterator;
    protected XQItemBase currentItem;
    protected XQItemType currentItemType;
    protected boolean currentItemRetrieved = false;
    protected boolean isOnItem = false;

    private ForwardOnlyXQSequence(XQItemBaseIterator iterator) {
        this.iterator = iterator;
    }

    private ForwardOnlyXQSequence() {
    }

    static ForwardOnlyXQSequence newInstance(XQItemBaseIterator iterator) {
        return new ForwardOnlyXQSequence(iterator);
    }

    static ForwardOnlyXQSequence newInstance() {
        return new ForwardOnlyXQSequence();
    }

    @Override
    public final boolean absolute(int itempos) throws XQException {
        throw new XQExceptionImpl("Can not call absolute(int) on Forward Only Sequences.", "XQJFOS001");
    }

    @Override
    public final void afterLast() throws XQException {
        throw new XQExceptionImpl("Can not call afterLast() on Forward Only Sequences.", "XQJFOS002");
    }

    @Override
    public final void beforeFirst() throws XQException {
        throw new XQExceptionImpl("Can not call beforeFirst() on Forward Only Sequences.", "XQJFOS003");
    }

    @Override
    public final void close() throws XQException {
        this.isOnItem = false;
        if (this.currentItem != null) {
            this.currentItem.close();
        }
        this.currentItem = null;
        this.currentItemType = null;
    }

    @Override
    public final int count() throws XQException {
        throw new XQExceptionImpl("Can not call count() on Forward Only Sequences.", "XQJFOS006");
    }

    @Override
    public final int getPosition() throws XQException {
        throw new XQExceptionImpl("Can not call getPosition() on Forward Only Sequences.", "XQJFOS007");
    }

    @Override
    public final boolean isOnItem() throws XQException {
        return this.isOnItem;
    }

    @Override
    public final boolean isScrollable() throws XQException {
        return false;
    }

    @Override
    public final boolean first() throws XQException {
        throw new XQExceptionImpl("Can not call first() on Forward Only Sequences.", "XQJFOS008");
    }

    @Override
    public final XQItem getItem() throws XQException {
        if (this.isOnItem() && !this.currentItemRetrieved) {
            this.currentItemRetrieved = true;
            return this.currentItem;
        }
        if (!this.isOnItem()) {
            throw new XQExceptionImpl("FORWARD_ONLY_SEQUENCE: Cursor is not positioned on an XQItem.", "XQJFOS009");
        }
        throw new XQExceptionImpl("FORWARD_ONLY_SEQUENCE: The current item has already been retrieved.", "XQJFOS018");
    }

    @Override
    public XQItemBase getItemIdentity() throws XQException {
        if (this.isOnItem()) {
            return this.currentItem;
        }
        throw new XQExceptionImpl("FORWARD_ONLY_SEQUENCE: Cursor is not positioned on an XQItem.", "XQJFOS021");
    }

    @Override
    public final boolean isAfterLast() throws XQException {
        throw new XQExceptionImpl("Can not call isAfterLast() on Forward Only Sequences.", "XQJFOS010");
    }

    @Override
    public final boolean isBeforeFirst() throws XQException {
        throw new XQExceptionImpl("Can not call isBeforeFirst() on Forward Only Sequences.", "XQJFOS011");
    }

    @Override
    public final boolean isFirst() throws XQException {
        throw new XQExceptionImpl("Can not call isFirst() on Forward Only Sequences.", "XQJFOS012");
    }

    @Override
    public final boolean isLast() throws XQException {
        throw new XQExceptionImpl("Can not call isLast() on Forward Only Sequences.", "XQJFOS013");
    }

    @Override
    public final boolean last() throws XQException {
        throw new XQExceptionImpl("Can not call last() on Forward Only Sequences.", "XQJFOS014");
    }

    @Override
    public XQItemType getItemType() throws XQException {
        if (this.isOnItem()) {
            return this.currentItemType;
        }
        throw new XQExceptionImpl("Can not call getItemType() when Forward Only Sequences is not positioned on an item.", "XQJFOS017");
    }

    @Override
    public URI getNodeUri() throws XQException {
        return this.currentItem.getNodeUri();
    }

    @Override
    public final boolean next() throws XQException {
        XQItemBase base = this.iterator.next();
        if (base != null) {
            this.currentItem = base;
            this.currentItemType = this.currentItem.getItemType();
            this.currentItemRetrieved = false;
            this.isOnItem = true;
            return true;
        }
        this.isOnItem = false;
        return false;
    }

    @Override
    public final boolean previous() throws XQException {
        throw new XQExceptionImpl("Can not call previous() on Forward Only Sequences.", "XQJFOS015");
    }

    @Override
    public final boolean relative(int itempos) throws XQException {
        throw new XQExceptionImpl("Can not call relative(int) on Forward Only Sequences.", "XQJFOS016");
    }

    @Override
    public boolean instanceOf(XQItemType type) throws XQException {
        return XQToolkit.isInstanceOf(type, this.currentItemType);
    }

    public String toString() {
        return "ForwardOnlyXQSequence-" + this.instanceId;
    }

    private void setRetrieved() throws XQException {
        if (this.currentItemRetrieved) {
            throw new XQExceptionImpl("FORWARD_ONLY_SEQUENCE: The current item has already been retrieved.", "XQJFOS020");
        }
        this.currentItemRetrieved = true;
    }

    @Override
    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.setRetrieved();
        return super.getSequenceAsStream();
    }

    @Override
    public String getSequenceAsString(Properties properties) throws XQException {
        this.setRetrieved();
        return super.getSequenceAsString(properties);
    }

    @Override
    public void writeSequence(OutputStream out, Properties properties) throws XQException {
        this.setRetrieved();
        super.writeSequence(out, properties);
    }

    @Override
    public void writeSequence(Writer writer, Properties properties) throws XQException {
        this.setRetrieved();
        super.writeSequence(writer, properties);
    }

    @Override
    public void writeSequenceToSAX(ContentHandler saxhdlr) throws XQException {
        this.setRetrieved();
        super.writeSequenceToSAX(saxhdlr);
    }

    @Override
    public boolean getBoolean() throws XQException {
        this.setRetrieved();
        return super.getBoolean();
    }

    @Override
    public byte getByte() throws XQException {
        this.setRetrieved();
        return super.getByte();
    }

    @Override
    public double getDouble() throws XQException {
        this.setRetrieved();
        return super.getDouble();
    }

    @Override
    public float getFloat() throws XQException {
        this.setRetrieved();
        return super.getFloat();
    }

    @Override
    public int getInt() throws XQException {
        this.setRetrieved();
        return super.getInt();
    }

    @Override
    public String getAtomicValue() throws XQException {
        this.setRetrieved();
        return super.getAtomicValue();
    }

    @Override
    public long getLong() throws XQException {
        this.setRetrieved();
        return super.getLong();
    }

    @Override
    public Node getNode() throws XQException {
        this.setRetrieved();
        return super.getNode();
    }

    @Override
    public Object getObject() throws XQException {
        this.setRetrieved();
        return super.getObject();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        this.setRetrieved();
        return super.getItemAsStream();
    }

    @Override
    public String getItemAsString(Properties properties) throws XQException {
        this.setRetrieved();
        return super.getItemAsString(properties);
    }

    @Override
    public short getShort() throws XQException {
        this.setRetrieved();
        return super.getShort();
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.setRetrieved();
        super.writeItem(out, properties);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.setRetrieved();
        super.writeItem(writer, properties);
    }

    @Override
    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        this.setRetrieved();
        super.writeItemToSAX(saxhdlr);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        this.setRetrieved();
        super.writeItemToResult(result);
    }

    @Override
    public void reset(XQItemBaseIterator iterator) throws XQException {
        this.iterator = iterator;
        this.currentItem = null;
        this.currentItemType = null;
        this.currentItemRetrieved = false;
        this.isOnItem = false;
    }
}

