/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.registry.internal.TMScope;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.utils.GrammarUtils;
import org.eclipse.tm4e.ui.text.ITMPartitionRegion;
import org.eclipse.tm4e.ui.text.ITMPartitioner;

public final class TMPartitioner
implements ITMPartitioner {
    private static final String TEXT_UNKNOWN = "text.unknown";
    private volatile String basePartitionType = "tm4e:base";
    private final TreeMap<Integer, TMPartitionRegion> partitions = new TreeMap();
    private final Set<String> legalTypes = new HashSet<String>();
    private final ReadWriteLock partitionsLock = new ReentrantReadWriteLock();
    private final ModelTokensChangedEvent.Listener modelListener = this::onTokensChanged;
    private volatile boolean activated;
    private final Object activationLock = new Object();
    private volatile @Nullable IDocument document;
    private volatile @Nullable IGrammar grammar;
    private volatile @Nullable TMDocumentModel tmModel;

    private static String ensureGrammarScope(String type, @Nullable String candidate, @Nullable String baseScope) {
        String normalized;
        if (candidate != null && (normalized = TMPartitioner.normalizeVariantScope(candidate)) != null) {
            return normalized;
        }
        if ("tm4e:base".equals(type)) {
            String normalizedBase = TMPartitioner.normalizeVariantScope(baseScope);
            return normalizedBase != null ? normalizedBase : TEXT_UNKNOWN;
        }
        return TMPartitioner.scopeFromPartitionType(type);
    }

    private static @Nullable String normalizeBaseScope(@Nullable String scope) {
        if (scope == null) {
            return null;
        }
        if ((scope = TMScope.toUnqualified((String)scope)).startsWith("source.")) {
            int next = scope.indexOf(46, "source.".length());
            return next > 0 ? scope.substring(0, next) : scope;
        }
        if (scope.startsWith("text.")) {
            int next = scope.indexOf(46, "text.".length());
            return next > 0 ? scope.substring(0, next) : scope;
        }
        return scope;
    }

    private static @Nullable String normalizeVariantScope(@Nullable String scope) {
        if (scope == null) {
            return null;
        }
        return TMScope.toUnqualified((String)scope);
    }

    private static String scopeFromPartitionType(@Nullable String partitionType) {
        if (partitionType != null && partitionType.startsWith("tm4e:") && !"tm4e:base".equals(partitionType)) {
            return partitionType.substring("tm4e:".length());
        }
        return TEXT_UNKNOWN;
    }

    public static String scopeToPartitionType(String scope) {
        return "tm4e:" + TMPartitioner.normalizeBaseScope(scope);
    }

    private List<TMPartitionRegion> coalesce(List<TMPartitionRegion> segs) {
        if (segs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TMPartitionRegion> result = new ArrayList<TMPartitionRegion>(segs.size());
        TMPartitionRegion prev = segs.get(0);
        int i = 1;
        while (i < segs.size()) {
            TMPartitionRegion cur = segs.get(i);
            if (prev.getType().equals(cur.getType()) && prev.getOffset() + prev.getLength() == cur.getOffset()) {
                prev = new TMPartitionRegion(prev.getOffset(), prev.getLength() + cur.getLength(), prev.getType(), prev.getGrammarScope());
            } else {
                result.add(prev);
                prev = cur;
            }
            ++i;
        }
        result.add(prev);
        return result;
    }

    private static boolean spans(int start, int end) {
        return end > start;
    }

    private static void addSeg(List<TMPartitionRegion> out, int start, int end, String type, @Nullable String scope, @Nullable String baseScope) {
        if (TMPartitioner.spans(start, end)) {
            out.add(new TMPartitionRegion(start, end - start, type, TMPartitioner.ensureGrammarScope(type, scope, baseScope)));
        }
    }

    @Override
    public ITMPartitionRegion[] computePartitioning(int offset, int length) {
        this.ensureActivated();
        this.partitionsLock.readLock().lock();
        try {
            int listSize;
            IDocument doc = this.document;
            if (doc == null) {
                ITMPartitionRegion[] iTMPartitionRegionArray = new ITMPartitionRegion[]{new TMPartitionRegion(0, 0, this.basePartitionType, null)};
                return iTMPartitionRegionArray;
            }
            IGrammar grammar = this.grammar;
            if (length <= 0) {
                int start = Math.clamp((long)offset, 0, doc.getLength());
                ITMPartitionRegion[] iTMPartitionRegionArray = new ITMPartitionRegion[]{new TMPartitionRegion(start, 0, this.basePartitionType, grammar)};
                return iTMPartitionRegionArray;
            }
            int docLen = doc.getLength();
            int start = Math.clamp((long)offset, 0, docLen);
            int end = Math.clamp((long)(offset + length), start, docLen);
            if (this.partitions.isEmpty()) {
                ITMPartitionRegion[] iTMPartitionRegionArray = new ITMPartitionRegion[]{new TMPartitionRegion(start, Math.max(0, end - start), this.basePartitionType, grammar)};
                return iTMPartitionRegionArray;
            }
            ArrayList<TMPartitionRegion> list = new ArrayList<TMPartitionRegion>();
            int cursor = start;
            Map.Entry<Integer, TMPartitionRegion> floor = this.partitions.floorEntry(start);
            if (floor != null) {
                int to;
                TMPartitionRegion r = floor.getValue();
                int rStart = r.getOffset();
                int rEnd = rStart + r.getLength();
                if (rStart < start && rEnd > start && (to = Math.min(end, rEnd)) > cursor) {
                    list.add(new TMPartitionRegion(cursor, to - cursor, r));
                    cursor = to;
                }
            }
            for (Map.Entry e : this.partitions.subMap(start, true, Math.max(start, end - 1), true).entrySet()) {
                int gapEnd;
                if (cursor >= end) break;
                int rStart = (Integer)e.getKey();
                TMPartitionRegion r = (TMPartitionRegion)e.getValue();
                int rEnd = rStart + r.getLength();
                if (rStart > cursor && (gapEnd = Math.min(end, rStart)) > cursor) {
                    list.add(new TMPartitionRegion(cursor, gapEnd - cursor, this.basePartitionType, grammar));
                    cursor = gapEnd;
                }
                if (rEnd <= cursor) continue;
                int to = Math.min(end, rEnd);
                list.add(new TMPartitionRegion(cursor, to - cursor, r));
                cursor = to;
            }
            if (cursor < end) {
                list.add(new TMPartitionRegion(cursor, end - cursor, this.basePartitionType, grammar));
            }
            if ((listSize = list.size()) > 2) {
                ArrayList<TMPartitionRegion> adjusted = new ArrayList<TMPartitionRegion>(listSize);
                int i = 0;
                while (i < listSize) {
                    if (i > 0 && i < listSize - 1) {
                        TMPartitionRegion prev = (TMPartitionRegion)list.get(i - 1);
                        TMPartitionRegion cur = (TMPartitionRegion)list.get(i);
                        TMPartitionRegion next = (TMPartitionRegion)list.get(i + 1);
                        if (this.basePartitionType.equals(cur.getType()) && prev.getType().equals(next.getType()) && !prev.getType().equals(this.basePartitionType)) {
                            try {
                                String slice = doc.get(cur.getOffset(), cur.getLength());
                                if (slice.isBlank()) {
                                    if (!adjusted.isEmpty()) {
                                        adjusted.remove(adjusted.size() - 1);
                                    }
                                    int newOffset = prev.getOffset();
                                    int newLen = next.getOffset() + next.getLength() - newOffset;
                                    adjusted.add(new TMPartitionRegion(newOffset, newLen, prev.getType(), prev.getGrammarScope()));
                                    i += 2;
                                    continue;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                    adjusted.add((TMPartitionRegion)list.get(i));
                    ++i;
                }
                list.clear();
                list.addAll(adjusted);
            }
            if (list.isEmpty()) {
                ITMPartitionRegion[] iTMPartitionRegionArray = new ITMPartitionRegion[]{new TMPartitionRegion(start, Math.max(0, end - start), this.basePartitionType, grammar)};
                return iTMPartitionRegionArray;
            }
            ITMPartitionRegion[] iTMPartitionRegionArray = (ITMPartitionRegion[])list.toArray(ITMPartitionRegion[]::new);
            return iTMPartitionRegionArray;
        }
        finally {
            this.partitionsLock.readLock().unlock();
        }
    }

    public void connect(IDocument doc) {
        this.document = doc;
        this.activated = false;
        this.partitionsLock.writeLock().lock();
        try {
            this.partitions.clear();
            this.legalTypes.clear();
            this.legalTypes.add(this.basePartitionType);
        }
        finally {
            this.partitionsLock.writeLock().unlock();
        }
    }

    public void disconnect() {
        TMDocumentModel model = this.tmModel;
        if (model != null) {
            model.removeModelTokensChangedListener(this.modelListener);
        }
        this.tmModel = null;
        this.document = null;
        this.activated = false;
        this.grammar = null;
        this.partitionsLock.writeLock().lock();
        try {
            this.partitions.clear();
            this.legalTypes.clear();
            this.basePartitionType = "tm4e:base";
        }
        finally {
            this.partitionsLock.writeLock().unlock();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        if (!this.activated || this.document == null) {
            return false;
        }
        int changeStart = Math.max(0, event.getOffset());
        int replacedLen = Math.max(0, event.getLength());
        int addedLen = Math.max(0, event.getText().length());
        int oldEnd = changeStart + replacedLen;
        int newEnd = changeStart + addedLen;
        if (replacedLen == 0 && addedLen == 0) {
            return false;
        }
        return this.pruneAndFillBase(changeStart, oldEnd, newEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureActivated() {
        if (this.activated || this.document == null) {
            return;
        }
        Object object = this.activationLock;
        synchronized (object) {
            if (this.activated || this.document == null) {
                return;
            }
            this.initializeModelAndBase();
            this.rebuildAll();
            this.activated = true;
        }
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public @Nullable IGrammar getGrammar() {
        return this.grammar;
    }

    public String[] getLegalContentTypes() {
        this.ensureActivated();
        this.partitionsLock.readLock().lock();
        try {
            String[] stringArray = (String[])this.legalTypes.toArray(String[]::new);
            return stringArray;
        }
        finally {
            this.partitionsLock.readLock().unlock();
        }
    }

    @Override
    public ITMPartitionRegion getPartition(int offset) {
        this.ensureActivated();
        this.partitionsLock.readLock().lock();
        try {
            IDocument doc = this.document;
            if (doc == null) {
                TMPartitionRegion tMPartitionRegion = new TMPartitionRegion(0, 0, this.basePartitionType, this.grammar);
                return tMPartitionRegion;
            }
            int docLen = doc.getLength();
            if (docLen == 0) {
                TMPartitionRegion tMPartitionRegion = new TMPartitionRegion(0, 0, this.basePartitionType, this.grammar);
                return tMPartitionRegion;
            }
            if (this.partitions.isEmpty()) {
                TMPartitionRegion tMPartitionRegion = new TMPartitionRegion(0, docLen, this.basePartitionType, this.grammar);
                return tMPartitionRegion;
            }
            int clamped = Math.clamp((long)offset, 0, docLen - 1);
            Map.Entry<Integer, TMPartitionRegion> floor = this.partitions.floorEntry(clamped);
            if (floor != null) {
                TMPartitionRegion region = floor.getValue();
                int regionEnd = region.getOffset() + region.getLength();
                if (clamped >= region.getOffset() && clamped < regionEnd) {
                    TMPartitionRegion tMPartitionRegion = region;
                    return tMPartitionRegion;
                }
            }
            int baseStart = floor != null ? Math.max(0, floor.getValue().getOffset() + floor.getValue().getLength()) : 0;
            Map.Entry<Integer, TMPartitionRegion> next = this.partitions.ceilingEntry(clamped);
            int baseEnd = next != null ? next.getKey() : docLen;
            TMPartitionRegion tMPartitionRegion = new TMPartitionRegion(baseStart, Math.max(0, baseEnd - baseStart), this.basePartitionType, this.grammar);
            return tMPartitionRegion;
        }
        finally {
            this.partitionsLock.readLock().unlock();
        }
    }

    private void initializeModelAndBase() {
        TMDocumentModel model;
        IDocument doc = Objects.requireNonNull(this.document);
        this.tmModel = model = TMModelManager.INSTANCE.connect(doc);
        IGrammar modelGrammar = model.getGrammar();
        if (modelGrammar != null) {
            this.grammar = modelGrammar;
        } else if (this.grammar == null) {
            this.grammar = GrammarUtils.findGrammar(doc);
        }
        IGrammar grammar = this.grammar;
        if (grammar != null) {
            model.setGrammar(grammar);
            this.partitionsLock.writeLock().lock();
            try {
                this.basePartitionType = TMPartitioner.scopeToPartitionType(grammar.getScopeName());
                this.legalTypes.clear();
                this.legalTypes.add(this.basePartitionType);
            }
            finally {
                this.partitionsLock.writeLock().unlock();
            }
        }
        this.partitionsLock.writeLock().lock();
        try {
            this.basePartitionType = "tm4e:base";
            this.legalTypes.clear();
            this.legalTypes.add(this.basePartitionType);
        }
        finally {
            this.partitionsLock.writeLock().unlock();
        }
        model.addModelTokensChangedListener(this.modelListener);
    }

    private void integratePartitions(int startOffset, int endOffset, List<TMPartitionRegion> newSegs) {
        NavigableMap<Integer, TMPartitionRegion> bounded;
        TMPartitionRegion region;
        int regionEnd;
        Map.Entry<Integer, TMPartitionRegion> left;
        TMPartitionRegion rightCrossing = null;
        int rightCrossingEnd = -1;
        Map.Entry<Integer, TMPartitionRegion> rightCand = this.partitions.floorEntry(endOffset);
        if (rightCand != null) {
            TMPartitionRegion region2 = rightCand.getValue();
            int regionEnd2 = region2.getOffset() + region2.getLength();
            if (region2.getOffset() < endOffset && regionEnd2 > endOffset) {
                rightCrossing = region2;
                rightCrossingEnd = regionEnd2;
            }
        }
        if ((left = this.partitions.floorEntry(startOffset)) != null && (regionEnd = (region = left.getValue()).getOffset() + region.getLength()) > startOffset) {
            this.partitions.remove(left.getKey());
            if (region.getOffset() < startOffset) {
                this.partitions.put(region.getOffset(), new TMPartitionRegion(region.getOffset(), startOffset - region.getOffset(), region));
            }
        }
        if (!(bounded = this.partitions.subMap(startOffset, true, endOffset, false)).isEmpty()) {
            bounded.clear();
        }
        if (rightCrossing != null) {
            this.partitions.put(endOffset, new TMPartitionRegion(endOffset, rightCrossingEnd - endOffset, rightCrossing));
        }
        for (TMPartitionRegion seg : newSegs) {
            int expectedNextStart;
            TMPartitionRegion nr;
            TMPartitionRegion pr;
            int pEnd;
            int newStart = seg.getOffset();
            int newLen = seg.getLength();
            String type = seg.getType();
            String grammarScope = seg.getGrammarScope();
            Map.Entry<Integer, TMPartitionRegion> prev = this.partitions.floorEntry(newStart);
            if (prev != null && (pEnd = (pr = prev.getValue()).getOffset() + pr.getLength()) == newStart && pr.getType().equals(type)) {
                newStart = pr.getOffset();
                newLen += pr.getLength();
                this.partitions.remove(prev.getKey());
            }
            while ((nr = this.partitions.get(expectedNextStart = newStart + newLen)) != null && nr.getType().equals(type)) {
                newLen += nr.getLength();
                this.partitions.remove(expectedNextStart);
            }
            this.partitions.put(newStart, new TMPartitionRegion(newStart, newLen, type, grammarScope));
        }
    }

    private void onTokensChanged(ModelTokensChangedEvent event) {
        IDocument doc = this.document;
        if (doc == null) {
            return;
        }
        try {
            if (event.ranges.isEmpty()) {
                return;
            }
            ArrayList<int[]> ranges = new ArrayList<int[]>(event.ranges.size());
            for (Range r : event.ranges) {
                int s = Math.max(0, r.fromLineNumber - 1);
                int e = Math.max(s, r.toLineNumber - 1);
                ranges.add(new int[]{s, e});
            }
            ranges.sort((a, b) -> Integer.compare(a[0], b[0]));
            int curS = ((int[])ranges.get(0))[0];
            int curE = ((int[])ranges.get(0))[1];
            int i = 1;
            while (i < ranges.size()) {
                int s = ((int[])ranges.get(i))[0];
                int e = ((int[])ranges.get(i))[1];
                if (s <= curE + 1) {
                    if (e > curE) {
                        curE = e;
                    }
                } else {
                    int startOffset = doc.getLineOffset(curS);
                    int endOffset = doc.getLineOffset(curE) + doc.getLineLength(curE);
                    this.recomputeRange(startOffset, endOffset);
                    curS = s;
                    curE = e;
                }
                ++i;
            }
            int startOffset = doc.getLineOffset(curS);
            int endOffset = doc.getLineOffset(curE) + doc.getLineLength(curE);
            this.recomputeRange(startOffset, endOffset);
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
    }

    private boolean pruneAndFillBase(int startOffset, int oldEndOffset, int newEndOffset) {
        this.partitionsLock.writeLock().lock();
        try {
            NavigableMap<Integer, TMPartitionRegion> tailView;
            TMPartitionRegion region;
            int regionEnd;
            Map.Entry<Integer, TMPartitionRegion> left;
            NavigableMap<Integer, TMPartitionRegion> toDrop;
            IGrammar grammar = this.grammar;
            boolean changed = false;
            int boundedStart = Math.clamp((long)startOffset, 0, oldEndOffset);
            int boundedOldEnd = Math.max(boundedStart, oldEndOffset);
            int boundedNewEnd = Math.max(boundedStart, newEndOffset);
            int delta = boundedNewEnd - boundedOldEnd;
            if (this.partitions.isEmpty()) {
                if (boundedNewEnd > boundedStart) {
                    this.partitions.put(boundedStart, new TMPartitionRegion(boundedStart, boundedNewEnd - boundedStart, this.basePartitionType, grammar));
                    return true;
                }
                return false;
            }
            TMPartitionRegion rightCrossing = null;
            int rightCrossingEnd = -1;
            Map.Entry<Integer, TMPartitionRegion> rightCand = this.partitions.floorEntry(boundedOldEnd);
            if (rightCand != null) {
                TMPartitionRegion region2 = rightCand.getValue();
                int regionEnd2 = region2.getOffset() + region2.getLength();
                if (region2.getOffset() < boundedOldEnd && regionEnd2 > boundedOldEnd) {
                    rightCrossing = region2;
                    rightCrossingEnd = regionEnd2;
                }
            }
            if (!(toDrop = this.partitions.subMap(boundedStart, true, boundedOldEnd, false)).isEmpty()) {
                toDrop.clear();
                changed = true;
            }
            if ((left = this.partitions.floorEntry(boundedStart)) != null && (regionEnd = (region = left.getValue()).getOffset() + region.getLength()) > boundedStart) {
                this.partitions.put(region.getOffset(), new TMPartitionRegion(region.getOffset(), boundedStart - region.getOffset(), region));
                changed = true;
            }
            if (delta != 0 && !(tailView = this.partitions.tailMap(boundedOldEnd, true)).isEmpty()) {
                TreeMap<Integer, TMPartitionRegion> shifted = new TreeMap<Integer, TMPartitionRegion>();
                for (Map.Entry e : tailView.entrySet()) {
                    int oldKey = (Integer)e.getKey();
                    TMPartitionRegion region3 = (TMPartitionRegion)e.getValue();
                    int newStart = oldKey + delta;
                    shifted.put(newStart, new TMPartitionRegion(newStart, region3.getLength(), region3));
                }
                tailView.clear();
                this.partitions.putAll(shifted);
                changed = true;
            }
            if (rightCrossing != null) {
                this.partitions.put(boundedNewEnd, new TMPartitionRegion(boundedNewEnd, rightCrossingEnd - boundedOldEnd, rightCrossing));
                changed = true;
            }
            if (boundedNewEnd > boundedStart) {
                this.partitions.put(boundedStart, new TMPartitionRegion(boundedStart, boundedNewEnd - boundedStart, this.basePartitionType, grammar));
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.partitionsLock.writeLock().unlock();
        }
    }

    private void rebuildAll() {
        TMDocumentModel model = this.tmModel;
        IDocument doc = this.document;
        if (model == null || doc == null || model.getBackgroundTokenizationState() != ITMModel.BackgroundTokenizationState.COMPLETED) {
            return;
        }
        try {
            this.recomputeRange(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logTrace((Exception)((Object)ex));
        }
    }

    private void recomputeRange(int startOffset, int endOffset) throws BadLocationException {
        TMDocumentModel model = this.tmModel;
        IDocument doc = this.document;
        if (model == null || doc == null || endOffset <= startOffset) {
            return;
        }
        IGrammar grammar = this.grammar;
        String baseScope = grammar != null ? TMPartitioner.normalizeVariantScope(grammar.getScopeName()) : null;
        String baseRoot = TMPartitioner.normalizeBaseScope(baseScope);
        String baseRootNN = baseRoot != null ? baseRoot : TEXT_UNKNOWN;
        ArrayList<TMPartitionRegion> newSegs = new ArrayList<TMPartitionRegion>();
        int startLine = doc.getLineOfOffset(startOffset);
        int endLine = doc.getLineOfOffset(endOffset - 1);
        String currentType = null;
        String currentGrammarScopeStr = null;
        int currentStart = startOffset;
        int line = startLine;
        while (line <= endLine) {
            int lineOffset = doc.getLineOffset(line);
            int lineEnd = lineOffset + doc.getLineLength(line);
            List tokens = model.getLineTokens(line);
            if (tokens == null || tokens.isEmpty()) {
                if (currentType == null) {
                    currentType = this.basePartitionType;
                    currentGrammarScopeStr = baseRootNN;
                }
            } else {
                int firstEmbeddedStart = -1;
                int lastEmbeddedStart = -1;
                for (TMToken t : tokens) {
                    String prefNorm;
                    String string = prefNorm = t.grammarScope == null ? null : TMPartitioner.normalizeVariantScope(t.grammarScope);
                    if (prefNorm == null || Objects.equals(TMPartitioner.normalizeBaseScope(prefNorm), baseRootNN)) continue;
                    if (firstEmbeddedStart < 0) {
                        firstEmbeddedStart = t.startIndex;
                    }
                    lastEmbeddedStart = t.startIndex;
                }
                boolean lineHasEmbedded = firstEmbeddedStart >= 0;
                boolean skipWhitespaceBaseLineInEmbeddedRun = false;
                if (!lineHasEmbedded && currentType != null && !currentType.equals(this.basePartitionType)) {
                    String slice;
                    int spanStart = Math.max(lineOffset, startOffset);
                    int spanEnd = Math.min(lineEnd, endOffset);
                    if (spanEnd > spanStart && (slice = doc.get(spanStart, spanEnd - spanStart)).isBlank()) {
                        skipWhitespaceBaseLineInEmbeddedRun = true;
                    }
                }
                if (!skipWhitespaceBaseLineInEmbeddedRun) {
                    for (TMToken tok : tokens) {
                        String root;
                        boolean isBase;
                        String prefNorm = tok.grammarScope == null ? null : TMPartitioner.normalizeVariantScope(tok.grammarScope);
                        boolean bl = isBase = prefNorm == null || Objects.equals(TMPartitioner.normalizeBaseScope(prefNorm), baseRootNN);
                        String string = isBase ? this.basePartitionType : (root = TMPartitioner.scopeToPartitionType(prefNorm != null ? prefNorm : baseRootNN));
                        if (currentType == null) {
                            currentType = root;
                            boolean isEmbedded = !isBase;
                            int firstTokenStart = lineOffset + tok.startIndex;
                            currentStart = Math.max(currentStart, isEmbedded ? lineOffset : firstTokenStart);
                            currentGrammarScopeStr = isBase ? baseRootNN : prefNorm;
                            continue;
                        }
                        if (currentType.equals(root)) continue;
                        if (!currentType.equals(this.basePartitionType) && this.basePartitionType.equals(root)) {
                            boolean baseBeforeLastEmbedded;
                            boolean baseAtLineStartWithEmbedLater = tok.startIndex == 0 && firstEmbeddedStart > 0;
                            boolean bl2 = baseBeforeLastEmbedded = lastEmbeddedStart > 0 && tok.startIndex <= lastEmbeddedStart;
                            if (baseAtLineStartWithEmbedLater || baseBeforeLastEmbedded) continue;
                        }
                        int segEnd = lineOffset + tok.startIndex;
                        TMPartitioner.addSeg(newSegs, currentStart, segEnd, currentType, currentGrammarScopeStr, baseScope);
                        currentType = root;
                        currentStart = segEnd;
                        String string2 = currentGrammarScopeStr = isBase ? baseRootNN : prefNorm;
                    }
                }
            }
            if (currentType == null) {
                currentType = this.basePartitionType;
                currentGrammarScopeStr = baseRootNN;
            }
            if (line == endLine) {
                int finalEnd = Math.min(lineEnd, endOffset);
                TMPartitioner.addSeg(newSegs, currentStart, finalEnd, currentType, currentGrammarScopeStr, baseScope);
            }
            ++line;
        }
        if (newSegs.isEmpty() && endOffset > startOffset) {
            TMPartitioner.addSeg(newSegs, startOffset, endOffset, this.basePartitionType, baseScope, baseScope);
        }
        List<TMPartitionRegion> merged = this.coalesce(newSegs);
        HashSet<String> newTypes = new HashSet<String>();
        for (TMPartitionRegion r : merged) {
            newTypes.add(r.getType());
        }
        this.partitionsLock.writeLock().lock();
        try {
            this.legalTypes.addAll(newTypes);
            this.integratePartitions(startOffset, endOffset, merged);
        }
        finally {
            this.partitionsLock.writeLock().unlock();
        }
    }

    public void setGrammar(@Nullable IGrammar newGrammar) {
        this.grammar = newGrammar;
        if (this.document != null) {
            this.initializeModelAndBase();
            this.rebuildAll();
        }
    }

    record TMPartitionRegion(int offset, int length, String type, String grammarScope) implements ITMPartitionRegion
    {
        private static String getGrammarScope(String type, @Nullable IGrammar grammar) {
            String grammarScope;
            if (grammar != null && (grammarScope = TMPartitioner.normalizeBaseScope(grammar.getScopeName())) != null) {
                return grammarScope;
            }
            return TMPartitioner.scopeFromPartitionType(type);
        }

        public TMPartitionRegion(int offset, int length, TMPartitionRegion region) {
            this(offset, length, region.type, region.grammarScope);
        }

        public TMPartitionRegion(int offset, int length, String type, @Nullable IGrammar grammar) {
            this(offset, length, type, TMPartitionRegion.getGrammarScope(type, grammar));
        }

        public String getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        public String getGrammarScope() {
            return this.grammarScope;
        }
    }
}

