/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.request;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.tests.stubs.request.TmfEventRequestStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TmfEventRequestTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private static TmfTimeRange range1 = TmfTimeRange.ETERNITY;
    private static TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.fromSeconds((long)0L), TmfTimestamp.BIG_CRUNCH);
    private static TmfEventRequest fRequest1;
    private static TmfEventRequest fRequest2;
    private static TmfEventRequest fRequest3;
    private static TmfEventRequest fRequest4;
    private static TmfEventRequest fRequest5;

    @Before
    public void setUp() {
        fRequest1 = new TmfEventRequestStub(ITmfEvent.class, range1, 100, 200);
        fRequest2 = new TmfEventRequestStub(ITmfEvent.class, range2, 100, 200);
        fRequest3 = new TmfEventRequestStub(ITmfEvent.class, range2, 200, 200);
        fRequest4 = new TmfEventRequestStub(ITmfEvent.class, range2, 200, 300);
        fRequest5 = new TmfEventRequestStub(ITmfEvent.class, range2, 200, 300, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
    }

    private static TmfEventRequest setupTestRequest(final boolean[] flags) {
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class, TmfTimeRange.ETERNITY, 100, 200){

            public void handleCompleted() {
                super.handleCompleted();
                flags[0] = true;
            }

            public void handleSuccess() {
                super.handleSuccess();
                flags[1] = true;
            }

            public void handleFailure() {
                super.handleFailure();
                flags[2] = true;
            }

            public void handleCancel() {
                super.handleCancel();
                flags[3] = true;
            }
        };
        return request;
    }

    @Test
    public void testTmfEventRequest() {
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class);
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"StartTime", (Object)TmfTimestamp.BIG_BANG, (Object)request.getRange().getStartTime());
        Assert.assertEquals((String)"EndTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)request.getRange().getEndTime());
        Assert.assertEquals((String)"getRange", (Object)TmfTimeRange.ETERNITY, (Object)request.getRange());
        Assert.assertSame((String)"getRange", (Object)TmfTimeRange.ETERNITY, (Object)request.getRange());
        Assert.assertEquals((String)"getIndex", (long)0L, (long)request.getIndex());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)Integer.MAX_VALUE, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
        Assert.assertEquals((String)"getDependencyLevel", (long)0L, (long)request.getDependencyLevel());
    }

    @Test
    public void testTmfEventRequestTimeRange() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromSeconds((long)0L), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class, range);
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"StartTime", (Object)TmfTimestamp.fromSeconds((long)0L), (Object)request.getRange().getStartTime());
        Assert.assertEquals((String)"EndTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)request.getRange().getEndTime());
        Assert.assertEquals((String)"getIndex", (long)0L, (long)request.getIndex());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)Integer.MAX_VALUE, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
        Assert.assertEquals((String)"getDependencyLevel", (long)0L, (long)request.getDependencyLevel());
    }

    @Test
    public void testTmfEventRequestTimeRangeNbRequested() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromSeconds((long)0L), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class, range, 100);
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"StartTime", (Object)TmfTimestamp.fromSeconds((long)0L), (Object)request.getRange().getStartTime());
        Assert.assertEquals((String)"EndTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)request.getRange().getEndTime());
        Assert.assertEquals((String)"getIndex", (long)0L, (long)request.getIndex());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)100L, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
        Assert.assertEquals((String)"getDependencyLevel", (long)0L, (long)request.getDependencyLevel());
    }

    @Test
    public void testTmfEventRequestTimeRangeNbRequestedBlocksize() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromSeconds((long)0L), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class, range, 100, 200);
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"StartTime", (Object)TmfTimestamp.fromSeconds((long)0L), (Object)request.getRange().getStartTime());
        Assert.assertEquals((String)"EndTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)request.getRange().getEndTime());
        Assert.assertEquals((String)"getIndex", (long)0L, (long)request.getIndex());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)100L, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
        Assert.assertEquals((String)"getDependencyLevel", (long)0L, (long)request.getDependencyLevel());
    }

    @Test
    public void testTmfEventRequestWithDependencyLevel() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromSeconds((long)0L), TmfTimestamp.BIG_CRUNCH);
        TmfEventRequestStub request = new TmfEventRequestStub(ITmfEvent.class, range, 100, 200, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"StartTime", (Object)TmfTimestamp.fromSeconds((long)0L), (Object)request.getRange().getStartTime());
        Assert.assertEquals((String)"EndTime", (Object)TmfTimestamp.BIG_CRUNCH, (Object)request.getRange().getEndTime());
        Assert.assertEquals((String)"getIndex", (long)0L, (long)request.getIndex());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)100L, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
        Assert.assertEquals((String)"getDependencyLevel", (long)1L, (long)request.getDependencyLevel());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)fRequest1.equals(fRequest1));
        Assert.assertFalse((boolean)fRequest1.equals(fRequest2));
        Assert.assertFalse((boolean)fRequest1.equals(fRequest3));
        Assert.assertFalse((boolean)fRequest1.equals(fRequest4));
        Assert.assertFalse((boolean)fRequest4.equals(fRequest5));
    }

    @Test
    public void testToString() {
        String expected1 = "[TmfEventRequestStub(" + fRequest1.getRequestId() + ",ITmfEvent,FOREGROUND," + range1 + ",0,100,0)]";
        String expected2 = "[TmfEventRequestStub(" + fRequest2.getRequestId() + ",ITmfEvent,FOREGROUND," + range2 + ",0,100,0)]";
        String expected3 = "[TmfEventRequestStub(" + fRequest3.getRequestId() + ",ITmfEvent,FOREGROUND," + range2 + ",0,200,0)]";
        String expected4 = "[TmfEventRequestStub(" + fRequest4.getRequestId() + ",ITmfEvent,FOREGROUND," + range2 + ",0,200,0)]";
        String expected5 = "[TmfEventRequestStub(" + fRequest5.getRequestId() + ",ITmfEvent,FOREGROUND," + range2 + ",0,200,1)]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)fRequest1.toString());
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)fRequest2.toString());
        Assert.assertEquals((String)"toString", (Object)expected3, (Object)fRequest3.toString());
        Assert.assertEquals((String)"toString", (Object)expected4, (Object)fRequest4.toString());
        Assert.assertEquals((String)"toString", (Object)expected5, (Object)fRequest5.toString());
    }

    @Test
    public void testDone() {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.done();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertTrue((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testFail() {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.fail((Exception)new IllegalArgumentException("Bad argument"));
        Throwable failCause = request.getFailureCause();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertTrue((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertNotNull((String)"Cause of failure", (Object)failCause);
        Assert.assertEquals((String)"Cause of failure message", (Object)"Bad argument", (Object)failCause.getMessage());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertFalse((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertTrue((String)"handleFailure", (boolean)flags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testCancel() {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.cancel();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertFalse((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertTrue((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testWaitForStartAfterStart() throws InterruptedException {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.start();
        request.waitForStart();
        request.done();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertTrue((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testWaitForStartAfterDone() throws InterruptedException {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.start();
        request.done();
        request.waitForStart();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertTrue((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testWaitForStartAfterCancel() throws InterruptedException {
        boolean[] flags = new boolean[4];
        TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        request.start();
        request.cancel();
        request.waitForStart();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertFalse((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertTrue((String)"handleCancel", (boolean)flags[3]);
    }

    @Test
    public void testWaitForStartBeforeStart() throws InterruptedException {
        boolean[] flags = new boolean[4];
        final TmfEventRequest request = TmfEventRequestTest.setupTestRequest(flags);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    request.waitForStart();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setPriority(10);
        t.start();
        request.start();
        t.join();
        request.done();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)flags[0]);
        Assert.assertTrue((String)"handleSuccess", (boolean)flags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)flags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)flags[3]);
    }
}

