/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TreePatternFilter;

public class MultiTreePatternFilter
extends TreePatternFilter {
    private final List<Predicate<String>> fPredicates = new ArrayList<Predicate<String>>();

    public void setPattern(String patternString) {
        this.fPredicates.clear();
        super.setPattern(patternString);
        if (patternString == null || patternString.isEmpty()) {
            return;
        }
        String[] split = patternString.replace('*', '.').split("/");
        int i = split.length - 1;
        while (i >= 0) {
            Predicate<String> predicate;
            String filter = split[i];
            try {
                Pattern pattern = Pattern.compile(filter, 2);
                predicate = s -> pattern.matcher((CharSequence)s).find();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                predicate = s -> s.contains(filter);
            }
            this.fPredicates.add(predicate);
            --i;
        }
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        Object node = element;
        StructuredViewer structuredViewer = (StructuredViewer)viewer;
        ITableLabelProvider labelProvider = (ITableLabelProvider)structuredViewer.getLabelProvider();
        ITreeContentProvider treeContentProvider = (ITreeContentProvider)structuredViewer.getContentProvider();
        for (Predicate<String> p : this.fPredicates) {
            String labelText = labelProvider.getColumnText(node, 0);
            if (labelText == null || !p.test(labelText)) {
                return false;
            }
            node = treeContentProvider.getParent(node);
        }
        return true;
    }
}

