/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections;

import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.ConnectionEndpoint;

public class RosConnectionEndpoint {
    private final String fTopicName;
    private final String fNodeName;
    private final ConnectionEndpoint fEndpoint;
    private final long fStartTime;

    public RosConnectionEndpoint(String topic, String node, ConnectionEndpoint endpoint, long time) {
        this.fTopicName = topic;
        this.fNodeName = node;
        this.fEndpoint = endpoint;
        this.fStartTime = time;
    }

    public String getTopicName() {
        return this.fTopicName;
    }

    public String getNodeName() {
        return this.fNodeName;
    }

    public ConnectionEndpoint getEndpoint() {
        return this.fEndpoint;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public int hashCode() {
        return Objects.hash(this.fTopicName, this.fNodeName, this.fEndpoint, this.fStartTime);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("\tRosConnectionEndpoint");
        b.append("\n");
        b.append("\t\ttopic     =" + this.fTopicName);
        b.append("\n");
        b.append("\t\thost:port =" + this.fEndpoint.toString());
        b.append("\n");
        b.append("\t\tnode      =" + this.fNodeName);
        b.append("\n");
        b.append("\t\ttime      =" + this.fStartTime);
        b.append("\n");
        return b.toString();
    }
}

