/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.TargetMessageInfo;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.IRosModelProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.RosModelUtils;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.IRosMessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.RosMessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.IRosMessagesTransportModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportModelAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.queues.RosQueuesAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class RosMessageFlowAnalysis
extends TmfAbstractAnalysisModule
implements IRosModelProvider<IRosMessageFlowModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.ros.core.analysis.messageflow";
    public static final @NonNull String TARGET_MESSAGE_INFO_KEY = "target.message.info";
    private @Nullable IProgressMonitor fMonitor;
    private @Nullable RosMessageFlowModel fModel = null;

    public RosMessageFlowAnalysis() {
        this.setId(ID);
        this.addParameter(TARGET_MESSAGE_INFO_KEY);
    }

    @Override
    public @Nullable IRosMessageFlowModel getModel() {
        return this.fModel;
    }

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) {
        Object info = this.getParameter(TARGET_MESSAGE_INFO_KEY);
        if (info == null || !(info instanceof TargetMessageInfo)) {
            Activator.getInstance().logError("No target message set; not executing!");
            return false;
        }
        TargetMessageInfo targetMessageInfo = (TargetMessageInfo)info;
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        @Nullable ITmfStateSystem queuesStateSystem = RosModelUtils.getStateSystemFromAnalysis(trace, RosQueuesAnalysis.class, RosQueuesAnalysis.getFullAnalysisId());
        if (queuesStateSystem == null) {
            return false;
        }
        @Nullable IRosMessagesTransportModel messagesTransportModel = (IRosMessagesTransportModel)RosModelUtils.getModelFromAnalysis(trace, RosMessagesTransportModelAnalysis.class, "org.eclipse.tracecompass.incubator.ros.core.analysis.model.messagestransport");
        if (messagesTransportModel == null) {
            return false;
        }
        RosMessageFlowModel model = new RosMessageFlowModel(targetMessageInfo, queuesStateSystem, messagesTransportModel);
        model.generateModel();
        this.fModel = model;
        return this.fModel.isModelDone() && !monitor.isCanceled();
    }

    protected void parameterChanged(@NonNull String name) {
        if (name.equals(TARGET_MESSAGE_INFO_KEY)) {
            this.cancel();
            this.resetAnalysis();
            this.schedule();
        }
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        RosQueuesAnalysis queues = (RosQueuesAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, RosQueuesAnalysis.class, (String)RosQueuesAnalysis.getFullAnalysisId());
        RosMessagesTransportModelAnalysis messagesTransportModelAnalysis = (RosMessagesTransportModelAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, RosMessagesTransportModelAnalysis.class, (String)"org.eclipse.tracecompass.incubator.ros.core.analysis.model.messagestransport");
        if (queues == null || messagesTransportModelAnalysis == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.of((Object)queues, (Object)messagesTransportModelAnalysis);
    }

    protected void canceling() {
        IProgressMonitor mon = this.fMonitor;
        if (mon != null && !mon.isCanceled()) {
            mon.setCanceled(true);
        }
    }
}

