/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis;

import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.analysis.IDpdkEventHandler;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.analysis.DpdkEthdevEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DpdkEthdevSpinEventHandler
implements IDpdkEventHandler {
    private final DpdkEthdevEventLayout fLayout;

    DpdkEthdevSpinEventHandler(DpdkEthdevEventLayout layout) {
        this.fLayout = layout;
    }

    public void updateCounts(ITmfStateSystemBuilder ssb, int queueQuark, Integer nbPkts, long ts) {
        if (nbPkts <= 0) {
            return;
        }
        try {
            StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)ts, (int)queueQuark, (long)nbPkts.intValue());
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logWarning("Problem accessing the state of a NIC queue (Quark = " + queueQuark + ")", (Throwable)e);
        }
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        long ts = event.getTimestamp().getValue();
        String eventName = event.getName();
        Integer portId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldPortId()});
        Integer queueId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldQueueId()});
        String threadName = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldThreadName()});
        Integer cpuId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldCpuId()});
        int threadQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads", threadName + "/" + String.valueOf(cpuId)});
        int queueQark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{"P" + Objects.requireNonNull(portId).toString() + "/Q" + Objects.requireNonNull(queueId).toString()});
        if (eventName.equals(this.fLayout.eventEthdevRxBurstEmpty())) {
            ssb.modifyAttribute(ts, (Object)"Spin", queueQark);
        } else if (eventName.equals(this.fLayout.eventEthdevRxBurstNonEmpty())) {
            ssb.modifyAttribute(ts, (Object)"Active", queueQark);
        }
    }
}

