/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class UnaryIntegerParser
implements ICommonTreeParser {
    public static final UnaryIntegerParser INSTANCE = new UnaryIntegerParser();

    private UnaryIntegerParser() {
    }

    @Override
    public Long parse(ICTFMetadataNode unaryInteger, ICommonTreeParser.ICommonTreeParserParameter notUsed) throws ParseException {
        long intval;
        List<ICTFMetadataNode> children = unaryInteger.getChildren();
        ICTFMetadataNode value = children.get(0);
        String strval = value.getText();
        try {
            intval = Long.decode(strval);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid integer format: " + strval, e);
        }
        if (children.size() % 2 == 0) {
            return -intval;
        }
        return intval;
    }
}

