/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.dynamicstring;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.DynamicLengthStringDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.utils.JsonMetadataStrings;

public final class DynamicLengthStringParser
extends AbstractScopedCommonTreeParser {
    public static final DynamicLengthStringParser INSTANCE = new DynamicLengthStringParser();

    private DynamicLengthStringParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode node, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        Charset encoding;
        if (!(node instanceof JsonStructureFieldMemberMetadataNode)) {
            throw new ParseException("Dynamic-length string only supported in JSON metadata");
        }
        JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)node;
        JsonElement fieldClassElement = member.getFieldClass();
        if (fieldClassElement == null || !fieldClassElement.isJsonObject()) {
            throw new ParseException(this.getClass().getName() + " fieldclass must be a json object.");
        }
        JsonObject fieldClass = member.getFieldClass().getAsJsonObject();
        JsonElement lengthFieldLocation = fieldClass.get("length-field-location");
        if (lengthFieldLocation == null) {
            throw new ParseException("Dynamic-length string requires length-field-location property");
        }
        JsonElement encodingField = fieldClass.get("encoding");
        String lengthName = lengthFieldLocation.getAsJsonObject().get("path").getAsString();
        Charset charset = encoding = encodingField != null ? JsonMetadataStrings.ENCODINGS.getOrDefault(encodingField.getAsString(), StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
        if (lengthName == null) {
            throw new ParseException("Length field name is null");
        }
        return new DynamicLengthStringDeclaration(lengthName, encoding);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }

        public CTFTrace getTrace() {
            return this.fTrace;
        }
    }
}

