/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.Range;

public enum RangeAlign {
    LOWER{

        @Override
        public Range align(Range range, double length) {
            return new Range(range.getLowerBound(), range.getLowerBound() + length);
        }
    }
    ,
    CENTER{

        @Override
        public Range align(Range range, double length) {
            double offset = (range.getLength() - length) / 2.0;
            return new Range(range.getLowerBound() + offset, range.getUpperBound() - offset);
        }
    }
    ,
    UPPER{

        @Override
        public Range align(Range range, double length) {
            return new Range(range.getUpperBound() - length, range.getUpperBound());
        }
    };


    public abstract Range align(Range var1, double var2);
}

