/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;

public class BaseExponentTickUnitSource
implements TickUnitSource,
Serializable {
    private static final long serialVersionUID = -1558705155970046957L;
    private final double base;
    private final int minExponent;
    private final int maxExponent;

    public BaseExponentTickUnitSource(double base) {
        this(base, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public BaseExponentTickUnitSource(double base, int minExponent) {
        this(base, minExponent, Integer.MAX_VALUE);
    }

    public BaseExponentTickUnitSource(double base, int minExponent, int maxExponent) {
        this.base = base;
        this.minExponent = minExponent;
        this.maxExponent = maxExponent;
    }

    public TickUnit getLargerTickUnit(TickUnit unit) {
        double size = unit.getSize();
        double exp = Math.floor(Math.log(size) / Math.log(this.base));
        double fac = size / Math.pow(this.base, exp);
        if (exp < (double)this.minExponent) {
            exp = this.minExponent;
            fac = 1.0;
        } else if (exp > (double)this.maxExponent) {
            exp = this.maxExponent;
            fac = 5.0;
        } else if (fac < 1.0) {
            fac = 1.0;
        } else if (fac < 2.0) {
            fac = 2.0;
        } else if (fac < 3.0) {
            fac = 3.0;
        } else if (fac < 5.0 || exp == (double)this.maxExponent) {
            fac = 5.0;
        } else {
            exp += 1.0;
            fac = 1.0;
        }
        return new NumberTickUnit(fac * Math.pow(this.base, exp));
    }

    public TickUnit getCeilingTickUnit(TickUnit unit) {
        return this.getCeilingTickUnit(unit.getSize());
    }

    public TickUnit getCeilingTickUnit(double size) {
        double exp = Math.floor(Math.log(size) / Math.log(this.base));
        double fac = size / Math.pow(this.base, exp);
        if (exp < (double)this.minExponent) {
            exp = this.minExponent;
            fac = 1.0;
        } else if (exp > (double)this.maxExponent) {
            exp = this.maxExponent;
            fac = 5.0;
        } else if (fac <= 1.0) {
            fac = 1.0;
        } else if (fac <= 2.0) {
            fac = 2.0;
        } else if (fac <= 3.0) {
            fac = 3.0;
        } else if (fac <= 5.0 || exp == (double)this.maxExponent) {
            fac = 5.0;
        } else {
            exp += 1.0;
            fac = 1.0;
        }
        return new NumberTickUnit(fac * Math.pow(this.base, exp));
    }
}

