/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.AnalysisException;
import org.eclipse.trace4cps.analysis.behavior.BehavioralAnalysis;
import org.eclipse.trace4cps.analysis.behavior.BehavioralPartition;
import org.eclipse.trace4cps.analysis.behavior.HistogramEntry;
import org.eclipse.trace4cps.analysis.cpa.CpaResult;
import org.eclipse.trace4cps.analysis.cpa.DependencyProvider;
import org.eclipse.trace4cps.analysis.dist.DefaultRepresentation;
import org.eclipse.trace4cps.analysis.dist.DistanceAnalysis;
import org.eclipse.trace4cps.analysis.dist.DistanceResult;
import org.eclipse.trace4cps.analysis.dist.Representation;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlChecker;
import org.eclipse.trace4cps.analysis.mtl.MtlException;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlFuture;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.analysis.mtl.MtlUtil;
import org.eclipse.trace4cps.analysis.resource.ResourceAnalysis;
import org.eclipse.trace4cps.analysis.signal.SignalModifier;
import org.eclipse.trace4cps.analysis.signal.SignalUtil;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.ClaimEvent;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.vis.jfree.ColorManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AnalysisUtil {
    private AnalysisUtil() {
    }

    public static Map<IAttributeAware, Paint> createAPhighlight(List<IEvent> states, List<MtlResult> results) {
        HashMap<IAttributeAware, Paint> highlightMap = new HashMap<IAttributeAware, Paint>();
        for (MtlResult r : results) {
            if (InformativePrefix.BAD != r.informative()) continue;
            Set aps = MtlUtil.getAtomicPropositions((MtlFormula)r.getPhi());
            for (IEvent e : states) {
                for (AtomicProposition ap : aps) {
                    if (!e.satisfies(ap) || !(e instanceof IClaimEvent)) continue;
                    highlightMap.put((IAttributeAware)((IClaimEvent)e).getClaim(), ColorManager.RED_PURE.getColor());
                }
            }
        }
        return highlightMap;
    }

    public static Map<IClaim, Paint> createAPhighlight2(List<IEvent> states, List<MtlResult> results) {
        HashMap<IClaim, Paint> highlightMap = new HashMap<IClaim, Paint>();
        for (MtlResult r : results) {
            if (InformativePrefix.BAD != r.informative()) continue;
            Iterator iterator = MtlUtil.getAtomicPropIndices((MtlResult)r).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                IEvent e = states.get(i);
                if (!(e instanceof IClaimEvent)) continue;
                highlightMap.put(((IClaimEvent)e).getClaim(), ColorManager.RED_PURE.getColor());
            }
        }
        return highlightMap;
    }

    public static Map<IAttributeAware, Paint> mtlCheck(ITrace trace, List<MtlFormula> phis, boolean interpretAsPrefix) throws MtlException, InterruptedException, ExecutionException {
        List states = trace.getEvents();
        MtlFuture f = new MtlChecker().checkAll(states, phis, Collections.emptySet(), interpretAsPrefix);
        List results = f.get();
        return AnalysisUtil.createAPhighlight(states, results);
    }

    public static Map<IAttributeAware, Paint> createHighlight(CpaResult r, DependencyProvider p) {
        HashMap<IAttributeAware, Paint> m = new HashMap<IAttributeAware, Paint>();
        for (IDependency dep : r.getCriticalDeps()) {
            IClaim src;
            if (dep.getSrc() instanceof IClaimEvent && m.get(src = ((IClaimEvent)dep.getSrc()).getClaim()) == null) {
                m.put((IAttributeAware)src, ColorManager.DARK_RED.getColor());
            }
            if (!(dep.getDst() instanceof IClaimEvent)) continue;
            IClaim dst = ((IClaimEvent)dep.getDst()).getClaim();
            if (m.get(dst) == null) {
                m.put((IAttributeAware)dst, ColorManager.DARK_RED.getColor());
            }
            if (!CpaResult.isNonAppDependency((IDependency)dep, (DependencyProvider)p)) continue;
            m.put((IAttributeAware)dst, ColorManager.RED_PURE.getColor());
        }
        return m;
    }

    public static Map<IAttributeAware, Paint> computeDiffHighlights(ITrace referenceTrace, ITrace modelTrace) {
        HashMap<IAttributeAware, Paint> highlight = new HashMap<IAttributeAware, Paint>();
        AnalysisUtil.computeDiffHighlights(referenceTrace, modelTrace, true, highlight);
        return highlight;
    }

    public static Map<IAttributeAware, Paint> computeDiffHighlights(ITrace referenceTrace, ITrace ... modelTraces) {
        HashMap<IAttributeAware, Paint> highlight = new HashMap<IAttributeAware, Paint>();
        ITrace[] iTraceArray = modelTraces;
        int n = modelTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITrace modelTrace = iTraceArray[n2];
            AnalysisUtil.computeDiffHighlights(referenceTrace, modelTrace, false, highlight);
            ++n2;
        }
        return highlight;
    }

    public static long computeDiffHighlights(ITrace referenceTrace, ITrace modelTrace, boolean annotateReference, Map<IAttributeAware, Paint> highlight) {
        DistanceResult val = DistanceAnalysis.distance((ITrace)referenceTrace, (ITrace)modelTrace, (Representation)new DefaultRepresentation(), (boolean)annotateReference);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Integer v : val.getInterestCount().keySet()) {
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        int range = max - min;
        for (Map.Entry e : val.getInterestCount().entrySet()) {
            Integer level = (Integer)e.getKey();
            float weight = (float)(level - min) / (float)range;
            ColorManager color = ColorManager.getShadeOfRed((float)weight);
            if (color == ColorManager.NON_HIGHLIGHT) continue;
            for (IEvent event : (List)e.getValue()) {
                if (!(event instanceof ClaimEvent)) continue;
                highlight.put((IAttributeAware)((ClaimEvent)event).getClaim(), color.getColor());
            }
        }
        return val.getDistance();
    }

    public static IAttributeFilter computeBehavioralRepresentativeFilter(ITrace trace, String idAtt, Set<String> uniquenessAtts) {
        List events = trace.getEvents();
        BehavioralPartition part = BehavioralAnalysis.partition((Iterable)events, (String)idAtt, uniquenessAtts);
        return BehavioralAnalysis.computeBehavioralRepresentativeFilter((BehavioralPartition)part);
    }

    public static Map<IAttributeAware, Paint> computeAnomalyHistogramHighlight(ITrace trace, String idAtt, Set<String> uniquenessAtts) {
        HashMap<IAttributeAware, Paint> h = new HashMap<IAttributeAware, Paint>();
        List events = trace.getEvents();
        BehavioralPartition part = BehavioralAnalysis.partition((Iterable)events, (String)idAtt, uniquenessAtts);
        List hist = BehavioralAnalysis.createBehavioralHistogram((BehavioralPartition)part);
        HashMap<Integer, Color> objectIds2Paint = new HashMap<Integer, Color>();
        int i = 2;
        for (HistogramEntry he : hist) {
            for (Integer id : he.getCentralObjectIds()) {
                objectIds2Paint.put(id, ColorManager.getAutomaticColor((int)i).getColor());
            }
            ++i;
        }
        for (IEvent event : events) {
            if (!(event instanceof IClaimEvent)) continue;
            IClaim claim = ((IClaimEvent)event).getClaim();
            String idAttValue = claim.getAttributeValue(idAtt);
            Integer objectId = Integer.parseInt(idAttValue);
            h.put((IAttributeAware)claim, (Paint)objectIds2Paint.get(objectId));
        }
        return h;
    }

    public static JFreeChart computeAnomalyHistogram(ITrace trace, String idAtt, Set<String> uniquenessAtts) {
        List claims = trace.getEvents();
        BehavioralPartition part = BehavioralAnalysis.partition((Iterable)claims, (String)idAtt, uniquenessAtts);
        List hist = BehavioralAnalysis.createBehavioralHistogram((BehavioralPartition)part);
        final ArrayList<String> tooltips = new ArrayList<String>();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        for (HistogramEntry h : hist) {
            dataset.addValue((double)h.size(), (Comparable)((Object)"rowKey"), (Comparable)((Object)("h" + i)));
            tooltips.add(AnalysisUtil.getToolTip(idAtt, h));
            ++i;
        }
        JFreeChart chart = ChartFactory.createBarChart(null, (String)"", (String)"size", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setRangePannable(false);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDefaultToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int r, int c) {
                return (String)tooltips.get(c);
            }
        });
        renderer.setMaximumBarWidth(100.0);
        renderer.setMinimumBarLength(0.0);
        return chart;
    }

    private static String getToolTip(String idAtt, HistogramEntry e) {
        StringBuilder b = new StringBuilder("<html>" + idAtt + " = {");
        ArrayList oids = new ArrayList();
        oids.addAll(e.getCentralObjectIds());
        Collections.sort(oids);
        int i = 0;
        Iterator it = oids.iterator();
        while (it.hasNext()) {
            Integer oid = (Integer)it.next();
            b.append(oid);
            if (it.hasNext()) {
                b.append(",");
            }
            if (++i % 10 != 0) continue;
            i = 0;
            b.append("<br/>");
        }
        b.append("}<br/>");
        for (Map.Entry entry : e.getCommonAttributeValues().entrySet()) {
            b.append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append("<br/>");
        }
        b.append("</html>");
        return b.toString();
    }

    public static JFreeChart createResourceUsageHistogramPlot(ITrace trace, List<IResource> selected, Collection<String> resourceDescriptionAtts, boolean cumulative) {
        Map m = ResourceAnalysis.compute((ITrace)trace, selected, (boolean)cumulative);
        DefaultCategoryDataset dataset = AnalysisUtil.createDataset(m, resourceDescriptionAtts);
        JFreeChart chart = ChartFactory.createBarChart(null, (String)"# of concurrent claims on resource", (String)"% of time", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setRangePannable(false);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setMaximumBarWidth(100.0);
        renderer.setMinimumBarLength(0.0);
        return chart;
    }

    public static JFreeChart createResourceUtilizationPlot(ITrace trace, List<IResource> selected, boolean useAmount, SignalModifier mod, boolean alsoShowInst) throws AnalysisException {
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(trace.getTimeUnit(), false) + ")";
        String yAxisLabel = useAmount ? "Claimed amount" : "Number of parallel claims";
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)new XYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        HashMap<String, IPsop> usage = new HashMap<String, IPsop>();
        for (IResource r : selected) {
            String rName = TraceHelper.getValues((IAttributeAware)r, (boolean)false);
            IPsop p = useAmount ? SignalUtil.getResourceAmount((ITrace)trace, (IResource)r, (SignalModifier)mod) : SignalUtil.getResourceClients((ITrace)trace, (IResource)r, (SignalModifier)mod);
            Object modSpec = "_inst";
            if (mod.appliesConvolution()) {
                modSpec = "[w=" + mod.getWindowWidth() + " " + AnalysisUtil.getStringFor(mod.getWindowTimeUnit(), false) + "]";
            }
            usage.put(rName + (String)modSpec, p);
            if (!mod.appliesConvolution() || !alsoShowInst) continue;
            IPsop inst = useAmount ? SignalUtil.getResourceAmount((ITrace)trace, (IResource)r, (SignalModifier)new SignalModifier(mod.getScale())) : SignalUtil.getResourceClients((ITrace)trace, (IResource)r, (SignalModifier)new SignalModifier(mod.getScale()));
            usage.put(rName + "_inst", inst);
        }
        ((XYPlot)chart.getPlot()).setDataset(AnalysisUtil.createPsopDataset(usage));
        return chart;
    }

    private static XYDataset createPsopDataset(Map<String, IPsop> usage) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Map.Entry<String, IPsop> e : usage.entrySet()) {
            dataset.addSeries(AnalysisUtil.createSeriesData(e.getKey(), e.getValue(), true, true));
        }
        return dataset;
    }

    private static XYSeries createSeriesData(String id, IPsop p, boolean addZeroStart, boolean addZeroEnd) {
        XYSeries series = new XYSeries((Comparable)((Object)id));
        boolean first = true;
        Iterator it = p.getFragments().iterator();
        while (it.hasNext()) {
            IPsopFragment f = (IPsopFragment)it.next();
            double t0 = f.dom().lb().doubleValue();
            double t1 = f.dom().ub().doubleValue();
            if (first && addZeroStart) {
                series.add(t0, 0.0);
            }
            first = false;
            series.add(t0, PsopHelper.valueAt((IPsopFragment)f, (Number)t0));
            series.add(t1, PsopHelper.valueAt((IPsopFragment)f, (Number)t1));
            if (it.hasNext() || !addZeroEnd) continue;
            series.add(t1, 0.0);
        }
        return series;
    }

    private static DefaultCategoryDataset createDataset(Map<IResource, TreeMap<Integer, Double>> histos, Collection<String> resourceDescriptionAtts) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<IResource, TreeMap<Integer, Double>> e : histos.entrySet()) {
            TreeMap<Integer, Double> values = e.getValue();
            int i = 0;
            while (i <= values.lastKey()) {
                Double d = values.get(i);
                if (d == null) {
                    d = 0.0;
                }
                String name = TraceHelper.getValues((IAttributeAware)((IAttributeAware)e.getKey()), resourceDescriptionAtts, (boolean)false);
                dataset.addValue((Number)d, (Comparable)((Object)name), (Comparable)Integer.valueOf(i));
                ++i;
            }
        }
        return dataset;
    }

    public static JFreeChart createLatencyPlot(ITrace trace, String idAttribute, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        IPsop lat = SignalUtil.getLatency((ITrace)trace, (String)idAttribute, (TimeUnit)scaleUnit, (double)windowWidth, (TimeUnit)windowUnit);
        String yAxisLabel = "Latency (" + AnalysisUtil.getStringFor(scaleUnit, false) + ")";
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(trace.getTimeUnit(), false) + ")";
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(AnalysisUtil.createSeriesData("latency", lat, false, false));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        return chart;
    }

    public static JFreeChart createWipPlot(ITrace trace, String idAttribute, String valueUnit, SignalModifier mod) {
        IPsop pd = SignalUtil.getWip((ITrace)trace, (String)idAttribute, (SignalModifier)mod);
        String yAxisLabel = "Wip (number of " + valueUnit + ")";
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(trace.getTimeUnit(), false) + ")";
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(AnalysisUtil.createSeriesData("wip", pd, true, true));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        return chart;
    }

    public static JFreeChart createThroughputPlot(ITrace trace, String idAttribute, String valueUnit, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        return AnalysisUtil.createThroughputPlots(trace, idAttribute, valueUnit, scaleUnit, windowUnit, windowWidth);
    }

    public static JFreeChart createThroughputPlots(ITrace trace, String idAttribute, String valueUnit, TimeUnit scaleUnit, TimeUnit windowUnit, double ... windowWidth) {
        IPsop[] tps = new IPsop[windowWidth.length];
        String[] legendLabels = new String[windowWidth.length];
        int i = 0;
        while (i < windowWidth.length) {
            tps[i] = SignalUtil.getTP((ITrace)trace, (String)idAttribute, (TimeUnit)scaleUnit, (double)windowWidth[i], (TimeUnit)windowUnit);
            legendLabels[i] = windowWidth[i] > 0.0 ? "tp[w=" + windowWidth[i] + " " + AnalysisUtil.getStringFor(windowUnit, false) + "]" : "tp_inst";
            ++i;
        }
        return AnalysisUtil.createTPplot(trace, idAttribute, valueUnit, scaleUnit, legendLabels, tps);
    }

    public static JFreeChart createChart(TimeUnit tu, String yAxisLabel, String[] legendLabels, IPsop ... psops) {
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(tu, false) + ")";
        XYSeriesCollection dataset = new XYSeriesCollection();
        int i = 0;
        while (i < psops.length) {
            dataset.addSeries(AnalysisUtil.createSeriesData(legendLabels[i], psops[i], true, true));
            ++i;
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    private static JFreeChart createTPplot(ITrace trace, String idAttribute, String valueUnit, TimeUnit scaleUnit, String[] legendLabels, IPsop[] tps) {
        if (valueUnit == null) {
            valueUnit = idAttribute + "s";
        }
        String yAxisLabel = "Throughput (" + (String)valueUnit + " / " + AnalysisUtil.getStringFor(scaleUnit, true) + ")";
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(trace.getTimeUnit(), false) + ")";
        XYSeriesCollection dataset = new XYSeriesCollection();
        int i = 0;
        while (i < tps.length) {
            dataset.addSeries(AnalysisUtil.createSeriesData(legendLabels[i], tps[i], true, true));
            ++i;
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    public static JFreeChart createEventTPplot(TimeUnit traceTimeUnit, List<IEvent> events, IInterval dom, String valueUnit, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        if (valueUnit == null) {
            valueUnit = "objects";
        }
        String yAxisLabel = "Throughput (" + valueUnit + " / " + AnalysisUtil.getStringFor(scaleUnit, true) + ")";
        String xAxisLabel = "Time (" + AnalysisUtil.getStringFor(traceTimeUnit, false) + ")";
        Object legendLabel = "tp_inst";
        if (windowWidth > 0.0) {
            legendLabel = "tp[w=" + windowWidth + " " + AnalysisUtil.getStringFor(windowUnit, false) + "]";
        }
        IPsop tp = SignalUtil.getTP((TimeUnit)traceTimeUnit, (IInterval)dom, events, (TimeUnit)scaleUnit, (double)windowWidth, (TimeUnit)windowUnit);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(AnalysisUtil.createSeriesData((String)legendLabel, tp, true, true));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    private static String getStringFor(TimeUnit tu, boolean singular) {
        String t = tu.toString().toLowerCase();
        if (singular) {
            return t.substring(0, t.length() - 1);
        }
        return t;
    }
}

