/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.LanguageExtension;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSet;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSets;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.dependency.DependencyCollector;
import com.microsoft.java.bs.gradle.plugin.utils.AndroidUtils;
import com.microsoft.java.bs.gradle.plugin.utils.SourceSetUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;

public class SourceSetsModelBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals(GradleSourceSets.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        List<GradleSourceSet> sourceSets = AndroidUtils.isAndroidProject(project) ? AndroidUtils.getBuildVariantsAsGradleSourceSets(project) : this.getSourceSetContainer(project).stream().map(ss -> this.getSourceSet(project, (SourceSet)ss)).collect(Collectors.toList());
        this.excludeSourceDirsFromModules(sourceSets);
        return new DefaultGradleSourceSets(sourceSets);
    }

    private DefaultGradleSourceSet getSourceSet(Project project, SourceSet sourceSet) {
        DefaultGradleSourceSet gradleSourceSet = new DefaultGradleSourceSet();
        gradleSourceSet.setBuildTargetDependencies(new HashSet<BuildTargetDependency>());
        gradleSourceSet.setGradleVersion(project.getGradle().getGradleVersion());
        gradleSourceSet.setProjectName(project.getName());
        String projectPath = project.getPath();
        gradleSourceSet.setProjectPath(projectPath);
        gradleSourceSet.setProjectDir(project.getProjectDir());
        gradleSourceSet.setRootDir(project.getRootDir());
        gradleSourceSet.setSourceSetName(sourceSet.getName());
        String classesTaskName = SourceSetUtils.getFullTaskName(projectPath, sourceSet.getClassesTaskName());
        gradleSourceSet.setClassesTaskName(classesTaskName);
        String cleanTaskName = SourceSetUtils.getFullTaskName(projectPath, "clean");
        gradleSourceSet.setCleanTaskName(cleanTaskName);
        HashSet<String> taskNames = new HashSet<String>();
        gradleSourceSet.setTaskNames(taskNames);
        String projectName = SourceSetUtils.stripPathPrefix(projectPath);
        if (projectName.isEmpty()) {
            projectName = project.getName();
        }
        String displayName = projectName + " [" + gradleSourceSet.getSourceSetName() + ']';
        gradleSourceSet.setDisplayName(displayName);
        gradleSourceSet.setModuleDependencies(this.getModuleDependencies(project, sourceSet));
        HashMap<String, LanguageExtension> extensions = new HashMap<String, LanguageExtension>();
        HashSet<File> srcDirs = new HashSet<File>();
        HashSet<File> generatedSrcDirs = new HashSet<File>();
        HashSet<File> sourceOutputDirs = new HashSet<File>();
        for (LanguageModelBuilder languageModelBuilder : SourceSetUtils.getSupportedLanguageModelBuilders()) {
            LanguageExtension extension = languageModelBuilder.getExtensionFor(project, sourceSet, gradleSourceSet.getModuleDependencies());
            if (extension == null) continue;
            String compileTaskName = SourceSetUtils.getFullTaskName(projectPath, extension.getCompileTaskName());
            taskNames.add(compileTaskName);
            srcDirs.addAll(extension.getSourceDirs());
            generatedSrcDirs.addAll(extension.getGeneratedSourceDirs());
            sourceOutputDirs.add(extension.getClassesDir());
            extensions.put(languageModelBuilder.getLanguageId(), extension);
        }
        gradleSourceSet.setSourceDirs(srcDirs);
        gradleSourceSet.setGeneratedSourceDirs(generatedSrcDirs);
        gradleSourceSet.setExtensions(extensions);
        gradleSourceSet.setSourceOutputDirs(sourceOutputDirs);
        LinkedList<File> compileClasspath = new LinkedList<File>();
        try {
            compileClasspath.addAll(sourceSet.getCompileClasspath().getFiles());
        }
        catch (GradleException languageModelBuilder) {
            // empty catch block
        }
        gradleSourceSet.setCompileClasspath(compileClasspath);
        Set resourceDirs = sourceSet.getResources().getSrcDirs();
        gradleSourceSet.setResourceDirs(resourceDirs);
        File resourceOutputDir = sourceSet.getOutput().getResourcesDir();
        HashSet<File> resourceOutputDirs = new HashSet<File>();
        if (resourceOutputDir != null) {
            resourceOutputDirs.add(resourceOutputDir);
        }
        gradleSourceSet.setResourceOutputDirs(resourceOutputDirs);
        Map<File, List<File>> archiveOutputFiles = this.getArchiveOutputFiles(project, sourceSet);
        gradleSourceSet.setArchiveOutputFiles(archiveOutputFiles);
        if (!sourceOutputDirs.isEmpty()) {
            Set<Test> testTasks = this.tasksWithType(project, Test.class);
            for (Test testTask : testTasks) {
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) >= 0) {
                    FileCollection files = testTask.getTestClassesDirs();
                    for (File sourceOutputDir : sourceOutputDirs) {
                        if (!files.contains(sourceOutputDir)) continue;
                        gradleSourceSet.setHasTests(true);
                        break;
                    }
                    if (!gradleSourceSet.hasTests()) continue;
                    break;
                }
                try {
                    Method getTestClassesDir = testTask.getClass().getMethod("getTestClassesDir", new Class[0]);
                    Object testClassesDir = getTestClassesDir.invoke((Object)testTask, new Object[0]);
                    for (File sourceOutputDir : sourceOutputDirs) {
                        if (!sourceOutputDir.equals(testClassesDir)) continue;
                        gradleSourceSet.setHasTests(true);
                        break;
                    }
                    if (!gradleSourceSet.hasTests()) continue;
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                }
            }
        }
        return gradleSourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Task> Set<T> tasksWithType(Project project, Class<T> clazz) {
        Project project2 = project.getRootProject();
        synchronized (project2) {
            return new HashSet(project.getTasks().withType(clazz));
        }
    }

    private Map<File, List<File>> getArchiveOutputFiles(Project project, SourceSet sourceSet) {
        Set<AbstractArchiveTask> archiveTasks = this.tasksWithType(project, AbstractArchiveTask.class);
        HashMap<File, List<File>> archiveOutputFiles = new HashMap<File, List<File>>();
        for (AbstractArchiveTask archiveTask : archiveTasks) {
            Set<Object> archiveSourcePaths = this.getArchiveSourcePaths((CopySpec)archiveTask.getRootSpec());
            for (Object sourcePath : archiveSourcePaths) {
                if (!sourceSet.getOutput().equals(sourcePath)) continue;
                File archiveFile = GradleVersion.current().compareTo(GradleVersion.version((String)"5.1")) >= 0 ? ((RegularFile)archiveTask.getArchiveFile().get()).getAsFile() : archiveTask.getArchivePath();
                LinkedList sourceSetOutputs = new LinkedList(sourceSet.getOutput().getFiles());
                archiveOutputFiles.put(archiveFile, sourceSetOutputs);
            }
        }
        return archiveOutputFiles;
    }

    private Set<GradleModuleDependency> getModuleDependencies(Project project, SourceSet sourceSet) {
        Set<String> configurationNames = this.getClasspathConfigurationNames(sourceSet);
        return DependencyCollector.getModuleDependencies(project, configurationNames);
    }

    private void excludeSourceDirsFromModules(List<GradleSourceSet> sourceSets) {
        HashSet<File> exclusions = new HashSet<File>();
        for (GradleSourceSet sourceSet : sourceSets) {
            if (sourceSet.getSourceDirs() != null) {
                exclusions.addAll(sourceSet.getSourceDirs());
            }
            if (sourceSet.getGeneratedSourceDirs() != null) {
                exclusions.addAll(sourceSet.getGeneratedSourceDirs());
            }
            if (sourceSet.getResourceDirs() != null) {
                exclusions.addAll(sourceSet.getResourceDirs());
            }
            if (sourceSet.getSourceOutputDirs() != null) {
                exclusions.addAll(sourceSet.getSourceOutputDirs());
            }
            if (sourceSet.getResourceOutputDirs() != null) {
                exclusions.addAll(sourceSet.getResourceOutputDirs());
            }
            if (sourceSet.getArchiveOutputFiles() == null) continue;
            exclusions.addAll(sourceSet.getArchiveOutputFiles().keySet());
        }
        Set exclusionUris = exclusions.stream().map(File::toURI).collect(Collectors.toSet());
        for (GradleSourceSet sourceSet : sourceSets) {
            Set<GradleModuleDependency> filteredModuleDependencies = sourceSet.getModuleDependencies().stream().filter(mod -> mod.getArtifacts().stream().anyMatch(art -> !exclusionUris.contains(art.getUri()))).collect(Collectors.toSet());
            if (!(sourceSet instanceof DefaultGradleSourceSet)) continue;
            ((DefaultGradleSourceSet)sourceSet).setModuleDependencies(filteredModuleDependencies);
        }
    }

    private Collection<SourceSet> getSourceSetContainer(Project project) {
        SourceSetContainer sourceSetContainer;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) >= 0 && (sourceSetContainer = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class)) != null) {
            return sourceSetContainer;
        }
        try {
            Method getConvention = project.getClass().getMethod("getConvention", new Class[0]);
            Object convention = getConvention.invoke((Object)project, new Object[0]);
            Method getPlugins = convention.getClass().getMethod("getPlugins", new Class[0]);
            Object plugins = getPlugins.invoke(convention, new Object[0]);
            Method getGet = plugins.getClass().getMethod("get", Object.class);
            Object pluginConvention = getGet.invoke(plugins, "java");
            if (pluginConvention != null) {
                Method getSourceSetsMethod = pluginConvention.getClass().getMethod("getSourceSets", new Class[0]);
                return (SourceSetContainer)getSourceSetsMethod.invoke(pluginConvention, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return new LinkedList<SourceSet>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<Object> getArchiveSourcePaths(CopySpec copySpec) {
        HashSet<Object> sourcePaths = new HashSet<Object>();
        if (!(copySpec instanceof DefaultCopySpec)) return sourcePaths;
        DefaultCopySpec defaultCopySpec = (DefaultCopySpec)copySpec;
        sourcePaths.addAll(defaultCopySpec.getSourcePaths());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.2")) >= 0) {
            for (CopySpec child : defaultCopySpec.getChildren()) {
                sourcePaths.addAll(this.getArchiveSourcePaths(child));
            }
            return sourcePaths;
        } else {
            try {
                Method getChildren = defaultCopySpec.getClass().getMethod("getChildren", new Class[0]);
                Object children = getChildren.invoke((Object)defaultCopySpec, new Object[0]);
                if (!(children instanceof Iterable)) return sourcePaths;
                for (Object child : (Iterable)children) {
                    if (!(child instanceof CopySpec)) continue;
                    sourcePaths.addAll(this.getArchiveSourcePaths((CopySpec)child));
                }
                return sourcePaths;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return sourcePaths;
    }

    private Set<String> getClasspathConfigurationNames(SourceSet sourceSet) {
        HashSet<String> configurationNames = new HashSet<String>();
        configurationNames.add(sourceSet.getCompileClasspathConfigurationName());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0) {
            configurationNames.add(sourceSet.getRuntimeClasspathConfigurationName());
        }
        return configurationNames;
    }
}

