/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.RuntimeEnvironment;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class EclipseVmUtil {
    private static final String VM_ID_PREFIX = "com.microsoft.gradle.bs.vm.";

    public static IVMInstall findOrRegisterStandardVM(String expectedVersion, String lowestVersion, String highestVersion, File location) {
        Optional<IVMInstall> vm = EclipseVmUtil.findRegisteredVM(expectedVersion, lowestVersion, highestVersion);
        return vm.isPresent() ? vm.get() : EclipseVmUtil.registerNewVM(location);
    }

    private static Optional<IVMInstall> findRegisteredVM(String expectedVersion, String lowestVersion, String highestVersion) {
        Optional<IExecutionEnvironment> possibleExecutionEnvironment = EclipseVmUtil.findExecutionEnvironment(lowestVersion);
        if (!possibleExecutionEnvironment.isPresent()) {
            return Optional.empty();
        }
        IExecutionEnvironment executionEnvironment = possibleExecutionEnvironment.get();
        IVMInstall vm = EclipseVmUtil.getCompatibleVMWithHighestVersion(expectedVersion, lowestVersion, highestVersion, executionEnvironment);
        return Optional.ofNullable(vm);
    }

    private static IVMInstall getCompatibleVMWithHighestVersion(String expectedVersion, String lowestVersion, String highestVersion, IExecutionEnvironment executionEnvironment) {
        IVMInstall[] compatibleVMs;
        IVMInstall vm = null;
        IVMInstall[] iVMInstallArray = compatibleVMs = executionEnvironment.getCompatibleVMs();
        int n = compatibleVMs.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall2 vm2;
            String javaVersion;
            IVMInstall compatibleVm = iVMInstallArray[n2];
            File installLocation = compatibleVm.getInstallLocation();
            if (installLocation != null && installLocation.exists() && !EclipseVmUtil.isEmbeddedJre(installLocation.getAbsolutePath()) && compatibleVm instanceof IVMInstall2 && (javaVersion = (vm2 = (IVMInstall2)compatibleVm).getJavaVersion()) != null) {
                if (JavaCore.compareJavaVersions((String)javaVersion, (String)expectedVersion) == 0) {
                    return compatibleVm;
                }
                if (!(lowestVersion != null && JavaCore.compareJavaVersions((String)lowestVersion, (String)javaVersion) > 0 || highestVersion != null && JavaCore.compareJavaVersions((String)highestVersion, (String)javaVersion) < 0 || vm != null && JavaCore.compareJavaVersions((String)((IVMInstall2)vm).getJavaVersion(), (String)javaVersion) >= 0)) {
                    vm = compatibleVm;
                }
            }
            ++n2;
        }
        return vm;
    }

    private static boolean isEmbeddedJre(String path) {
        return path.contains("extensions") && path.contains("redhat.java") && path.contains("jre");
    }

    public static Optional<IExecutionEnvironment> findExecutionEnvironment(String version) {
        String executionEnvironmentId = EclipseVmUtil.getExecutionEnvironmentId(version);
        IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n2];
            if (executionEnvironment.getId().equals(executionEnvironmentId)) {
                return Optional.of(executionEnvironment);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static Map<String, String> getAllVmInstalls() {
        List vmList = Stream.of(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream).toList();
        HashMap<Object, File> vmInstalls = new HashMap<Object, File>();
        for (IVMInstall vmInstall : vmList) {
            AbstractVMInstall vm;
            Object javaVersion;
            if (!(vmInstall instanceof AbstractVMInstall) || StringUtils.isBlank((CharSequence)(javaVersion = EclipseVmUtil.getMajorJavaVersion((vm = (AbstractVMInstall)vmInstall).getJavaVersion()))) || vm.getInstallLocation() == null || EclipseVmUtil.isEmbeddedJre(vm.getInstallLocation().getAbsolutePath())) continue;
            vmInstalls.putIfAbsent(javaVersion, vm.getInstallLocation());
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        Set runtimes = preferences.getRuntimes();
        for (RuntimeEnvironment runtime : runtimes) {
            String javaVersion;
            File javaHome;
            if (StringUtils.isBlank((CharSequence)runtime.getPath()) || vmInstalls.containsValue(javaHome = new File(runtime.getPath())) || !StringUtils.isNotBlank((CharSequence)(javaVersion = new StandardVMType().readReleaseVersion(javaHome)))) continue;
            vmInstalls.put(EclipseVmUtil.getMajorJavaVersion(javaVersion), javaHome);
        }
        HashMap<String, String> vmInstallsUri = new HashMap<String, String>();
        for (Map.Entry entry : vmInstalls.entrySet()) {
            vmInstallsUri.put((String)entry.getKey(), ((File)entry.getValue()).toURI().toString());
        }
        return vmInstallsUri;
    }

    private static String getMajorJavaVersion(String version) {
        if (version == null) {
            return null;
        }
        return CompilerOptions.versionFromJdkLevel((long)CompilerOptions.versionToJdkLevel((String)version));
    }

    private static String getExecutionEnvironmentId(String version) {
        if ("1.1".equals(version)) {
            return "JRE-1.1";
        }
        if (Arrays.asList("1.5", "1.4", "1.3", "1.2").contains(version)) {
            return "J2SE-" + version;
        }
        return "JavaSE-" + version;
    }

    private static IVMInstall registerNewVM(File location) {
        IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        String vmId = EclipseVmUtil.generateUniqueVMId(installType);
        VMStandin vm = new VMStandin(installType, vmId);
        String javaVersion = new StandardVMType().readReleaseVersion(location);
        String name = StringUtils.isBlank((CharSequence)javaVersion) ? "Java SE" : "JavaSE-" + EclipseVmUtil.getMajorJavaVersion(javaVersion);
        vm.setName(name);
        vm.setInstallLocation(location);
        return vm.convertToRealVM();
    }

    private static String generateUniqueVMId(IVMInstallType type) {
        int counter = 1;
        String vmId = VM_ID_PREFIX + counter;
        while (type.findVMInstall(vmId) != null) {
            vmId = VM_ID_PREFIX + ++counter;
        }
        return vmId;
    }

    private EclipseVmUtil() {
    }
}

