/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder.tree;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.tree.OffsetInfo;
import com.vladsch.flexmark.util.sequence.builder.tree.Segment;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentOffsetTree;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasedOffsetTracker {
    @NotNull
    protected final BasedSequence sequence;
    @NotNull
    protected final SegmentOffsetTree segmentOffsetTree;
    @Nullable
    private Segment lastSegment;

    protected BasedOffsetTracker(@NotNull BasedSequence sequence, @NotNull SegmentTree segmentTree) {
        this.sequence = sequence;
        this.segmentOffsetTree = segmentTree.getSegmentOffsetTree(sequence.getBaseSequence());
    }

    protected BasedOffsetTracker(@NotNull BasedSequence sequence, @NotNull SegmentOffsetTree segmentOffsetTree) {
        this.sequence = sequence;
        this.segmentOffsetTree = segmentOffsetTree;
    }

    public int size() {
        return this.segmentOffsetTree.size();
    }

    @NotNull
    public OffsetInfo getOffsetInfo(int offset, boolean isEndOffset) {
        OffsetInfo lastResult;
        int offsetEnd;
        int n = offsetEnd = isEndOffset ? offset : offset + 1;
        if (offsetEnd <= this.sequence.getStartOffset()) {
            lastResult = new OffsetInfo(-1, offset, true, 0);
        } else if (offset >= this.sequence.getEndOffset()) {
            lastResult = new OffsetInfo(this.segmentOffsetTree.size(), offset, true, this.sequence.length());
        } else {
            Segment seg = this.segmentOffsetTree.findSegmentByOffset(offset, this.sequence.getBaseSequence(), this.lastSegment);
            if (seg == null) {
                if (offset < this.segmentOffsetTree.getSegment(0, this.sequence).getStartOffset()) {
                    lastResult = new OffsetInfo(-1, offset, true, 0);
                } else {
                    if (offset < this.segmentOffsetTree.getSegment(this.segmentOffsetTree.size() - 1, this.sequence).getEndOffset()) {
                        throw new IllegalStateException("Unexpected");
                    }
                    lastResult = new OffsetInfo(this.segmentOffsetTree.size(), offset, true, this.sequence.length());
                }
            } else {
                this.lastSegment = seg;
                if (offsetEnd > seg.getStartOffset() && offset < seg.getEndOffset()) {
                    int startIndex = seg.getStartIndex() + offset - seg.getStartOffset();
                    int endIndex = seg.getStartIndex() + offsetEnd - seg.getStartOffset();
                    lastResult = new OffsetInfo(seg.getPos(), offset, isEndOffset, startIndex, endIndex);
                } else if (offsetEnd <= seg.getStartOffset()) {
                    int endIndex;
                    int startIndex;
                    Segment textSegment = this.segmentOffsetTree.getPreviousText(seg, this.sequence);
                    if (textSegment != null) {
                        startIndex = textSegment.getStartIndex();
                        endIndex = textSegment.getEndIndex();
                    } else {
                        endIndex = startIndex = seg.getStartIndex();
                    }
                    lastResult = new OffsetInfo(seg.getPos() - 1, offset, true, startIndex, endIndex);
                } else if (offset >= seg.getEndOffset()) {
                    int endIndex;
                    int startIndex;
                    Segment textSegment = this.segmentOffsetTree.getNextText(seg, this.sequence);
                    if (textSegment != null) {
                        startIndex = textSegment.getStartIndex();
                        endIndex = textSegment.getEndIndex();
                    } else {
                        endIndex = startIndex = seg.getEndIndex();
                    }
                    lastResult = new OffsetInfo(seg.getPos() + 1, offset, true, startIndex, endIndex);
                } else {
                    throw new IllegalStateException(String.format("Unexpected offset: [%d, %d), seg: %s, not inside nor at start nor at end", offset, offsetEnd, seg.toString()));
                }
            }
        }
        return lastResult;
    }

    @NotNull
    public BasedSequence getSequence() {
        return this.sequence;
    }

    @NotNull
    public SegmentOffsetTree getSegmentOffsetTree() {
        return this.segmentOffsetTree;
    }

    public String toString() {
        return "BasedOffsetTracker{tree=" + this.segmentOffsetTree + "}";
    }

    @NotNull
    public static BasedOffsetTracker create(@NotNull BasedSequence sequence) {
        SegmentTree segmentTree = sequence.getSegmentTree();
        return new BasedOffsetTracker(sequence, segmentTree);
    }

    @NotNull
    public static BasedOffsetTracker create(@NotNull BasedSequence sequence, @NotNull SegmentOffsetTree segmentOffsetTree) {
        return new BasedOffsetTracker(sequence, segmentOffsetTree);
    }
}

