/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.JavacCompilationUnitResolver;
import org.eclipse.jdt.core.dom.JavacConverter;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.javac.dom.JavacAnnotationBinding;
import org.eclipse.jdt.internal.javac.dom.JavacErrorMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacErrorTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacLambdaBinding;
import org.eclipse.jdt.internal.javac.dom.JavacMemberValuePairBinding;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacModuleBinding;
import org.eclipse.jdt.internal.javac.dom.JavacPackageBinding;
import org.eclipse.jdt.internal.javac.dom.JavacRecoveredTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeVariableBinding;
import org.eclipse.jdt.internal.javac.dom.JavacVariableBinding;

public class JavacBindingResolver
extends BindingResolver {
    private JavacTask javacTask;
    public final Context context;
    public Map<Symbol, ASTNode> symbolToDeclaration;
    public final IJavaProject javaProject;
    private JavacConverter converter;
    boolean isRecoveringBindings = false;
    public final Bindings bindings = new Bindings(this);
    private WorkingCopyOwner owner;
    private HashMap<ASTNode, IBinding> resolvedBindingsCache = new HashMap();
    private java.util.List<JCTree.JCCompilationUnit> javacCompilationUnits;
    private Map<String, String> directBoxingMap = null;
    private Map<String, java.util.List<String>> unboxingMapWithConversions = null;
    private Map<String, java.util.List<String>> boxingMapWithConversions = null;

    public JavacBindingResolver(IJavaProject javaProject, JavacTask javacTask, Context context, JavacConverter converter, WorkingCopyOwner owner, java.util.List<JCTree.JCCompilationUnit> javacCompilationUnits) {
        this.javacTask = javacTask;
        this.context = context;
        this.javaProject = javaProject;
        this.converter = converter;
        this.owner = owner;
        this.javacCompilationUnits = javacCompilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.symbolToDeclaration != null) {
            return;
        }
        JavacTask tmpTask = this.javacTask;
        if (tmpTask == null) {
            return;
        }
        Object object = tmpTask;
        synchronized (object) {
            if (this.javacTask == null) {
                return;
            }
            boolean alreadyAnalyzed = this.converter.domToJavac.values().stream().map(TreeInfo::symbolFor).anyMatch(Objects::nonNull);
            if (!alreadyAnalyzed) {
                try {
                    JavacTask javacTask = this.javacTask;
                    if (javacTask instanceof JavacTaskImpl) {
                        Iterable<? extends Element> elements;
                        JavacTaskImpl javacTaskImpl = (JavacTaskImpl)javacTask;
                        if (this.javacCompilationUnits != null && !this.javacCompilationUnits.isEmpty()) {
                            java.util.List<JCTree.JCCompilationUnit> trees = this.javacCompilationUnits;
                            elements = javacTaskImpl.enter(trees);
                        } else {
                            elements = javacTaskImpl.enter();
                        }
                        elements = javacTaskImpl.analyze(elements);
                    } else {
                        Iterable<? extends Element> elements = this.javacTask.analyze();
                    }
                }
                catch (IOException | Error | RuntimeException e) {
                    ILog.get().error(e.getMessage(), e);
                }
            }
            JavacCompilationUnitResolver.cleanup(this.context);
        }
        this.javacTask = null;
        object = this;
        synchronized (object) {
            if (this.symbolToDeclaration == null) {
                HashMap<Symbol, ASTNode> wipSymbolToDeclaration = new HashMap<Symbol, ASTNode>();
                this.converter.domToJavac.forEach((jdt, javac) -> {
                    Symbol symbol;
                    if ((jdt instanceof MethodDeclaration || jdt instanceof VariableDeclaration || jdt instanceof EnumConstantDeclaration || jdt instanceof AnnotationTypeMemberDeclaration || jdt instanceof AbstractTypeDeclaration || jdt instanceof AnonymousClassDeclaration || jdt instanceof TypeParameter) && (symbol = TreeInfo.symbolFor(javac)) != null) {
                        wipSymbolToDeclaration.put(symbol, (ASTNode)jdt);
                    }
                });
                wipSymbolToDeclaration.keySet().forEach(sym -> this.bindings.getBinding((Symbol)sym, null));
                this.symbolToDeclaration = wipSymbolToDeclaration;
            }
        }
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        return this.findNode(this.getJavacSymbol(binding));
    }

    public IBinding findBinding(String bindingKey) {
        return this.bindings.getBinding(bindingKey);
    }

    private void compoundListWithAction(HashSet<String> list, Function<String, String> f) {
        Iterator<String> it = new ArrayList<String>(list).iterator();
        while (it.hasNext()) {
            String transformed = f.apply(it.next());
            if (transformed == null || list.contains(transformed)) continue;
            list.add(transformed);
        }
    }

    public IBinding findUnresolvedBinding(String bindingKey) {
        record Pair(JavacTypeBinding binding, int weight) {
        }
        boolean isUnresolved;
        boolean bl = isUnresolved = bindingKey.startsWith("Q") || bindingKey.startsWith("+Q") || bindingKey.startsWith("-Q");
        if (!isUnresolved) {
            return this.findBinding(bindingKey);
        }
        boolean bkExtends = bindingKey.startsWith("+");
        boolean bkSuper = bindingKey.startsWith("-");
        String withoutSuperExtends = bindingKey.startsWith("+") || bindingKey.startsWith("-") ? bindingKey.substring(1) : bindingKey;
        HashSet<String> validNames = new HashSet<String>();
        validNames.add(bindingKey);
        this.compoundListWithAction(validNames, x -> x.replaceAll("\\.", "/"));
        this.compoundListWithAction(validNames, x -> x.endsWith(";") ? x.substring(0, x.length() - 1) : null);
        this.compoundListWithAction(validNames, x -> x.startsWith("+") || x.startsWith("-") ? x.substring(1) : null);
        this.compoundListWithAction(validNames, x -> x.lastIndexOf(".", x.length() - 1) != -1 ? x.substring(x.lastIndexOf(".") + 1) : null);
        this.compoundListWithAction(validNames, x -> x.startsWith("Q") ? x.substring(1) : null);
        this.compoundListWithAction(validNames, x -> x.contains("<Q") ? x.replaceAll("<Q", "<") : null);
        this.compoundListWithAction(validNames, x -> x.startsWith("+Q") ? x.replaceAll("\\+Q", "? extends ") : null);
        this.compoundListWithAction(validNames, x -> x.startsWith("-Q") ? x.replaceAll("-Q", "? super ") : null);
        String bindingKeySimpleName = Signature.getSignatureSimpleName((String)withoutSuperExtends);
        validNames.add(bindingKeySimpleName);
        ArrayList<JavacTypeBinding> c = new ArrayList<JavacTypeBinding>(this.bindings.typeBinding.values());
        int matchesKey = 128;
        int matchesSimpleName = 64;
        int matchesSuperExtends = 16;
        ArrayList collector = new ArrayList();
        c.stream().forEach(x -> {
            String n;
            int total = 0;
            String k = x.getKey();
            if (validNames.contains(k)) {
                total += matchesKey;
            }
            if (validNames.contains(n = x.getName())) {
                total += matchesSimpleName;
            }
            if ((bkExtends || bkSuper) && x.isWildcardType() && x.getBound() != null) {
                if (bkExtends && x.isUpperbound()) {
                    total += matchesSuperExtends;
                } else if (bkSuper && !x.isUpperbound()) {
                    total += matchesSuperExtends;
                }
            }
            if (total > 0) {
                collector.add(new Pair((JavacTypeBinding)x, total));
            }
        });
        Collections.sort(collector, (o1, o2) -> o2.weight - o1.weight);
        return collector.size() > 0 ? ((Pair)collector.get((int)0)).binding : null;
    }

    public ASTNode findDeclaringNode(String bindingKey) {
        this.resolve();
        IBinding binding = this.bindings.getBinding(bindingKey);
        if (binding == null) {
            return null;
        }
        return this.findDeclaringNode(binding);
    }

    private Symbol getJavacSymbol(IBinding binding) {
        if (binding instanceof JavacMemberValuePairBinding) {
            JavacMemberValuePairBinding valuePair = (JavacMemberValuePairBinding)binding;
            return this.getJavacSymbol((IBinding)valuePair.method);
        }
        if (binding instanceof JavacAnnotationBinding) {
            JavacAnnotationBinding annotation = (JavacAnnotationBinding)binding;
            return this.getJavacSymbol(annotation.getRecipient());
        }
        if (binding instanceof JavacMethodBinding) {
            JavacMethodBinding method = (JavacMethodBinding)binding;
            return method.methodSymbol;
        }
        if (binding instanceof JavacPackageBinding) {
            JavacPackageBinding packageBinding = (JavacPackageBinding)binding;
            return packageBinding.getPackageSymbol();
        }
        if (binding instanceof JavacTypeBinding) {
            JavacTypeBinding type = (JavacTypeBinding)binding;
            return type.typeSymbol;
        }
        if (binding instanceof JavacVariableBinding) {
            JavacVariableBinding variable = (JavacVariableBinding)binding;
            return variable.variableSymbol;
        }
        return null;
    }

    public ASTNode findNode(Symbol symbol) {
        if (this.symbolToDeclaration != null) {
            return this.symbolToDeclaration.get(symbol);
        }
        return null;
    }

    public ITypeBinding resolveType(Type type) {
        ASTNode alternativesArray;
        JCTree.JCPrimitiveTypeTree primitive;
        ASTNode aSTNode = type.getParent();
        if (aSTNode instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)aSTNode;
            if (type.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
                return this.resolveType((Type)parameterized);
            }
        }
        this.resolve();
        aSTNode = type.getParent();
        if (aSTNode instanceof ArrayCreation) {
            ArrayCreation arrayCreation = (ArrayCreation)aSTNode;
            JCTree jcArrayCreation = this.converter.domToJavac.get(arrayCreation);
            return this.bindings.getTypeBinding(((JCTree.JCNewArray)jcArrayCreation).type);
        }
        JCTree jcTree = this.converter.domToJavac.get(type);
        if (!(jcTree != null && !(jcTree.type instanceof Type.ErrorType) || this.isRecoveringBindings || type.getLocationInParent() == ArrayType.ELEMENT_TYPE_PROPERTY || type instanceof ParameterizedType)) {
            return null;
        }
        if (jcTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)jcTree;
            if (ident.type != null) {
                if (ident.type instanceof Type.PackageType) {
                    return null;
                }
                return this.bindings.getTypeBinding(ident.type);
            }
        }
        if (jcTree instanceof JCTree.JCFieldAccess) {
            ITypeBinding tb;
            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)jcTree;
            IBinding b = this.getFieldAccessBinding(access);
            return b instanceof ITypeBinding ? (tb = (ITypeBinding)b) : null;
        }
        if (jcTree instanceof JCTree.JCPrimitiveTypeTree) {
            primitive = (JCTree.JCPrimitiveTypeTree)jcTree;
            if (primitive.type != null) {
                return this.bindings.getTypeBinding(primitive.type);
            }
        }
        if (jcTree instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jcTree;
            if (arrayType.type != null) {
                if (!arrayType.type.isErroneous()) {
                    return this.bindings.getTypeBinding(arrayType.type);
                }
                if (type instanceof ArrayType) {
                    ArrayType domType = (ArrayType)type;
                    return this.bindings.getRecoveredTypeBinding(arrayType.type, type);
                }
            }
        }
        if (jcTree instanceof JCTree.JCWildcard) {
            JCTree.JCWildcard wcType = (JCTree.JCWildcard)jcTree;
            if (wcType.type != null) {
                return this.bindings.getTypeBinding(wcType.type);
            }
        }
        if (jcTree instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply jcta = (JCTree.JCTypeApply)jcTree;
            if (jcta.type != null) {
                Type.ErrorType errorType;
                JavacTypeBinding res;
                if (!this.isRecoveringBindings) {
                    for (com.sun.tools.javac.code.Type t : jcta.type.getTypeArguments()) {
                        if (!(t instanceof Type.ErrorType)) continue;
                        return null;
                    }
                }
                if ((res = this.bindings.getTypeBinding(jcta.type)) != null) {
                    return res;
                }
                com.sun.tools.javac.code.Type baseType = jcta.getType().type;
                if (baseType instanceof Type.ErrorType && (res = this.bindings.getTypeBinding((errorType = (Type.ErrorType)baseType).getOriginalType(), null, null, true)) != null) {
                    return res;
                }
                if (baseType != null && (res = this.bindings.getTypeBinding(jcta.getType().type)) != null) {
                    return res;
                }
            }
        }
        if (jcTree instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType annotated = (JCTree.JCAnnotatedType)jcTree;
            if (annotated.type != null) {
                return this.bindings.getTypeBinding(annotated.type);
            }
        }
        if (jcTree instanceof JCTree.JCTypeUnion) {
            JCTree.JCTypeUnion unionType = (JCTree.JCTypeUnion)jcTree;
            alternativesArray = new com.sun.tools.javac.code.Type[unionType.alternatives.size()];
            for (int i = 0; i < ((com.sun.tools.javac.code.Type[])alternativesArray).length; ++i) {
                alternativesArray[i] = unionType.alternatives.get((int)i).type;
            }
            return this.bindings.getTypeBinding(unionType.type, (com.sun.tools.javac.code.Type[])alternativesArray, null, false);
        }
        if (jcTree instanceof JCTree.JCTypeIntersection) {
            JCTree.JCTypeIntersection intersectionType = (JCTree.JCTypeIntersection)jcTree;
            alternativesArray = new com.sun.tools.javac.code.Type[intersectionType.bounds.size()];
            for (int i = 0; i < ((com.sun.tools.javac.code.Type[])alternativesArray).length; ++i) {
                alternativesArray[i] = intersectionType.bounds.get((int)i).type;
            }
            return this.bindings.getTypeBinding(intersectionType.type, (com.sun.tools.javac.code.Type[])alternativesArray, null, false);
        }
        if (type instanceof PrimitiveType) {
            primitive = (PrimitiveType)type;
            return this.resolveWellKnownType(primitive.getPrimitiveTypeCode().toString());
        }
        if (type.getAST().apiLevel() >= 10 && type.isVar()) {
            VariableDeclarationStatement statement;
            VariableDeclaration varDecl;
            IVariableBinding varBinding;
            alternativesArray = type.getParent();
            if (alternativesArray instanceof VariableDeclaration && (varBinding = this.resolveVariable(varDecl = (VariableDeclaration)alternativesArray)) != null) {
                return varBinding.getType();
            }
            Object object = type.getParent();
            if (object instanceof VariableDeclarationStatement && (object = this.converter.domToJavac.get(statement = (VariableDeclarationStatement)object)) instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jcDecl = (JCTree.JCVariableDecl)object;
                if (jcDecl.type != null) {
                    return this.bindings.getTypeBinding(jcDecl.type);
                }
            }
        }
        if (this.isRecoveringBindings()) {
            return this.bindings.getRecoveredTypeBinding(jcTree != null ? jcTree.type : null, type);
        }
        return null;
    }

    ITypeBinding resolveType(AnnotationTypeDeclaration type) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type);
            }
        }
        return null;
    }

    ITypeBinding resolveType(RecordDeclaration type) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type);
            }
        }
        return null;
    }

    ITypeBinding resolveType(TypeDeclaration type) {
        JCTree.JCClassDecl jcClassDecl;
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (javacNode.type != null && "<any?>".equals(javacNode.type.toString())) {
                return new JavacErrorTypeBinding(javacNode.type, javacNode.type.tsym, null, true, this, jcClassDecl.sym);
            }
        }
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, null, null, true);
            }
        }
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.sym != null && jcClassDecl.sym.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.sym.type, null, null, true);
            }
        }
        return null;
    }

    ITypeBinding resolveType(EnumDeclaration enumDecl) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(enumDecl);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, null, null, true);
            }
        }
        return null;
    }

    ITypeBinding resolveType(AnonymousClassDeclaration anonymousClassDecl) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(anonymousClassDecl);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, null, null, true);
            }
        }
        return null;
    }

    ITypeBinding resolveTypeParameter(TypeParameter typeParameter) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(typeParameter);
        if (javacNode instanceof JCTree.JCTypeParameter) {
            JCTree.JCTypeParameter jcClassDecl = (JCTree.JCTypeParameter)javacNode;
            return this.bindings.getTypeBinding(jcClassDecl.type);
        }
        return null;
    }

    IVariableBinding resolveField(FieldAccess fieldAccess) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(fieldAccess);
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess javacFieldAccess = (JCTree.JCFieldAccess)javacElement;
            Symbol symbol = javacFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return this.bindings.getVariableBinding(varSymbol);
            }
        }
        return null;
    }

    IVariableBinding resolveField(SuperFieldAccess fieldAccess) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(fieldAccess);
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess javacFieldAccess = (JCTree.JCFieldAccess)javacElement;
            Symbol symbol = javacFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return this.bindings.getVariableBinding(varSymbol);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(MethodInvocation method) {
        AnnoConstruct ownerClass;
        Symbol typeSymbol;
        Symbol sym;
        AnnoConstruct methodSymbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        java.util.List<com.sun.tools.javac.code.Type> typeArgs = null;
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            typeArgs = java.util.List.of();
            javacElement = javacMethodInvocation.getMethodSelect();
            typeArgs = javacMethodInvocation.getTypeArguments().stream().map(jcExpr -> jcExpr.type).toList();
        }
        AnnoConstruct type = javacElement.type;
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            if (type == null) {
                AnnoConstruct classType;
                AbstractTypeDeclaration decl;
                Object object;
                MethodInvocation node;
                for (node = method; node != null && !(node instanceof AbstractTypeDeclaration); node = node.getParent()) {
                }
                if (node instanceof AbstractTypeDeclaration && (object = this.converter.domToJavac.get(decl = (AbstractTypeDeclaration)node)) instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl javacClassDecl = (JCTree.JCClassDecl)object;
                    object = javacClassDecl.type;
                    if (object instanceof Type.ClassType && !((Type.ClassType)(classType = (Type.ClassType)object)).isErroneous()) {
                        type = classType;
                    }
                }
                if (type != null) {
                    classType = type.tsym.members().findFirst(ident.getName(), Symbol.MethodSymbol.class::isInstance);
                    if (classType instanceof Symbol.MethodSymbol) {
                        Type.MethodType methodType;
                        JavacMethodBinding res;
                        methodSymbol = (Symbol.MethodSymbol)classType;
                        classType = methodSymbol.type;
                        if (classType instanceof Type.MethodType && (res = this.bindings.getMethodBinding(methodType = (Type.MethodType)classType, (Symbol.MethodSymbol)methodSymbol, null, false, typeArgs)) != null) {
                            return res;
                        }
                    }
                }
            }
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            v0 = ident.sym;
        } else if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            v0 = fieldAccess.sym;
        } else {
            v0 = sym = null;
        }
        if (type instanceof Type.ErrorType) {
            Type.ErrorType et;
            JCTree.JCFieldAccess fa;
            Type.ErrorType errorType = (Type.ErrorType)type;
            com.sun.tools.javac.code.Type parentType = javacElement instanceof JCTree.JCFieldAccess ? ((fa = (JCTree.JCFieldAccess)javacElement).getExpression() != null ? fa.getExpression().type : null) : null;
            com.sun.tools.javac.code.Type original = errorType;
            while (original instanceof Type.ErrorType && original != (et = original).getOriginalType()) {
                original = et.getOriginalType();
            }
            if (original instanceof ExecutableType) {
                Iterator<Symbol> methods;
                ExecutableType methodType = (ExecutableType)((Object)original);
                Symbol symbol = sym.owner;
                if (symbol instanceof Symbol.TypeSymbol && (methods = (typeSymbol = (Symbol.TypeSymbol)symbol).members().getSymbolsByName(sym.getSimpleName(), m -> methodType.equals(m.type)).iterator()).hasNext()) {
                    ExecutableType executableType;
                    if (methodType instanceof Type.ForAll) {
                        Type.ForAll forAll = (Type.ForAll)methodType;
                        executableType = (ExecutableType)((Object)forAll.qtype);
                    } else {
                        executableType = methodType;
                    }
                    ExecutableType mt2 = executableType;
                    Symbol.MethodSymbol ms = (Symbol.MethodSymbol)methods.next();
                    return this.bindings.getMethodBinding(mt2, ms, parentType, false, typeArgs);
                }
                return this.bindings.getErrorMethodBinding(methodType, sym, typeArgs);
            }
        }
        if (type instanceof ExecutableType) {
            ExecutableType methodType = (ExecutableType)((Object)type);
            if (sym instanceof Symbol.MethodSymbol) {
                methodSymbol = (Symbol.MethodSymbol)sym;
                com.sun.tools.javac.code.Type parentType = null;
                typeSymbol = methodSymbol.owner;
                if (typeSymbol instanceof Symbol.ClassSymbol) {
                    ownerClass = (Symbol.ClassSymbol)typeSymbol;
                    if (JavacBindingResolver.isTypeOfType(ownerClass.type)) {
                        ITypeBinding iTypeBinding;
                        if (ownerClass.type.isParameterized() && method.getExpression() != null && (iTypeBinding = this.resolveExpressionType(method.getExpression())) instanceof JavacTypeBinding) {
                            JavacTypeBinding exprType = (JavacTypeBinding)iTypeBinding;
                            parentType = exprType.type;
                        } else {
                            parentType = ownerClass.type;
                        }
                    }
                }
                return this.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)methodSymbol, parentType, false, typeArgs);
            }
        }
        if (type == null && sym != null && sym.type.isErroneous() && (methodSymbol = sym.owner.type) instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)methodSymbol;
            JavacTypeBinding parentTypeBinding = this.bindings.getTypeBinding(classType);
            return Arrays.stream(parentTypeBinding.getDeclaredMethods()).filter(binding -> binding.getName().equals(sym.getSimpleName().toString())).findAny().orElse(null);
        }
        if (type == null && sym instanceof Symbol.MethodSymbol) {
            Type.ClassType classType;
            JavacTypeBinding parentTypeBinding;
            IMethodBinding res;
            JCTree.JCFieldAccess selectedMethod;
            Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)sym;
            if (methodSymbol2.type instanceof Type.MethodType && javacElement instanceof JCTree.JCFieldAccess && (selectedMethod = (JCTree.JCFieldAccess)javacElement).getExpression() != null && (ownerClass = selectedMethod.getExpression().type) instanceof Type.ClassType && (res = (IMethodBinding)Arrays.stream((parentTypeBinding = this.bindings.getTypeBinding(classType = (Type.ClassType)ownerClass)).getDeclaredMethods()).filter(binding -> {
                if (!(binding instanceof JavacMethodBinding)) return false;
                JavacMethodBinding javacMethodBinding = (JavacMethodBinding)binding;
                if (javacMethodBinding.methodSymbol != methodSymbol2) return false;
                return true;
            }).findAny().orElse(null)) != null) {
                return res;
            }
        }
        if (sym instanceof Symbol.MethodSymbol && sym.type instanceof Type.MethodType) {
            return (IMethodBinding)this.bindings.getBinding(sym, sym.type);
        }
        return null;
    }

    private static com.sun.tools.javac.code.Type applyType(com.sun.tools.javac.code.Type from, Map<Type.TypeVar, com.sun.tools.javac.code.Type> resolutionMapping) {
        if (from instanceof Type.TypeVar) {
            Type.TypeVar typeVar = (Type.TypeVar)from;
            com.sun.tools.javac.code.Type directMapping = resolutionMapping.get(from);
            if (directMapping != null) {
                return directMapping;
            }
            return typeVar;
        }
        if (from instanceof Type.JCNoType || from instanceof Type.JCVoidType || from instanceof Type.JCPrimitiveType) {
            return from;
        }
        if (from instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)from;
            List<com.sun.tools.javac.code.Type> args = ((List)classType.getTypeArguments()).map(typeArg -> JavacBindingResolver.applyType(typeArg, resolutionMapping));
            if (Objects.equals(args, classType.getTypeArguments())) {
                return classType;
            }
            return new Type.ClassType(classType.getEnclosingType(), args, classType.tsym);
        }
        if (from instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)from;
            com.sun.tools.javac.code.Type targetElemType = JavacBindingResolver.applyType(arrayType.elemtype, resolutionMapping);
            if (Objects.equals(targetElemType, arrayType.elemtype)) {
                return arrayType;
            }
            return new Type.ArrayType(targetElemType, arrayType.tsym);
        }
        return from;
    }

    IMethodBinding resolveMethod(MethodDeclaration method) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        if (javacElement instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)javacElement;
            if (!(methodDecl.type instanceof Type.ErrorType)) {
                if (!this.isRecoveringBindings) {
                    boolean methodDeclNameMatchesInit;
                    if (methodDecl.type == null || methodDecl.type instanceof Type.ErrorType) {
                        return null;
                    }
                    if ((methodDecl.restype == null || methodDecl.restype.type instanceof Type.ErrorType) && !(methodDeclNameMatchesInit = Objects.equals(methodDecl.name.toString(), Names.instance((Context)this.context).init.toString()))) {
                        return null;
                    }
                    if (methodDecl.params != null) {
                        for (JCTree.JCVariableDecl jcvd : methodDecl.params) {
                            if (!(jcvd.type instanceof Type.ErrorType)) continue;
                            return null;
                        }
                    }
                }
                if (methodDecl.type != null) {
                    return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(methodDecl.type), methodDecl.sym, null, true, null);
                }
                Symbol.MethodSymbol methodSymbol = methodDecl.sym;
                if (methodSymbol instanceof Symbol.MethodSymbol) {
                    Symbol.MethodSymbol methodSymbol2 = methodSymbol;
                    if (methodSymbol2.type != null) {
                        return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(methodSymbol2.type), methodSymbol2, null, true, null);
                    }
                }
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(LambdaExpression lambda) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(lambda);
        if (javacElement instanceof JCTree.JCLambda) {
            IMethodBinding iMethodBinding;
            JCTree.JCLambda jcLambda = (JCTree.JCLambda)javacElement;
            JavacTypeBinding typeBinding = this.bindings.getTypeBinding(jcLambda.type);
            if (typeBinding != null && (iMethodBinding = typeBinding.getFunctionalInterfaceMethod()) instanceof JavacMethodBinding) {
                JavacMethodBinding methodBinding = (JavacMethodBinding)iMethodBinding;
                return this.bindings.getLambdaBinding(methodBinding, lambda);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(MethodReference methodReference) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(methodReference);
        if (javacElement instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference memberRef = (JCTree.JCMemberReference)javacElement;
            Symbol symbol = memberRef.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                com.sun.tools.javac.code.Type type;
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                java.util.List<com.sun.tools.javac.code.Type> typeArgs = this.streamOfTreeType(memberRef.getTypeArguments());
                if (memberRef.referentType != null && (type = memberRef.referentType) instanceof ExecutableType) {
                    ExecutableType methodType = (ExecutableType)((Object)type);
                    return this.bindings.getMethodBinding(methodType, methodSymbol, null, false, typeArgs);
                }
                type = methodSymbol.type;
                if (type instanceof ExecutableType) {
                    ExecutableType methodType = (ExecutableType)((Object)type);
                    return this.bindings.getMethodBinding(methodType, methodSymbol, null, false, typeArgs);
                }
            }
        }
        return null;
    }

    private java.util.List<com.sun.tools.javac.code.Type> streamOfTreeType(java.util.List<? extends JCTree> items) {
        return items != null ? items.stream().map(x -> x.type).toList() : new ArrayList<com.sun.tools.javac.code.Type>();
    }

    IMethodBinding resolveMember(AnnotationTypeMemberDeclaration member) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(member);
        if (javacElement instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)javacElement;
            java.util.List<com.sun.tools.javac.code.Type> typeArgs = this.streamOfTreeType(methodDecl.getTypeParameters());
            return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(methodDecl.type), methodDecl.sym, null, true, typeArgs);
        }
        return null;
    }

    IMethodBinding resolveConstructor(EnumConstantDeclaration enumConstantDeclaration) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(enumConstantDeclaration);
        if (javacElement instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcvd = (JCTree.JCVariableDecl)javacElement;
            javacElement = jcvd.init;
        }
        if (javacElement instanceof JCTree.JCNewClass) {
            boolean constructorTypeExists;
            JCTree.JCNewClass jcExpr = (JCTree.JCNewClass)javacElement;
            boolean constructorExists = jcExpr != null && jcExpr.constructor != null;
            boolean bl = constructorTypeExists = constructorExists && jcExpr.constructor.type != null;
            if (constructorExists && constructorTypeExists && !jcExpr.constructor.type.isErroneous()) {
                java.util.List<com.sun.tools.javac.code.Type> typeArgs = this.streamOfTreeType(jcExpr.typeargs);
                return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(jcExpr.constructor.type), (Symbol.MethodSymbol)jcExpr.constructor, null, true, typeArgs);
            }
        }
        return null;
    }

    IMethodBinding resolveConstructor(SuperConstructorInvocation expression) {
        Symbol.MethodSymbol methodSymbol;
        Symbol symbol;
        JCTree original;
        this.resolve();
        JCTree javacElement = original = this.converter.domToJavac.get(expression);
        java.util.List<com.sun.tools.javac.code.Type> typeArgs = null;
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            typeArgs = java.util.List.of();
            javacElement = javacMethodInvocation.getMethodSelect();
            typeArgs = javacMethodInvocation.getTypeArguments().stream().map(jcExpr -> jcExpr.type).toList();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                TypeMirror typeMirror;
                methodSymbol = (Symbol.MethodSymbol)symbol;
                if (ident.type != null && (typeMirror = ident.type) instanceof ExecutableType) {
                    ExecutableType methodType = (ExecutableType)typeMirror;
                    return this.bindings.getMethodBinding(methodType, methodSymbol, null, false, typeArgs);
                }
                typeMirror = methodSymbol.asType();
                if (typeMirror instanceof ExecutableType) {
                    ExecutableType methodType = (ExecutableType)typeMirror;
                    return this.bindings.getMethodBinding(methodType, methodSymbol, null, false, typeArgs);
                }
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(fieldAccess.type), methodSymbol, null, false, typeArgs);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(SuperMethodInvocation method) {
        Symbol symbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(ident.type), methodSymbol, null, false, null);
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                if (fieldAccess.type != null) {
                    return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(fieldAccess.type), methodSymbol, null, false, null);
                }
            }
        }
        return null;
    }

    IBinding resolveCached(ASTNode node, Function<ASTNode, IBinding> l) {
        this.resolve();
        IBinding res = this.resolvedBindingsCache.get(node);
        if (res == null) {
            res = l.apply(node);
            this.resolvedBindingsCache.put(node, res);
        }
        return res;
    }

    IBinding resolveName(Name name) {
        return this.resolveCached((ASTNode)name, n -> this.resolveNameImpl((Name)n));
    }

    private IBinding resolveNameImpl(Name name) {
        VariableDeclaration decl;
        ExpressionMethodReference methodRef;
        MethodDeclaration methodDeclaration;
        MethodInvocation methodInvocation;
        MethodRef mref;
        QualifiedName parentName;
        ImportDeclaration importDecl;
        IBinding ret;
        DocTreePath path;
        Element b;
        ITypeBinding typeBinding;
        ITypeBinding typeBinding2;
        ASTNode simpleType;
        QualifiedName qname;
        ASTNode aSTNode;
        this.resolve();
        ASTNode aSTNode2 = name.getParent();
        if (aSTNode2 instanceof MemberRef) {
            MemberRef memberRef = (MemberRef)aSTNode2;
            this.resolveReference(memberRef);
        }
        if ((aSTNode2 = name.getParent()) instanceof MethodRef) {
            MethodRef methodRef2 = (MethodRef)aSTNode2;
            this.resolveReference(methodRef2);
        }
        ASTNode parent = name.getParent();
        if (name.getLocationInParent() == QualifiedName.NAME_PROPERTY && parent instanceof QualifiedName && (aSTNode = (qname = (QualifiedName)parent).getParent()) instanceof SimpleType && (simpleType = (SimpleType)aSTNode).getLocationInParent() == ParameterizedType.TYPE_PROPERTY && (typeBinding2 = this.resolveType((Type)((ParameterizedType)simpleType.getParent()))) != null) {
            return typeBinding2;
        }
        if (name.getLocationInParent() == QualifiedType.NAME_PROPERTY && parent.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
            ITypeBinding typeBinding3 = this.resolveType((Type)((QualifiedType)parent));
            return typeBinding3.getTypeDeclaration();
        }
        if ((name.getLocationInParent() == SimpleType.NAME_PROPERTY || name.getLocationInParent() == QualifiedType.NAME_PROPERTY || name.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) && (simpleType = name.getParent()) instanceof Type) {
            ParameterizedType parameterized;
            ASTNode aSTNode3;
            Type type = (Type)simpleType;
            typeBinding = this.resolveType(type);
            boolean complexTypeChain = type.getLocationInParent() == ParameterizedType.TYPE_PROPERTY && (aSTNode3 = type.getParent()) instanceof ParameterizedType && (parameterized = (ParameterizedType)aSTNode3).getParent() instanceof Type;
            return complexTypeChain ? typeBinding.getErasure() : typeBinding;
        }
        if (name.getLocationInParent() == MethodInvocation.NAME_PROPERTY && (typeBinding = name.getParent()) instanceof MethodInvocation) {
            MethodInvocation method = (MethodInvocation)typeBinding;
            return this.resolveMethod(method);
        }
        JCTree tree = this.converter.domToJavac.get(name);
        if (tree != null) {
            IBinding res = this.resolveNameToJavac(name, tree);
            if (res instanceof JavacPackageBinding && Character.isUpperCase(name.getFullyQualifiedName().charAt(0))) {
                if (name.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                    name = (QualifiedName)name.getParent();
                }
                Name possibleTypeParentName = name;
                while (possibleTypeParentName.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
                    possibleTypeParentName = (QualifiedName)possibleTypeParentName.getParent();
                }
                if (possibleTypeParentName != name && ((b = possibleTypeParentName.resolveBinding()) == null || b.isRecovered())) {
                    return this.bindings.getRecoveredTypeBinding(tree.type, name);
                }
            }
            if (res != null) {
                return res;
            }
        }
        if ((path = this.converter.findDocTreePath((ASTNode)name)) != null && (b = JavacTrees.instance(this.context).getElement(path)) instanceof Symbol) {
            Symbol symbol = (Symbol)b;
            return this.bindings.getBinding(symbol, null);
        }
        Symbol.PackageSymbol ps = this.findPackageSymbol(name);
        if (ps != null && ps.exists()) {
            return this.bindings.getPackageBinding(ps);
        }
        if (this.isPackageName(name)) {
            return this.bindings.getPackageBinding(name);
        }
        if (tree instanceof JCTree.JCIdent) {
            JavacPackageBinding b2;
            JCTree.JCIdent jcid = (JCTree.JCIdent)tree;
            if (jcid.sym instanceof Symbol.ClassSymbol && jcid.type instanceof Type.ErrorType && (b2 = this.bindings.findExistingPackageBinding(name)) != null) {
                return b2;
            }
        }
        if (tree == null && (name.getFlags() & 2) != 0 && (tree = this.converter.domToJavac.get(parent)) instanceof JCTree.JCFieldAccess) {
            ParameterizedType parameterized;
            ITypeBinding parameterizedType;
            ASTNode grandParent;
            JCTree.JCIdent jcid;
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
            JCTree.JCExpression jCExpression = jcfa.selected;
            if (jCExpression instanceof JCTree.JCIdent && (jcid = (JCTree.JCIdent)jCExpression).toString().equals(name.toString())) {
                tree = jcfa.selected;
            }
            if ((grandParent = parent.getParent()) instanceof ParameterizedType && (parameterizedType = this.resolveType((Type)(parameterized = (ParameterizedType)grandParent))) != null) {
                return parameterizedType;
            }
        }
        if (tree != null && (ret = this.resolveNameToJavac(name, tree)) != null) {
            return ret;
        }
        if (parent instanceof ImportDeclaration && (importDecl = (ImportDeclaration)parent).getName() == name) {
            return this.resolveImport(importDecl);
        }
        if (parent instanceof QualifiedName && (parentName = (QualifiedName)parent).getName() == name) {
            return this.resolveNameImpl((Name)parentName);
        }
        if (parent instanceof MethodRef && (mref = (MethodRef)parent).getName() == name) {
            return this.resolveReference(mref);
        }
        if (parent instanceof MemberRef && (mref = (MemberRef)parent).getName() == name) {
            return this.resolveReference((MemberRef)mref);
        }
        if (parent instanceof MethodInvocation && (methodInvocation = (MethodInvocation)parent).getName() == name) {
            return this.resolveMethod(methodInvocation);
        }
        if (parent instanceof MethodDeclaration && (methodDeclaration = (MethodDeclaration)parent).getName() == name) {
            return this.resolveMethod(methodDeclaration);
        }
        if (parent instanceof ExpressionMethodReference && (methodRef = (ExpressionMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof TypeMethodReference && (methodRef = (TypeMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof SuperMethodReference && (methodRef = (SuperMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof VariableDeclaration && (decl = (VariableDeclaration)parent).getName() == name) {
            return this.resolveVariable(decl);
        }
        return null;
    }

    private boolean isPackageName(Name name) {
        Name working = name;
        boolean insideQualifier = false;
        while (working instanceof Name) {
            QualifiedName qnn;
            JCTree tree = this.converter.domToJavac.get(working);
            if (tree instanceof JCTree.JCFieldAccess) {
                Symbol.PackageSymbol psym;
                JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
                Symbol symbol = jcfa.sym;
                return symbol instanceof Symbol.PackageSymbol && (psym = (Symbol.PackageSymbol)symbol).exists();
            }
            if (working instanceof QualifiedName && (qnn = (QualifiedName)working).getQualifier() == working) {
                insideQualifier = true;
            }
            working = working.getParent();
        }
        return insideQualifier;
    }

    private Symbol.PackageSymbol findPackageSymbol(Name name) {
        QualifiedName qn;
        JCTree tree;
        SimpleName sn;
        ASTNode parent;
        if (name instanceof SimpleName && (parent = (sn = (SimpleName)name).getParent()) instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)parent;
            JCTree tree2 = this.converter.domToJavac.get(parent);
            if (tree2 instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree2;
                if (qn2.getQualifier().equals((Object)name)) {
                    Object object = jcfa.selected;
                    if (object instanceof JCTree.JCIdent) {
                        JCTree.JCIdent jcid = (JCTree.JCIdent)object;
                        object = jcid.sym;
                        if (object instanceof Symbol.PackageSymbol) {
                            Symbol.PackageSymbol pss = (Symbol.PackageSymbol)object;
                            return pss;
                        }
                    }
                } else if (qn2.getName().equals((Object)name)) {
                    Symbol.PackageSymbol pss;
                    Symbol symbol = jcfa.sym;
                    return symbol instanceof Symbol.PackageSymbol ? (pss = (Symbol.PackageSymbol)symbol) : null;
                }
            }
        }
        if (name instanceof QualifiedName && (tree = this.converter.domToJavac.get(qn = (QualifiedName)name)) instanceof JCTree.JCFieldAccess) {
            Symbol.PackageSymbol pss;
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
            Symbol symbol = jcfa.sym;
            return symbol instanceof Symbol.PackageSymbol ? (pss = (Symbol.PackageSymbol)symbol) : null;
        }
        return null;
    }

    IBinding resolveNameToJavac(Name name, JCTree tree) {
        JCTree.JCIdent jcid;
        JCTree variableDecl;
        Object b;
        ParameterizedType pt;
        AnnotatableType st;
        SimpleType type;
        AbstractTypeDeclaration typeDeclaration;
        ASTNode aSTNode = name.getParent();
        boolean isTypeDeclaration = aSTNode instanceof AbstractTypeDeclaration && (typeDeclaration = (AbstractTypeDeclaration)aSTNode).getName() == name || (aSTNode = name.getParent()) instanceof SimpleType && (type = (SimpleType)aSTNode).getName() == name;
        aSTNode = name.getParent();
        if (aSTNode instanceof AnnotatableType && (aSTNode = (st = (AnnotatableType)aSTNode).getParent()) instanceof ParameterizedType && st == (pt = (ParameterizedType)aSTNode).getType()) {
            tree = this.converter.domToJavac.get(pt);
            if (tree.type != null && !tree.type.isErroneous() && (b = this.bindings.getTypeBinding(tree.type, null, null, isTypeDeclaration)) != null) {
                return b;
            }
        }
        if (tree instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)tree;
            if (ident.sym != null) {
                Type.ErrorType errorType;
                b = ident.type;
                if (b instanceof Type.ErrorType && (errorType = (Type.ErrorType)b).getOriginalType() instanceof Type.ErrorType && !this.isRecoveringBindings()) {
                    return null;
                }
                if (isTypeDeclaration) {
                    return this.bindings.getTypeBinding(ident.type != null ? ident.type : ident.sym.type, null, null, true);
                }
                return this.bindings.getBinding(ident.sym, ident.type != null ? ident.type : ident.sym.type);
            }
        }
        if (tree instanceof JCTree.JCTypeApply) {
            variableDecl = (JCTree.JCTypeApply)tree;
            if (variableDecl.type != null) {
                return this.bindings.getTypeBinding(variableDecl.type);
            }
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)tree;
            IBinding b2 = this.getFieldAccessBinding(fieldAccess);
            if (b2 != null) {
                return b2;
            }
            JCTree.JCExpression jCExpression = fieldAccess.selected;
            if (jCExpression instanceof JCTree.JCIdent) {
                jcid = (JCTree.JCIdent)jCExpression;
                if (jcid.sym == null && jcid.type == null) {
                    IBinding bind = this.searchForFieldAccessBindingViaTopLevelType(jcid, name);
                    if (bind != null) {
                        return bind;
                    }
                    bind = this.searchForFieldAccessBindingViaFieldsInCurrentType(jcid, name);
                    if (bind != null) {
                        return bind;
                    }
                }
            }
            return null;
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
            if (methodInvocation.meth.type != null) {
                return this.bindings.getBinding(((JCTree.JCFieldAccess)methodInvocation.meth).sym, methodInvocation.meth.type);
            }
        }
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            if (classDecl.sym != null) {
                return this.bindings.getBinding(classDecl.sym, classDecl.type);
            }
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)tree;
            if (methodDecl.sym != null) {
                return this.bindings.getBinding(methodDecl.sym, methodDecl.type);
            }
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            variableDecl = (JCTree.JCVariableDecl)tree;
            if (((JCTree.JCVariableDecl)variableDecl).sym != null) {
                return this.bindings.getBinding(((JCTree.JCVariableDecl)variableDecl).sym, ((JCTree.JCVariableDecl)variableDecl).type);
            }
        }
        if (tree instanceof JCTree.JCTypeParameter) {
            variableDecl = (JCTree.JCTypeParameter)tree;
            if (((JCTree.JCTypeParameter)variableDecl).type != null && ((JCTree.JCTypeParameter)variableDecl).type.tsym != null) {
                return this.bindings.getBinding(((JCTree.JCTypeParameter)variableDecl).type.tsym, ((JCTree.JCTypeParameter)variableDecl).type);
            }
        }
        if (tree instanceof JCTree.JCModuleDecl) {
            variableDecl = (JCTree.JCModuleDecl)tree;
            if (((JCTree.JCModuleDecl)variableDecl).sym != null && ((JCTree.JCModuleDecl)variableDecl).sym.type instanceof Type.ModuleType) {
                return this.bindings.getModuleBinding((JCTree.JCModuleDecl)variableDecl);
            }
        }
        if ((jcid = name.getParent()) instanceof Name) {
            Name parentName = (Name)jcid;
            if (tree instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)tree;
                if (ident.sym == null) {
                    tree = this.converter.domToJavac.get(parentName);
                    IBinding b3 = this.resolveNameToJavac(parentName, tree);
                    return b3;
                }
            }
        }
        return null;
    }

    private IBinding searchForFieldAccessBindingViaTopLevelType(JCTree.JCIdent jcid, Name name) {
        Name working;
        CompilationUnit cu = null;
        for (working = name; working != null && !(working instanceof CompilationUnit); working = working.getParent()) {
        }
        if (working != null) {
            cu = (CompilationUnit)working;
            java.util.List types = cu.types();
            for (AbstractTypeDeclaration t1 : types) {
                IVariableBinding[] fields;
                ITypeBinding t1Binding;
                if (!t1.getName().toString().equals(jcid.getName().toString()) || (t1Binding = t1.resolveBinding()) == null || !(t1Binding instanceof ITypeBinding)) continue;
                ITypeBinding t2 = t1Binding;
                for (IVariableBinding vb1 : fields = t2.getDeclaredFields()) {
                    if (!vb1.getName().toString().equals(name.toString())) continue;
                    return vb1;
                }
            }
        }
        return null;
    }

    private IBinding searchForFieldAccessBindingViaFieldsInCurrentType(JCTree.JCIdent jcid, Name name) {
        Name working;
        String soughtName;
        if (name instanceof SimpleName) {
            SimpleName sn = (SimpleName)name;
            v0 = sn.toString();
        } else if (name instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)name;
            v0 = qn.getName().toString();
        } else {
            v0 = soughtName = null;
        }
        if (soughtName == null) {
            return null;
        }
        AbstractTypeDeclaration type = null;
        for (working = name; working != null && !(working instanceof AbstractTypeDeclaration); working = working.getParent()) {
        }
        if (working != null) {
            type = (AbstractTypeDeclaration)working;
            java.util.List<Object> fields = type.bodyDeclarations().stream().filter(x -> x instanceof FieldDeclaration).toList();
            for (FieldDeclaration fieldDeclaration : fields) {
                Optional<Object> frags = fieldDeclaration.fragments().stream().filter(x -> ((VariableDeclarationFragment)x).getName().toString().equals(jcid.getName().toString())).findFirst();
                if (!frags.isPresent()) continue;
                VariableDeclarationFragment frag = (VariableDeclarationFragment)frags.get();
                ITypeBinding t1Binding = fieldDeclaration.getType().resolveBinding();
                if (t1Binding != null && t1Binding instanceof ITypeBinding) {
                    IVariableBinding[] referencedTypeFields;
                    ITypeBinding t2 = t1Binding;
                    for (IVariableBinding vb1 : referencedTypeFields = t2.getDeclaredFields()) {
                        if (!vb1.getName().toString().equals(soughtName)) continue;
                        return vb1;
                    }
                }
                System.out.println("Break");
            }
        }
        return null;
    }

    IVariableBinding resolveVariable(EnumConstantDeclaration enumConstant) {
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(enumConstant);
        if (jCTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)jCTree;
            if (decl.type != null && !decl.type.isErroneous() || this.isRecoveringBindings()) {
                return this.bindings.getVariableBinding(decl.sym);
            }
        }
        return null;
    }

    IVariableBinding resolveVariable(VariableDeclaration variable) {
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(variable);
        if (jCTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)jCTree;
            com.sun.tools.javac.code.Type t1 = decl.type;
            if (t1 == null && decl.vartype != null) {
                t1 = decl.vartype.type;
            }
            if ((t1 != null && !t1.isErroneous() || this.isRecoveringBindings()) && decl.name != Names.instance((Context)this.context).error) {
                return this.bindings.getVariableBinding(decl.sym);
            }
        }
        return null;
    }

    public IPackageBinding resolvePackage(PackageDeclaration decl) {
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(decl);
        if (jCTree instanceof JCTree.JCPackageDecl) {
            JCTree.JCPackageDecl jcPackageDecl = (JCTree.JCPackageDecl)jCTree;
            return this.bindings.getPackageBinding(jcPackageDecl.packge);
        }
        return null;
    }

    private Symbol findBackupOwner(JCTree tree) {
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation jcmi = (JCTree.JCMethodInvocation)tree;
            return this.findActualOwner(jcmi.meth);
        }
        return null;
    }

    private Symbol findActualOwner(JCTree.JCExpression e) {
        if (e instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)e;
            if (jcfa.sym != null) {
                return jcfa.sym.owner;
            }
        }
        return null;
    }

    public ITypeBinding resolveExpressionType(Expression expr) {
        JCTree.JCTypeCast jcCast;
        this.resolve();
        if (expr instanceof SimpleName) {
            SimpleName name = (SimpleName)expr;
            IBinding binding = this.resolveName((Name)name);
            if (binding == null || binding.isRecovered() && !this.isRecoveringBindings()) {
                return null;
            }
            IBinding iBinding = binding;
            Objects.requireNonNull(iBinding);
            IBinding iBinding2 = iBinding;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVariableBinding.class, ITypeBinding.class, IMethodBinding.class}, (IBinding)iBinding2, n)) {
                case 0: {
                    IVariableBinding variableBinding = (IVariableBinding)iBinding2;
                    return variableBinding.getType();
                }
                case 1: {
                    ITypeBinding typeBinding = (ITypeBinding)iBinding2;
                    return typeBinding;
                }
                case 2: {
                    IMethodBinding methodBinding = (IMethodBinding)iBinding2;
                    return methodBinding.getReturnType();
                }
            }
            return null;
        }
        JCTree jcTree = this.converter.domToJavac.get(expr);
        if (jcTree instanceof JCTree.JCExpression) {
            JavacTypeBinding res;
            JCTree.JCExpression expression = (JCTree.JCExpression)jcTree;
            if (JavacBindingResolver.isTypeOfType(expression.type) && !expression.type.isErroneous() && (res = this.bindings.getTypeBinding(expression.type.baseType(), null, this.findBackupOwner(expression), false)) != null) {
                return res;
            }
        }
        if (jcTree instanceof JCTree.JCMethodInvocation) {
            Type.ErrorType errorType;
            com.sun.tools.javac.code.Type type;
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)jcTree;
            com.sun.tools.javac.code.Type variableBinding = javacMethodInvocation.meth.type;
            if (variableBinding instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)variableBinding;
                return this.bindings.getTypeBinding(methodType.getReturnType());
            }
            variableBinding = javacMethodInvocation.meth.type;
            if (variableBinding instanceof Type.ErrorType && (type = (errorType = (Type.ErrorType)variableBinding).getOriginalType()) instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)type;
                return this.bindings.getTypeBinding(methodType.getReturnType());
            }
            return null;
        }
        if (jcTree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)jcTree;
            if (newClass.type != null && Symtab.instance((Context)this.context).errSymbol == newClass.type.tsym) {
                if (newClass.encl != null) {
                    String string;
                    JCTree.JCExpression methodType = newClass.clazz;
                    if (methodType instanceof JCTree.JCTypeApply) {
                        JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)methodType;
                        string = typeApply.clazz.toString();
                    } else {
                        string = newClass.clazz.toString();
                    }
                    String className = string;
                    ITypeBinding enclosingTypeBinding = this.resolveExpressionType(((ClassInstanceCreation)expr).getExpression());
                    java.util.List<ITypeBinding> potentialTypes = Stream.of(enclosingTypeBinding.getDeclaredTypes()).filter(innerType -> {
                        String cleanedName = innerType.getName();
                        if (cleanedName.endsWith(">")) {
                            cleanedName = cleanedName.substring(0, cleanedName.lastIndexOf("<"));
                        }
                        return className.equals(cleanedName);
                    }).toList();
                    if (!potentialTypes.isEmpty()) {
                        return potentialTypes.get(0);
                    }
                }
                jcTree = newClass.getIdentifier();
            }
        }
        if (jcTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)jcTree;
            if (jcFieldAccess.type instanceof Type.PackageType) {
                return null;
            }
            if (expr instanceof SuperFieldAccess) {
                return this.bindings.getTypeBinding(jcFieldAccess.selected.type);
            }
            if (jcFieldAccess.type != null && !jcFieldAccess.type.isErroneous()) {
                return this.bindings.getTypeBinding(jcFieldAccess.type);
            }
            if (jcFieldAccess.sym != null) {
                return this.bindings.getTypeBinding(jcFieldAccess.sym.type);
            }
        }
        if (jcTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)jcTree;
            if (jcVariableDecl.type != null) {
                return this.bindings.getTypeBinding(jcVariableDecl.type);
            }
            return null;
        }
        if (jcTree instanceof JCTree.JCTypeCast && (jcCast = (JCTree.JCTypeCast)jcTree).getType() != null) {
            return this.bindings.getTypeBinding(jcCast.getType().type);
        }
        if (jcTree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral jcLiteral = (JCTree.JCLiteral)jcTree;
            if (jcLiteral.type != null && jcLiteral.type.isErroneous()) {
                if (jcLiteral.typetag == TypeTag.CLASS) {
                    return this.resolveWellKnownType("java.lang.String");
                }
                if (jcLiteral.typetag == TypeTag.BOT) {
                    return this.bindings.getTypeBinding(Symtab.instance((Context)this.context).botType);
                }
                return this.resolveWellKnownType(jcLiteral.typetag.name().toLowerCase());
            }
        }
        if (jcTree instanceof JCTree.JCExpression) {
            JavacTypeBinding res;
            JCTree.JCExpression jcExpr = (JCTree.JCExpression)jcTree;
            if (jcExpr.type instanceof Type.PackageType) {
                return null;
            }
            Symbol recoveredSymbol = JavacBindingResolver.getRecoveredSymbol(jcExpr.type);
            if (recoveredSymbol != null) {
                IBinding recoveredBinding;
                IBinding iBinding = recoveredBinding = this.bindings.getBinding(recoveredSymbol, recoveredSymbol.type);
                Objects.requireNonNull(iBinding);
                IBinding iBinding3 = iBinding;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVariableBinding.class, ITypeBinding.class, IMethodBinding.class}, (IBinding)iBinding3, n)) {
                    case 0 -> {
                        IVariableBinding variableBinding = (IVariableBinding)iBinding3;
                        yield variableBinding.getType();
                    }
                    case 1 -> {
                        ITypeBinding typeBinding;
                        yield typeBinding = (ITypeBinding)iBinding3;
                    }
                    case 2 -> {
                        IMethodBinding methodBinding = (IMethodBinding)iBinding3;
                        yield methodBinding.getReturnType();
                    }
                    default -> null;
                };
            }
            if (jcExpr.type != null && (res = this.bindings.getTypeBinding(jcExpr.type)) != null) {
                return res;
            }
            if (expr instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expr;
                return classInstanceCreation.getType().resolveBinding();
            }
        }
        return null;
    }

    IMethodBinding resolveConstructor(ClassInstanceCreation expression) {
        return (IMethodBinding)this.resolveCached((ASTNode)expression, n -> this.resolveConstructorImpl((ClassInstanceCreation)n));
    }

    public static boolean isTypeOfType(com.sun.tools.javac.code.Type t) {
        boolean bl;
        if (t == null) {
            bl = false;
        } else {
            switch (t.getKind()) {
                case PACKAGE: 
                case MODULE: 
                case EXECUTABLE: 
                case OTHER: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private IMethodBinding resolveConstructorImpl(ClassInstanceCreation expression) {
        ITypeBinding type;
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(expression);
        if (jCTree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass jcExpr = (JCTree.JCNewClass)jCTree;
            if (jcExpr.constructor != null) {
                java.util.List<com.sun.tools.javac.code.Type> javacTypeArgs;
                if (!jcExpr.constructorType.isErroneous()) {
                    javacTypeArgs = jcExpr.getTypeArguments().stream().map(jc -> jc.type).toList();
                    return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(jcExpr.constructorType), (Symbol.MethodSymbol)jcExpr.constructor, jcExpr.type, false, javacTypeArgs);
                }
                if (jcExpr.constructor.type != null && !jcExpr.constructor.type.isErroneous()) {
                    javacTypeArgs = jcExpr.getTypeArguments().stream().map(jc -> jc.type).toList();
                    return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(jcExpr.constructor.type), (Symbol.MethodSymbol)jcExpr.constructor, jcExpr.type, false, javacTypeArgs);
                }
            }
        }
        if ((type = this.resolveType(expression.getType())) != null) {
            boolean hasTrailingNull;
            java.util.List<ITypeBinding> givenTypes = expression.arguments().stream().map(this::resolveExpressionType).toList();
            boolean matchExactParamCount = false;
            do {
                java.util.List<IMethodBinding> typeFilteredCandidates;
                hasTrailingNull = !givenTypes.isEmpty() && givenTypes.getLast() == null;
                boolean matchExactParamCountFinal = matchExactParamCount;
                java.util.List<ITypeBinding> finalGivenTypes = givenTypes;
                java.util.List<IMethodBinding> candidates = Arrays.stream(type.getDeclaredMethods()).filter(IMethodBinding::isConstructor).filter(other -> matchExactParamCountFinal ? other.getParameterTypes().length == finalGivenTypes.size() : other.getParameterTypes().length >= finalGivenTypes.size()).toList();
                if (candidates.size() == 1) {
                    return candidates.get(0);
                }
                if (candidates.size() > 1 && expression.arguments().size() > 0 && (typeFilteredCandidates = candidates.stream().filter(other -> this.matchTypes(finalGivenTypes, other.getParameterTypes())).toList()).size() == 1) {
                    return typeFilteredCandidates.get(0);
                }
                if (!hasTrailingNull) continue;
                givenTypes = givenTypes.subList(0, givenTypes.size() - 1);
                matchExactParamCount = true;
            } while (hasTrailingNull);
        }
        return null;
    }

    private boolean matchTypes(java.util.List<ITypeBinding> givenTypes, ITypeBinding[] expectedTypes) {
        for (int i = 0; i < Math.min(givenTypes.size(), expectedTypes.length); ++i) {
            ITypeBinding givenType = givenTypes.get(i);
            ITypeBinding expectedType = expectedTypes[i];
            if (givenType == null || givenType.isAssignmentCompatible(expectedType)) continue;
            return false;
        }
        return true;
    }

    IMethodBinding resolveConstructor(ConstructorInvocation invocation) {
        return (IMethodBinding)this.resolveCached((ASTNode)invocation, n -> this.resolveConstructorImpl((ConstructorInvocation)n));
    }

    private IMethodBinding resolveConstructorImpl(ConstructorInvocation invocation) {
        Symbol symbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(invocation);
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                ExecutableType mt = JavacBindingResolver.asExecutable(ident.type != null && ident.type.getKind() == TypeKind.EXECUTABLE ? ident.type : methodSymbol.type);
                return this.bindings.getMethodBinding(mt, methodSymbol, null, false, null);
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(JavacBindingResolver.asExecutable(fieldAccess.type), methodSymbol, null, false, null);
            }
        }
        return null;
    }

    public Types getTypes() {
        return Types.instance(this.context);
    }

    IModuleBinding resolveModule(ModuleDeclaration module) {
        return (IModuleBinding)this.resolveCached((ASTNode)module, n -> this.resolveModuleImpl((ModuleDeclaration)n));
    }

    private IBinding resolveModuleImpl(ModuleDeclaration module) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(module);
        if (javacElement instanceof JCTree.JCModuleDecl) {
            com.sun.tools.javac.code.Type type;
            JCTree.JCModuleDecl jcmd = (JCTree.JCModuleDecl)javacElement;
            if (jcmd.sym != null && (type = jcmd.sym.type) instanceof Type.ModuleType) {
                Type.ModuleType mt = (Type.ModuleType)type;
                return this.bindings.getModuleBinding(mt);
            }
        }
        return null;
    }

    public Object getValueFromAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof Attribute.Constant) {
            Attribute.Constant constant = (Attribute.Constant)attribute;
            return constant.value;
        }
        if (attribute instanceof Attribute.Class) {
            Attribute.Class clazz = (Attribute.Class)attribute;
            return this.bindings.getTypeBinding(clazz.classType);
        }
        if (attribute instanceof Attribute.Enum) {
            Attribute.Enum enumm = (Attribute.Enum)attribute;
            return this.bindings.getVariableBinding(enumm.value);
        }
        if (attribute instanceof Attribute.Array) {
            Attribute.Array array = (Attribute.Array)attribute;
            return Stream.of(array.values).map(nestedAttr -> {
                if (nestedAttr instanceof Attribute.Constant) {
                    Attribute.Constant constant = (Attribute.Constant)nestedAttr;
                    return constant.value;
                }
                if (nestedAttr instanceof Attribute.Class) {
                    Attribute.Class clazz = (Attribute.Class)nestedAttr;
                    return this.bindings.getTypeBinding(clazz.classType);
                }
                if (nestedAttr instanceof Attribute.Enum) {
                    Attribute.Enum enumerable = (Attribute.Enum)nestedAttr;
                    return this.bindings.getVariableBinding(enumerable.value);
                }
                throw new IllegalArgumentException("Unexpected attribute type: " + nestedAttr.getClass().getCanonicalName());
            }).toArray(Object[]::new);
        }
        if (attribute instanceof Attribute.Error) {
            return null;
        }
        throw new IllegalArgumentException("Unexpected attribute type: " + attribute.getClass().getCanonicalName());
    }

    IBinding resolveImport(ImportDeclaration importDeclaration) {
        return this.resolveCached((ASTNode)importDeclaration, n -> this.resolveImportImpl((ImportDeclaration)n));
    }

    private IBinding resolveImportImpl(ImportDeclaration importDeclaration) {
        JCTree javac = this.converter.domToJavac.get(importDeclaration.getName());
        if (javac instanceof JCTree.JCFieldAccess) {
            JavacTypeBinding typeBinding;
            com.sun.tools.javac.code.Type type;
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javac;
            if (fieldAccess.sym != null) {
                return this.bindings.getBinding(fieldAccess.sym, null);
            }
            if (importDeclaration.isStatic() && (type = fieldAccess.getExpression().type) != null && (typeBinding = this.bindings.getTypeBinding(type)) != null) {
                IBinding binding = Arrays.stream(typeBinding.getDeclaredMethods()).filter(method -> Objects.equals(fieldAccess.getIdentifier().toString(), method.getName())).findAny().orElse(null);
                if (binding == null) {
                    binding = Arrays.stream(typeBinding.getDeclaredFields()).filter(field -> Objects.equals(fieldAccess.getIdentifier().toString(), field.getName())).findAny().orElse(null);
                }
                return binding;
            }
            if (Modifier.isModule((int)importDeclaration.getModifiers())) {
                Optional<JavacModuleBinding> maybeModuleBinding = Modules.instance(this.context).allModules().stream().filter(moduleSym -> Objects.equals(moduleSym.name.toString(), importDeclaration.getName().getFullyQualifiedName())).map(this.bindings::getModuleBinding).filter(Objects::nonNull).findFirst();
                if (maybeModuleBinding.isPresent()) {
                    return maybeModuleBinding.orElse(null);
                }
            }
        }
        return null;
    }

    public ITypeBinding resolveWellKnownType(String typeName) {
        return this.resolveTypeFromContext(typeName, true);
    }

    public ITypeBinding resolveTypeFromContext(String typeName) {
        return this.resolveTypeFromContext(typeName, false);
    }

    public ITypeBinding resolveTypeFromContext(String typeName, boolean wellKnownOnly) {
        com.sun.tools.javac.code.Type type;
        this.resolve();
        Symtab symtab = Symtab.instance(this.context);
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                com.sun.tools.javac.code.Type type2 = symtab.byteType;
                break;
            }
            case "char": 
            case "java.lang.Character": {
                com.sun.tools.javac.code.Type type2 = symtab.charType;
                break;
            }
            case "double": 
            case "java.lang.Double": {
                com.sun.tools.javac.code.Type type2 = symtab.doubleType;
                break;
            }
            case "float": 
            case "java.lang.Float": {
                com.sun.tools.javac.code.Type type2 = symtab.floatType;
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                com.sun.tools.javac.code.Type type2 = symtab.intType;
                break;
            }
            case "long": 
            case "java.lang.Long": {
                com.sun.tools.javac.code.Type type2 = symtab.longType;
                break;
            }
            case "short": 
            case "java.lang.Short": {
                com.sun.tools.javac.code.Type type2 = symtab.shortType;
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                com.sun.tools.javac.code.Type type2 = symtab.booleanType;
                break;
            }
            case "void": 
            case "java.lang.Void": {
                com.sun.tools.javac.code.Type type2 = symtab.voidType;
                break;
            }
            case "java.lang.Object": {
                com.sun.tools.javac.code.Type type2 = symtab.objectType;
                break;
            }
            case "java.lang.String": {
                com.sun.tools.javac.code.Type type2 = symtab.stringType;
                break;
            }
            case "java.lang.StringBuffer": {
                com.sun.tools.javac.code.Type type2 = symtab.stringBufferType;
                break;
            }
            case "java.lang.Throwable": {
                com.sun.tools.javac.code.Type type2 = symtab.throwableType;
                break;
            }
            case "java.lang.Exception": {
                com.sun.tools.javac.code.Type type2 = symtab.exceptionType;
                break;
            }
            case "java.lang.RuntimeException": {
                com.sun.tools.javac.code.Type type2 = symtab.runtimeExceptionType;
                break;
            }
            case "java.lang.Error": {
                com.sun.tools.javac.code.Type type2 = symtab.errorType;
                break;
            }
            case "java.lang.Class": {
                com.sun.tools.javac.code.Type type2 = symtab.classType;
                break;
            }
            case "java.lang.Cloneable": {
                com.sun.tools.javac.code.Type type2 = symtab.cloneableType;
                break;
            }
            case "java.io.Serializable": {
                com.sun.tools.javac.code.Type type2 = symtab.serializableType;
                break;
            }
            case "java.lang.AssertionError": {
                com.sun.tools.javac.code.Type type2 = symtab.assertionErrorType;
                break;
            }
            default: {
                com.sun.tools.javac.code.Type type2 = type = null;
            }
        }
        if (type == null && !wellKnownOnly) {
            ClassFinder finder = ClassFinder.instance(this.context);
            Modules modules = Modules.instance(this.context);
            Names names = Names.instance(this.context);
            if (finder != null && modules != null && names != null) {
                try {
                    Symbol.ClassSymbol sym = finder.loadClass(modules.getDefaultModule(), names.fromString(typeName));
                    if (sym != null) {
                        type = sym.type;
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
            }
        }
        return type != null ? this.bindings.getTypeBinding(type, null, null, true) : null;
    }

    IAnnotationBinding resolveAnnotation(Annotation annotation) {
        return (IAnnotationBinding)this.resolveCached((ASTNode)annotation, n -> this.resolveAnnotationImpl((Annotation)n));
    }

    IAnnotationBinding resolveAnnotationImpl(Annotation annotation) {
        this.resolve();
        ITypeBinding recipient = null;
        ASTNode aSTNode = annotation.getParent();
        if (aSTNode instanceof AnnotatableType) {
            AnnotatableType annotatable = (AnnotatableType)aSTNode;
            recipient = annotatable.resolveBinding();
        } else {
            aSTNode = annotation.getParent();
            if (aSTNode instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
                recipient = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).resolveBinding();
            } else {
                aSTNode = annotation.getParent();
                if (aSTNode instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement vds = (VariableDeclarationStatement)aSTNode;
                    recipient = ((VariableDeclarationFragment)vds.fragments().get(0)).resolveBinding();
                } else {
                    aSTNode = annotation.getParent();
                    if (aSTNode instanceof TypeDeclaration) {
                        TypeDeclaration td = (TypeDeclaration)aSTNode;
                        recipient = td.resolveBinding();
                    }
                }
            }
        }
        JCTree javac = this.converter.domToJavac.get(annotation);
        if (javac instanceof JCTree.JCAnnotation) {
            JCTree.JCAnnotation jcAnnotation = (JCTree.JCAnnotation)javac;
            if (!jcAnnotation.type.isErroneous() || this.isRecoveringBindings()) {
                return this.bindings.getAnnotationBinding(jcAnnotation.attribute, (IBinding)recipient);
            }
        }
        return null;
    }

    IMemberValuePairBinding resolveMemberValuePair(MemberValuePair memberValuePair) {
        this.resolve();
        Object object = this.converter.domToJavac.get(memberValuePair);
        if (object instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)object;
            object = assign.lhs;
            if (object instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)object;
                object = ident.sym;
                if (object instanceof Symbol.MethodSymbol) {
                    Object object2;
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)object;
                    JCTree.JCExpression jCExpression = assign.getExpression();
                    if (jCExpression instanceof JCTree.JCLiteral) {
                        JCTree.JCLiteral literal = (JCTree.JCLiteral)jCExpression;
                        object2 = literal.getValue();
                    } else {
                        object2 = null;
                    }
                    return this.bindings.getMemberValuePairBinding(methodSymbol, object2);
                }
            }
        }
        return null;
    }

    IBinding resolveReference(MethodRef ref) {
        return this.resolveCached((ASTNode)ref, n -> this.resolveReferenceImpl((MethodRef)n));
    }

    private IBinding resolveReferenceImpl(MethodRef ref) {
        DocTreePath[] possible;
        this.resolve();
        DocTreePath path = this.converter.findDocTreePath((ASTNode)ref);
        if (path != null) {
            Tree t;
            Element e = JavacTrees.instance(this.context).getElement(path);
            if (e instanceof Symbol) {
                Symbol symbol = (Symbol)e;
                IBinding r1 = this.bindings.getBinding(symbol, null);
                return r1;
            }
            TreePath dt = path.getTreePath();
            if (dt != null && (t = dt.getLeaf()) instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl jcmd = (JCTree.JCMethodDecl)t;
                Symbol.MethodSymbol ms = jcmd.sym;
                IBinding r1 = ms == null ? null : this.bindings.getBinding(ms, jcmd.type);
                return r1;
            }
        }
        if (ref.parameters() != null && ref.parameters().size() == 0 && (possible = this.converter.searchRelatedDocTreePath(ref)) != null) {
            for (int i = 0; i < possible.length; ++i) {
                Symbol symbol;
                IBinding r1;
                Element e = JavacTrees.instance(this.context).getElement(possible[i]);
                if (!(e instanceof Symbol) || (r1 = this.bindings.getBinding(symbol = (Symbol)e, null)) == null) continue;
                return r1;
            }
        }
        return null;
    }

    private IBinding getFieldAccessBinding(JCTree.JCFieldAccess fieldAccess) {
        JCTree.JCFieldAccess jcfa3;
        JCTree.JCExpression jCExpression;
        JCTree.JCFieldAccess jcfa2;
        JCTree.JCFieldAccess jCFieldAccess = jcfa2 = fieldAccess.sym == null && (jCExpression = fieldAccess.selected) instanceof JCTree.JCFieldAccess ? (jcfa3 = (JCTree.JCFieldAccess)jCExpression) : fieldAccess;
        if (jcfa2.sym != null) {
            Symbol symbol;
            com.sun.tools.javac.code.Type typeToUse = jcfa2.type;
            if ((typeToUse == null || typeToUse.isErroneous()) && (symbol = TreeInfo.symbolFor(jcfa2)) instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSym = (Symbol.VarSymbol)symbol;
                typeToUse = varSym.type;
            }
            if ((typeToUse == null || typeToUse.isErroneous()) && !this.isRecoveringBindings()) {
                return null;
            }
            IBinding bRet = this.bindings.getBinding(jcfa2.sym, typeToUse);
            if (bRet == null && jcfa2.selected instanceof JCTree.JCTypeApply) {
                typeToUse = jcfa2.sym.type;
            }
            if (jcfa2 != fieldAccess && bRet instanceof ITypeBinding) {
                ITypeBinding itb = (ITypeBinding)bRet;
                String fieldAccessIdentifier = fieldAccess.getIdentifier().toString();
                Function<IBinding[], IBinding> func = bindings -> {
                    for (int i = 0; i < ((IBinding[])bindings).length; ++i) {
                        String childName = bindings[i].getName();
                        if (!childName.equals(fieldAccessIdentifier)) continue;
                        return bindings[i];
                    }
                    return null;
                };
                IBinding ret = func.apply((IBinding[])itb.getDeclaredTypes());
                if (ret != null) {
                    return ret;
                }
                ret = func.apply((IBinding[])itb.getDeclaredFields());
                if (ret != null) {
                    return ret;
                }
                ret = func.apply((IBinding[])itb.getDeclaredMethods());
                if (ret != null) {
                    return ret;
                }
            }
            return bRet;
        }
        return null;
    }

    IBinding resolveReference(MemberRef ref) {
        return this.resolveCached((ASTNode)ref, n -> this.resolveReferenceImpl((MemberRef)n));
    }

    private IBinding resolveReferenceImpl(MemberRef ref) {
        Element element;
        this.resolve();
        DocTreePath path = this.converter.findDocTreePath((ASTNode)ref);
        if (path != null && (element = JavacTrees.instance(this.context).getElement(path)) instanceof Symbol) {
            Symbol symbol = (Symbol)element;
            return this.bindings.getBinding(symbol, null);
        }
        return null;
    }

    private static Symbol getRecoveredSymbol(com.sun.tools.javac.code.Type type) {
        if (type instanceof Type.ErrorType) {
            try {
                Field candidateSymbolField = type.getClass().getField("candidateSymbol");
                candidateSymbolField.setAccessible(true);
                Object symbolFieldValue = candidateSymbolField.get(type);
                if (symbolFieldValue instanceof Symbol) {
                    Symbol symbol = (Symbol)symbolFieldValue;
                    return symbol;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.owner;
    }

    Object resolveConstantExpressionValue(Expression expression) {
        Object object;
        JCTree jcTree = this.converter.domToJavac.get(expression);
        if (jcTree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral literal = (JCTree.JCLiteral)jcTree;
            return literal.getValue();
        }
        if (jcTree == null && expression.getParent() != null && (jcTree = this.converter.domToJavac.get(expression.getParent())) == null) {
            return null;
        }
        Symbol symbol = TreeInfo.symbolFor(jcTree);
        if (symbol instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            object = varSymbol.getConstantValue();
        } else {
            object = null;
        }
        return object;
    }

    private void ensureBoxingMapsCreated() {
        HashMap<String, String> m;
        if (this.directBoxingMap == null) {
            m = new HashMap<String, String>();
            m.put("java.lang.Boolean", "boolean");
            m.put("java.lang.Byte", "byte");
            m.put("java.lang.Character", "char");
            m.put("java.lang.Float", "float");
            m.put("java.lang.Integer", "int");
            m.put("java.lang.Long", "long");
            m.put("java.lang.Short", "short");
            m.put("java.lang.Double", "double");
            this.directBoxingMap = m;
        }
        if (this.unboxingMapWithConversions == null) {
            m = new HashMap();
            m.put("java.lang.Boolean", (String)((Object)Arrays.asList("boolean")));
            m.put("java.lang.Byte", (String)((Object)Arrays.asList("byte", "float", "int", "long", "short", "double")));
            m.put("java.lang.Character", (String)((Object)Arrays.asList("char", "float", "int", "long", "double")));
            m.put("java.lang.Short", (String)((Object)Arrays.asList("short", "float", "int", "long", "double")));
            m.put("java.lang.Float", (String)((Object)Arrays.asList("float", "double")));
            m.put("java.lang.Integer", (String)((Object)Arrays.asList("float", "int", "long", "double")));
            m.put("java.lang.Long", (String)((Object)Arrays.asList("long", "float", "double")));
            m.put("java.lang.Double", (String)((Object)Arrays.asList("byte", "char", "float", "integer", "long", "double")));
            this.unboxingMapWithConversions = m;
        }
        if (this.boxingMapWithConversions == null) {
            m = new HashMap();
            m.put("java.lang.Boolean", (String)((Object)Arrays.asList("boolean")));
            m.put("java.lang.Byte", (String)((Object)Arrays.asList("byte", "char", "int", "short")));
            m.put("java.lang.Character", (String)((Object)Arrays.asList("byte", "char", "int", "short")));
            m.put("java.lang.Float", (String)((Object)Arrays.asList("float")));
            m.put("java.lang.Integer", (String)((Object)Arrays.asList("int")));
            m.put("java.lang.Long", (String)((Object)Arrays.asList("long")));
            m.put("java.lang.Short", (String)((Object)Arrays.asList("byte", "char", "int", "short")));
            m.put("java.lang.Double", (String)((Object)Arrays.asList("double")));
            this.boxingMapWithConversions = m;
        }
    }

    private boolean isBoxedVersion(NumberLiteral unboxed, ITypeBinding boxed) {
        if (boxed instanceof JavacTypeBinding) {
            String boxedString;
            JavacTypeBinding boxedBind = (JavacTypeBinding)boxed;
            String string = boxedString = boxedBind.typeSymbol == null ? null : boxedBind.typeSymbol.toString();
            if ("java.lang.Integer".equals(boxedString) || "java.lang.Float".equals(boxedString) || "java.lang.Double".equals(boxedString)) {
                return true;
            }
        }
        return false;
    }

    private boolean isBoxedVersion(ITypeBinding unboxed, ITypeBinding boxed) {
        this.ensureBoxingMapsCreated();
        return this.isBoxedVersionDirectional(unboxed, boxed, this.boxingMapWithConversions);
    }

    private boolean isUnboxedVersion(ITypeBinding unboxed, ITypeBinding boxed, Map<String, java.util.List<String>> directionalMap) {
        this.ensureBoxingMapsCreated();
        return this.isBoxedVersionDirectional(unboxed, boxed, this.unboxingMapWithConversions);
    }

    private boolean isBoxedVersionDirectional(ITypeBinding unboxed, ITypeBinding boxed, Map<String, java.util.List<String>> directionalMap) {
        if (boxed instanceof JavacTypeBinding) {
            JavacTypeBinding boxedBind = (JavacTypeBinding)boxed;
            if (unboxed instanceof JavacTypeBinding) {
                String unboxedString;
                JavacTypeBinding unboxedBind = (JavacTypeBinding)unboxed;
                String boxedString = boxedBind.typeSymbol == null ? null : boxedBind.typeSymbol.toString();
                String string = unboxedString = unboxedBind.typeSymbol == null ? null : unboxedBind.typeSymbol.toString();
                if (boxedString != null && unboxedString != null) {
                    return this.isBoxedVersionDirectional(unboxedString, boxedString, directionalMap);
                }
            }
        }
        return false;
    }

    private boolean isBoxedVersionDirectional(String unboxedString, String boxedString, Map<String, java.util.List<String>> directionalMap) {
        String identicalUnboxed = this.directBoxingMap.get(boxedString);
        if (identicalUnboxed != null && identicalUnboxed.equals(unboxedString)) {
            return true;
        }
        java.util.List<String> allowed = directionalMap.get(boxedString);
        return allowed != null && allowed.contains(unboxedString);
    }

    boolean resolveBoxing(Expression expression) {
        boolean match;
        MethodInvocation invoc = null;
        ASTNode aSTNode = expression.getParent();
        if (aSTNode instanceof MethodInvocation) {
            MethodInvocation mi;
            invoc = mi = (MethodInvocation)aSTNode;
        }
        return invoc != null && (match = this.resolveBoxingForArguments(invoc, expression));
    }

    boolean resolveBoxingForArguments(MethodInvocation invoc, Expression expression) {
        IMethodBinding mb = this.resolveMethod(invoc);
        int foundArg = -1;
        if (mb != null) {
            ITypeBinding[] tbs;
            for (int i = 0; i < invoc.arguments().size() && foundArg == -1; ++i) {
                if (invoc.arguments().get(i) != expression) continue;
                foundArg = i;
            }
            if (foundArg != -1 && (tbs = mb.getParameterTypes()).length > foundArg) {
                ITypeBinding foundType = tbs[foundArg];
                if (expression instanceof NumberLiteral) {
                    NumberLiteral nl = (NumberLiteral)expression;
                    if (this.isBoxedVersion(nl, foundType)) {
                        return true;
                    }
                } else if (expression instanceof MethodInvocation) {
                    ITypeBinding retTypeInner;
                    MethodInvocation inner = (MethodInvocation)expression;
                    JavacMethodBinding mbInner = (JavacMethodBinding)this.resolveMethod(inner);
                    ITypeBinding iTypeBinding = retTypeInner = mbInner == null ? null : mbInner.getReturnType();
                    if (this.isBoxedVersion(retTypeInner, foundType)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    boolean resolveUnboxing(Expression expression) {
        Type leftTypeDom;
        MethodInvocation mi3;
        ASTNode aSTNode;
        MethodInvocation mi2;
        MethodInvocation mi = expression instanceof MethodInvocation ? (mi2 = (MethodInvocation)expression) : ((aSTNode = expression.getParent()) instanceof MethodInvocation ? (mi3 = (MethodInvocation)aSTNode) : null);
        Type t = null;
        boolean isNewInstance = false;
        boolean isVariableDeclaration = false;
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)expression;
            t = cic.getType();
            isNewInstance = true;
        } else if (expression instanceof MethodInvocation) {
            VariableDeclarationFragment vdf;
            MethodInvocation mi22 = (MethodInvocation)expression;
            ASTNode aSTNode2 = expression.getParent();
            if (aSTNode2 instanceof VariableDeclarationFragment && (aSTNode2 = (vdf = (VariableDeclarationFragment)aSTNode2).getParent()) instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)aSTNode2;
                t = vds.getType();
                isVariableDeclaration = true;
            }
        }
        boolean argMatch = this.resolveUnboxingForArgument(mi, t, expression);
        if (argMatch) {
            return true;
        }
        if (isVariableDeclaration && (leftTypeDom = t) instanceof PrimitiveType) {
            PrimitiveType pt = (PrimitiveType)leftTypeDom;
            String leftTypeAsString = pt.getPrimitiveTypeCode().toString();
            IMethodBinding mb = this.resolveMethod(mi);
            ITypeBinding returnType = mb.getReturnType();
            String rightTypeFQQN = returnType.getQualifiedName();
            this.ensureBoxingMapsCreated();
            if (this.isBoxedVersionDirectional(leftTypeAsString, rightTypeFQQN, this.unboxingMapWithConversions)) {
                return true;
            }
        }
        return false;
    }

    boolean resolveUnboxingForArgument(MethodInvocation mi, Type t, Expression possibleArgument) {
        if (t != null && mi != null) {
            int foundArg = -1;
            if (mi != null) {
                ITypeBinding el;
                ITypeBinding lastArg;
                ITypeBinding boxed;
                ITypeBinding unboxed;
                IMethodBinding mb;
                ITypeBinding[] tbs;
                for (int i = 0; i < mi.arguments().size() && foundArg == -1; ++i) {
                    if (mi.arguments().get(i) != possibleArgument) continue;
                    foundArg = i;
                }
                if (foundArg != -1 && ((tbs = (mb = this.resolveMethod(mi)).getParameterTypes()).length > foundArg ? this.isBoxedVersion(unboxed = tbs[foundArg], boxed = this.resolveType(t)) : tbs.length > 0 && mb.isVarargs() && (lastArg = tbs[tbs.length - 1]).isArray() && (el = lastArg.getElementType()).isPrimitive() && this.isBoxedVersion(el, this.resolveType(t)))) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRecoveringBindings() {
        return this.isRecoveringBindings;
    }

    public String getConverterRawText() {
        return this.converter == null ? null : this.converter.rawText;
    }

    public static ExecutableType asExecutable(com.sun.tools.javac.code.Type t) {
        ExecutableType exec;
        return t instanceof ExecutableType ? (exec = (ExecutableType)((Object)t)) : (t == null ? null : t.asMethodType());
    }

    public class Bindings {
        private Map<JavacAnnotationBinding, JavacAnnotationBinding> annotationBindings;
        private Map<JavacMemberValuePairBinding, JavacMemberValuePairBinding> memberValuePairBindings;
        private Map<JavacMethodBinding, JavacMethodBinding> methodBindings;
        private Map<JavacModuleBinding, JavacModuleBinding> moduleBindings;
        private Map<JavacPackageBinding, JavacPackageBinding> packageBindings;
        private Map<JavacTypeBinding, JavacTypeBinding> typeBinding;
        private Map<JavacTypeVariableBinding, JavacTypeVariableBinding> typeVariableBindings;
        private Map<JavacVariableBinding, JavacVariableBinding> variableBindings;
        private Map<JavacLambdaBinding, JavacLambdaBinding> lambdaBindings;
        final /* synthetic */ JavacBindingResolver this$0;

        public Bindings(JavacBindingResolver this$0) {
            JavacBindingResolver javacBindingResolver = this$0;
            Objects.requireNonNull(javacBindingResolver);
            this.this$0 = javacBindingResolver;
            this.annotationBindings = new HashMap<JavacAnnotationBinding, JavacAnnotationBinding>();
            this.memberValuePairBindings = new HashMap<JavacMemberValuePairBinding, JavacMemberValuePairBinding>();
            this.methodBindings = new HashMap<JavacMethodBinding, JavacMethodBinding>();
            this.moduleBindings = new HashMap<JavacModuleBinding, JavacModuleBinding>();
            this.packageBindings = new HashMap<JavacPackageBinding, JavacPackageBinding>();
            this.typeBinding = new HashMap<JavacTypeBinding, JavacTypeBinding>();
            this.typeVariableBindings = new HashMap<JavacTypeVariableBinding, JavacTypeVariableBinding>();
            this.variableBindings = new HashMap<JavacVariableBinding, JavacVariableBinding>();
            this.lambdaBindings = new HashMap<JavacLambdaBinding, JavacLambdaBinding>();
        }

        public JavacAnnotationBinding getAnnotationBinding(Attribute.Compound ann, IBinding recipient) {
            if (ann.type.isErroneous() && !this.this$0.isRecoveringBindings()) {
                return null;
            }
            JavacAnnotationBinding newInstance = new JavacAnnotationBinding(this, ann, this.this$0, recipient){
                {
                    Objects.requireNonNull(this$1);
                    super(ann, resolver, recipient);
                }
            };
            this.annotationBindings.putIfAbsent(newInstance, newInstance);
            return this.annotationBindings.get(newInstance);
        }

        public JavacMemberValuePairBinding getMemberValuePairBinding(Symbol.MethodSymbol key, Object value) {
            JavacMemberValuePairBinding newInstance = new JavacMemberValuePairBinding(this, key, value, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(key, value, resolver);
                }
            };
            this.memberValuePairBindings.putIfAbsent(newInstance, newInstance);
            return this.memberValuePairBindings.get(newInstance);
        }

        public JavacMemberValuePairBinding getDefaultMemberValuePairBinding(IMethodBinding defaultAnnotationMethod) {
            if (!defaultAnnotationMethod.isAnnotationMember()) {
                return null;
            }
            JavacMemberValuePairBinding newInstance = new JavacMemberValuePairBinding(this, defaultAnnotationMethod, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(defaultAnnotationMethod, resolver);
                }
            };
            this.memberValuePairBindings.putIfAbsent(newInstance, newInstance);
            return this.memberValuePairBindings.get(newInstance);
        }

        public JavacMethodBinding getMethodBinding(ExecutableType methodType, Symbol.MethodSymbol sym, com.sun.tools.javac.code.Type type, boolean isSynthetic, boolean isDeclaration, java.util.List<com.sun.tools.javac.code.Type> typeArgs) {
            if (isSynthetic) {
                return this.getSyntheticMethodBinding(methodType, sym, type, typeArgs);
            }
            return this.getMethodBinding(methodType, sym, type, isDeclaration, typeArgs);
        }

        public JavacMethodBinding getMethodBinding(ExecutableType methodType, Symbol.MethodSymbol methodSymbol, com.sun.tools.javac.code.Type parentType, boolean isDeclaration, java.util.List<com.sun.tools.javac.code.Type> resolvedTypeArgs) {
            JavacMethodBinding newInstance = new JavacMethodBinding(this, methodType, methodSymbol, parentType, this.this$0, false, isDeclaration, resolvedTypeArgs){
                {
                    Objects.requireNonNull(this$1);
                    super(methodType, methodSymbol, parentType, resolver, explicitSynthetic, isDeclaration, resolvedTypeArgs);
                }
            };
            return this.insertAndReturn(newInstance);
        }

        public JavacMethodBinding getSyntheticMethodBinding(ExecutableType methodType, Symbol.MethodSymbol methodSymbol, com.sun.tools.javac.code.Type parentType, java.util.List<com.sun.tools.javac.code.Type> resolvedTypeArgs) {
            JavacMethodBinding newInstance = new JavacMethodBinding(this, methodType, methodSymbol, parentType, this.this$0, true, false, resolvedTypeArgs){
                {
                    Objects.requireNonNull(this$1);
                    super(methodType, methodSymbol, parentType, resolver, explicitSynthetic, isDeclaration, resolvedTypeArgs);
                }
            };
            return this.insertAndReturn(newInstance);
        }

        public JavacMethodBinding getErrorMethodBinding(ExecutableType methodType, Symbol originatingSymbol, java.util.List<com.sun.tools.javac.code.Type> typeArgs) {
            JavacErrorMethodBinding newInstance = new JavacErrorMethodBinding(this, originatingSymbol, methodType, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(originatingSymbol, methodType, resolver);
                }
            };
            return this.insertAndReturn(newInstance);
        }

        private JavacMethodBinding insertAndReturn(JavacMethodBinding newInstance) {
            this.methodBindings.putIfAbsent(newInstance, newInstance);
            return this.methodBindings.get(newInstance);
        }

        public JavacModuleBinding getModuleBinding(Type.ModuleType moduleType) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleType, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(moduleType, resolver);
                }
            };
            this.moduleBindings.putIfAbsent(newInstance, newInstance);
            return this.moduleBindings.get(newInstance);
        }

        public JavacModuleBinding getModuleBinding(Symbol.ModuleSymbol moduleSymbol) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleSymbol, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(moduleSymbol, resolver);
                }
            };
            this.moduleBindings.putIfAbsent(newInstance, newInstance);
            return this.moduleBindings.get(newInstance);
        }

        public JavacModuleBinding getModuleBinding(JCTree.JCModuleDecl moduleDecl) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleDecl, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(decl, resolver);
                }
            };
            this.moduleBindings.put(newInstance, newInstance);
            return this.moduleBindings.get(newInstance);
        }

        public JavacPackageBinding getPackageBinding(Symbol.PackageSymbol packageSymbol) {
            Symbol.PackageSymbol parentPack;
            Symbol symbol = packageSymbol.owner;
            if (symbol instanceof Symbol.PackageSymbol && !((parentPack = (Symbol.PackageSymbol)symbol) instanceof Symbol.RootPackageSymbol)) {
                this.getPackageBinding(parentPack);
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, packageSymbol, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(packge, resolver);
                }
            };
            return this.preferentiallyInsertPackageBinding(newInstance);
        }

        public JavacPackageBinding getPackageBinding(Name name) {
            return this.getPackageBinding(this.packageNameToString(name));
        }

        public JavacPackageBinding getPackageBinding(String n) {
            if (n == null) {
                return null;
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, n, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(nameString, resolver);
                }
            };
            return this.preferentiallyInsertPackageBinding(newInstance);
        }

        public JavacPackageBinding findExistingPackageBinding(Name name) {
            String k;
            String n;
            String string = n = name == null ? null : name.toString();
            if (n == null) {
                return null;
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, n, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(nameString, resolver);
                }
            };
            String string2 = k = newInstance == null ? null : newInstance.getKey();
            if (k != null) {
                JavacPackageBinding current = this.packageBindings.get(k);
                return current;
            }
            return null;
        }

        private String packageNameToString(Name name) {
            ASTNode aSTNode;
            String n = null;
            if (name instanceof QualifiedName) {
                n = name.toString();
            } else if (name instanceof SimpleName && (aSTNode = name.getParent()) instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)aSTNode;
                if (qn.getName() == name) {
                    n = qn.toString();
                } else if (qn.getQualifier() == name) {
                    n = name.toString();
                }
            }
            return n;
        }

        private JavacPackageBinding preferentiallyInsertPackageBinding(JavacPackageBinding newest) {
            if (newest != null) {
                JavacPackageBinding current = this.packageBindings.get(newest);
                if (current == null) {
                    this.packageBindings.putIfAbsent(newest, newest);
                } else if (current.getPackageSymbol() == null && newest.getPackageSymbol() != null) {
                    current.setPackageSymbol(newest.getPackageSymbol());
                }
                return this.packageBindings.get(newest);
            }
            return null;
        }

        public JavacTypeBinding getTypeBinding(com.sun.tools.javac.code.Type type) {
            if (type == null) {
                return null;
            }
            boolean likelyGeneric = false;
            return this.getTypeBinding(type.baseType(), null, null, likelyGeneric);
        }

        public JavacTypeBinding getTypeBinding(com.sun.tools.javac.code.Type type, com.sun.tools.javac.code.Type[] alternatives, Symbol backupOwner, boolean isGeneric) {
            block11: {
                block10: {
                    if (type instanceof Type.TypeVar) {
                        Type.TypeVar typeVar = (Type.TypeVar)type;
                        return this.getTypeVariableBinding(typeVar, backupOwner);
                    }
                    if (type == null || type == com.sun.tools.javac.code.Type.noType) {
                        return null;
                    }
                    if (type instanceof Type.ErrorType) {
                        Symbol.ClassSymbol classErrorSymbol;
                        Type.ErrorType errorType = (Type.ErrorType)type;
                        com.sun.tools.javac.code.Type originalType = errorType.getOriginalType();
                        if (!(originalType == com.sun.tools.javac.code.Type.noType || originalType instanceof Type.MethodType || originalType instanceof Type.ForAll || originalType instanceof Type.ErrorType)) {
                            JavacTypeBinding newInstance = new JavacTypeBinding(this, originalType, type.tsym, alternatives, backupOwner, isGeneric, this.this$0){
                                {
                                    Objects.requireNonNull(this$1);
                                    super(type, typeSymbol, alternatives, backupOwner, likelyGeneric, resolver);
                                }
                            };
                            this.typeBinding.putIfAbsent(newInstance, newInstance);
                            JavacTypeBinding jcb = this.typeBinding.get(newInstance);
                            jcb.setRecovered(true);
                            return jcb;
                        }
                        Object newInstance = errorType.tsym;
                        if (newInstance instanceof Symbol.ClassSymbol && Character.isJavaIdentifierStart((classErrorSymbol = (Symbol.ClassSymbol)newInstance).getSimpleName().charAt(0))) {
                            newInstance = new JavacTypeBinding(this, classErrorSymbol.type, classErrorSymbol, alternatives, backupOwner, isGeneric, this.this$0){
                                {
                                    Objects.requireNonNull(this$1);
                                    super(type, typeSymbol, alternatives, backupOwner, likelyGeneric, resolver);
                                }
                            };
                            this.typeBinding.putIfAbsent((JavacTypeBinding)newInstance, (JavacTypeBinding)newInstance);
                            JavacTypeBinding jcb = this.typeBinding.get(newInstance);
                            jcb.setRecovered(true);
                            return jcb;
                        }
                        return null;
                    }
                    Symbol.TypeSymbol typeSymbol = type.tsym;
                    if (!(typeSymbol instanceof Symbol.ClassSymbol)) break block10;
                    Symbol.ClassSymbol sym = (Symbol.ClassSymbol)typeSymbol;
                    if (sym.classfile == null && sym.sourcefile == null) break block11;
                }
                if (!type.isParameterized() && !type.isRaw() && type instanceof Type.ClassType) {
                    Type.ClassType classType = (Type.ClassType)type;
                    if (classType.interfaces_field == null) {
                        type = type.tsym.type;
                    }
                }
            }
            JavacTypeBinding newInstance = new JavacTypeBinding(this, type, type.tsym, alternatives, backupOwner, isGeneric, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(type, typeSymbol, alternatives, backupOwner, likelyGeneric, resolver);
                }
            };
            this.typeBinding.putIfAbsent(newInstance, newInstance);
            return this.typeBinding.get(newInstance);
        }

        public JavacTypeBinding getRecoveredTypeBinding(com.sun.tools.javac.code.Type type, Name domName) {
            if (domName.getLocationInParent() == SimpleType.NAME_PROPERTY) {
                return this.getRecoveredTypeBinding(type, (Type)((SimpleType)domName.getParent()));
            }
            JavacRecoveredTypeBinding res = new JavacRecoveredTypeBinding(type, (ASTNode)domName, this.this$0);
            this.typeBinding.putIfAbsent(res, res);
            return this.typeBinding.get(res);
        }

        public JavacTypeBinding getRecoveredTypeBinding(com.sun.tools.javac.code.Type type, Type domType) {
            JavacRecoveredTypeBinding res = new JavacRecoveredTypeBinding(type, (ASTNode)domType, this.this$0);
            this.typeBinding.putIfAbsent(res, res);
            return this.typeBinding.get(res);
        }

        public JavacTypeVariableBinding getTypeVariableBinding(Type.TypeVar typeVar, Symbol backupOwner) {
            JavacTypeVariableBinding newInstance = new JavacTypeVariableBinding(this, typeVar, (Symbol.TypeVariableSymbol)typeVar.tsym, backupOwner, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(type, sym, backupOwner, bindingResolver);
                }
            };
            this.typeVariableBindings.putIfAbsent(newInstance, newInstance);
            return this.typeVariableBindings.get(newInstance);
        }

        public JavacVariableBinding getVariableBinding(Symbol.VarSymbol varSymbol) {
            if (varSymbol == null) {
                return null;
            }
            JavacVariableBinding newInstance = new JavacVariableBinding(this, varSymbol, this.this$0){
                {
                    Objects.requireNonNull(this$1);
                    super(sym, resolver);
                }
            };
            this.variableBindings.putIfAbsent(newInstance, newInstance);
            return this.variableBindings.get(newInstance);
        }

        public JavacLambdaBinding getLambdaBinding(JavacMethodBinding javacMethodBinding, LambdaExpression lambda) {
            JavacLambdaBinding newInstance = new JavacLambdaBinding(javacMethodBinding, lambda);
            this.lambdaBindings.putIfAbsent(newInstance, newInstance);
            return this.lambdaBindings.get(newInstance);
        }

        public IBinding getBinding(Symbol owner, com.sun.tools.javac.code.Type type) {
            com.sun.tools.javac.code.Type type2;
            Symbol recoveredSymbol = JavacBindingResolver.getRecoveredSymbol(type);
            if (recoveredSymbol != null) {
                return this.getBinding(recoveredSymbol, recoveredSymbol.type);
            }
            if (type != null && (type instanceof Type.ErrorType || owner == null || owner.owner == null || owner.owner.type == com.sun.tools.javac.code.Type.noType) && (type2 = type.getOriginalType()) instanceof Type.MethodType) {
                Type.MethodType missingMethodType = (Type.MethodType)type2;
                return this.getErrorMethodBinding(missingMethodType, owner, null);
            }
            if (owner instanceof Symbol.PackageSymbol) {
                Symbol.PackageSymbol other = (Symbol.PackageSymbol)owner;
                return this.getPackageBinding(other);
            }
            if (owner instanceof Symbol.ModuleSymbol) {
                Symbol.ModuleSymbol typeSymbol = (Symbol.ModuleSymbol)owner;
                return this.getModuleBinding(typeSymbol);
            }
            if (owner instanceof Symbol.TypeVariableSymbol) {
                Symbol.TypeVariableSymbol typeVariableSymbol = (Symbol.TypeVariableSymbol)owner;
                if (type instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)type;
                    return this.getTypeVariableBinding(typeVar, owner);
                }
                com.sun.tools.javac.code.Type type3 = typeVariableSymbol.type;
                if (type3 instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)type3;
                    return this.getTypeVariableBinding(typeVar, owner);
                }
            } else {
                if (owner instanceof Symbol.TypeSymbol) {
                    Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)owner;
                    return this.getTypeBinding(JavacBindingResolver.isTypeOfType(type) ? type : typeSymbol.type);
                }
                if (owner instanceof Symbol.MethodSymbol) {
                    ExecutableType methodType;
                    ExecutableType aMethodType;
                    Symbol.MethodSymbol other = (Symbol.MethodSymbol)owner;
                    ExecutableType executableType = type instanceof ExecutableType ? (aMethodType = (ExecutableType)((Object)type)) : (methodType = owner.type != null ? JavacBindingResolver.asExecutable(owner.type) : null);
                    if (methodType != null) {
                        return this.getMethodBinding(methodType, other, null, false, null);
                    }
                } else if (owner instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol other = (Symbol.VarSymbol)owner;
                    return this.getVariableBinding(other);
                }
            }
            return null;
        }

        private IBinding filterCollectionFindKey(Collection<? extends IBinding> vals, String key) {
            return vals.stream().filter(b -> key.equals(b.getKey())).findAny().orElse(null);
        }

        public IBinding getBinding(String key) {
            IBinding binding = this.filterCollectionFindKey(this.annotationBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.memberValuePairBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.methodBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.moduleBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.packageBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.typeBinding.values(), key);
            if (binding != null) {
                return binding;
            }
            binding = this.filterCollectionFindKey(this.typeVariableBindings.values(), key);
            if (binding != null) {
                return binding;
            }
            return this.filterCollectionFindKey(this.variableBindings.values(), key);
        }
    }

    public static class BindingKeyException
    extends Exception {
        private static final long serialVersionUID = -4468681148041117634L;

        public BindingKeyException(Throwable t) {
            super(t);
        }

        public BindingKeyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

