/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.Stack;
import java.util.function.Supplier;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.NullTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class OperandStack {
    private Stack<TypeBinding> stack;
    private ClassFile classFile;
    private Scope scope;

    public OperandStack() {
    }

    public OperandStack(ClassFile classFile) {
        this.stack = new Stack();
        this.classFile = classFile;
        this.scope = classFile.referenceBinding.scope;
    }

    private OperandStack(OperandStack operandStack) {
        this.stack = (Stack)operandStack.stack.clone();
        this.classFile = operandStack.classFile;
        this.scope = operandStack.scope;
    }

    protected OperandStack copy() {
        return new OperandStack(this);
    }

    public void push(TypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new AssertionError((Object)"Attempt to push null on operand stack!");
        }
        this.stack.push(switch (typeBinding.id) {
            case 2, 3, 4, 5 -> TypeBinding.INT;
            default -> typeBinding;
        });
    }

    private TypeBinding erasure(TypeBinding type) {
        TypeBinding erasure = type.erasure();
        if (erasure instanceof ArrayBinding) {
            ArrayBinding array = (ArrayBinding)erasure;
            if (array.leafComponentType instanceof IntersectionTypeBinding18) {
                erasure = this.scope.createArrayType(this.scope.getJavaLangObject(), array.dimensions);
            }
        }
        return erasure;
    }

    public void push(int localSlot) {
        if (localSlot >= this.classFile.codeStream.maxLocals) {
            throw new AssertionError((Object)"Unexpected resolved position");
        }
        TypeBinding type = this.classFile.codeStream.retrieveLocalType(this.classFile.codeStream.position, localSlot);
        this.push(type);
    }

    public void push(char[] typeName) {
        Supplier<ReferenceBinding> finder = this.scope.getCommonReferenceBinding(typeName);
        NullTypeBinding type = finder != null ? (TypeBinding)finder.get() : TypeBinding.NULL;
        this.push(type);
    }

    public TypeBinding pop() {
        return this.stack.pop();
    }

    public void pop(int nSlots) {
        int i = 0;
        while (i < nSlots) {
            TypeBinding t = this.pop();
            if ((i += TypeIds.getCategory(t.id)) > nSlots) {
                throw new AssertionError((Object)"Popped one too many words from operand stack!");
            }
        }
    }

    public TypeBinding pop(OperandCategory category) {
        TypeBinding t = this.pop();
        int n = TypeIds.getCategory(t.id);
        if (n != (switch (category) {
            case OperandCategory.ONE -> 1;
            case OperandCategory.TWO -> 2;
            default -> throw new IncompatibleClassChangeError();
        })) {
            throw new AssertionError((Object)"Unexpected operand at stack top");
        }
        return t;
    }

    public void cast(TypeBinding castedType) {
        if (!castedType.isBaseType()) {
            this.pop();
            this.push(castedType);
        }
    }

    public TypeBinding pop(TypeBinding top) {
        if (TypeBinding.equalsEquals(top, this.pop())) {
            return top;
        }
        throw new AssertionError((Object)"Unexpected operand at stack top");
    }

    public void pop2() {
        TypeBinding v1 = this.pop();
        if (TypeIds.getCategory(v1.id) == 1) {
            v1 = this.pop();
            if (TypeIds.getCategory(v1.id) != 1) {
                throw new AssertionError((Object)"pop2 on mixed operand types");
            }
        }
    }

    public TypeBinding peek() {
        return this.stack.peek();
    }

    public TypeBinding peek(TypeBinding top) {
        if (TypeBinding.equalsEquals(top, this.peek())) {
            return top;
        }
        throw new AssertionError((Object)"Unexpected operand at stack top");
    }

    public TypeBinding get(int index) {
        return (TypeBinding)this.stack.get(index);
    }

    public int size() {
        return this.stack.size();
    }

    public void clear() {
        this.stack.clear();
    }

    public boolean depthEquals(int expected) {
        int depth = 0;
        int i = 0;
        int size = this.size();
        while (i < size) {
            TypeBinding t = this.get(i);
            depth += TypeIds.getCategory(t.id);
            ++i;
        }
        return depth == expected;
    }

    public void xaload() {
        this.pop(TypeBinding.INT);
        this.push(((ArrayBinding)this.pop()).elementsType());
    }

    public void xastore() {
        boolean wellFormed;
        TypeBinding valueType = this.pop();
        this.pop(TypeBinding.INT);
        TypeBinding elementType = ((ArrayBinding)this.pop()).elementsType();
        switch (elementType.id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                boolean bl = TypeBinding.equalsEquals(valueType, TypeBinding.INT);
                break;
            }
            default: {
                boolean bl = wellFormed = valueType.isCompatibleWith(elementType) || this.erasure(valueType).isCompatibleWith(this.erasure(elementType));
            }
        }
        if (!wellFormed) {
            throw new AssertionError((Object)"array store with invalid types");
        }
    }

    public void dup2() {
        TypeBinding val1 = this.pop();
        if (TypeIds.getCategory(val1.id) == 2) {
            this.push(val1);
            this.push(val1);
        } else {
            TypeBinding val2 = this.pop();
            if (TypeIds.getCategory(val2.id) != 1) {
                throw new AssertionError((Object)"dup2 on mixed operand types");
            }
            this.push(val2);
            this.push(val1);
            this.push(val2);
            this.push(val1);
        }
    }

    public void dup_x1() {
        TypeBinding[] topStack = new TypeBinding[]{this.pop(OperandCategory.ONE), this.pop(OperandCategory.ONE)};
        this.push(topStack[0]);
        this.push(topStack[1]);
        this.push(topStack[0]);
    }

    public void dup_x2() {
        TypeBinding val1 = this.pop(OperandCategory.ONE);
        TypeBinding val2 = this.pop();
        if (TypeIds.getCategory(val2.id) == 2) {
            this.push(val1);
            this.push(val2);
            this.push(val1);
        } else {
            TypeBinding val3 = this.pop(OperandCategory.ONE);
            this.push(val1);
            this.push(val3);
            this.push(val2);
            this.push(val1);
        }
    }

    public void dup2_x1() {
        TypeBinding val1 = this.pop();
        if (TypeIds.getCategory(val1.id) == 2) {
            TypeBinding val2 = this.pop(OperandCategory.ONE);
            this.push(val1);
            this.push(val2);
            this.push(val1);
        } else {
            TypeBinding val2 = this.pop(OperandCategory.ONE);
            TypeBinding val3 = this.pop(OperandCategory.ONE);
            this.push(val2);
            this.push(val1);
            this.push(val3);
            this.push(val2);
            this.push(val1);
        }
    }

    public void dup2_x2() {
        TypeBinding val1 = this.pop();
        if (TypeIds.getCategory(val1.id) == 2) {
            TypeBinding val2 = this.pop();
            if (TypeIds.getCategory(val2.id) == 2) {
                this.push(val1);
                this.push(val2);
                this.push(val1);
            } else {
                TypeBinding val3 = this.pop(OperandCategory.ONE);
                this.push(val1);
                this.push(val3);
                this.push(val2);
                this.push(val1);
            }
        } else {
            TypeBinding val2 = this.pop(OperandCategory.ONE);
            TypeBinding val3 = this.pop();
            if (TypeIds.getCategory(val3.id) == 2) {
                this.push(val2);
                this.push(val1);
                this.push(val3);
                this.push(val2);
                this.push(val1);
            } else {
                TypeBinding val4 = this.pop(OperandCategory.ONE);
                this.push(val2);
                this.push(val1);
                this.push(val4);
                this.push(val3);
                this.push(val2);
                this.push(val1);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        int length = this.size();
        while (i < length) {
            if (i != 0) {
                sb.append(", ");
            }
            TypeBinding type = (TypeBinding)this.stack.get(i);
            sb.append(type.shortReadableName());
            ++i;
        }
        sb.append("]\n");
        return sb.toString();
    }

    public static class NullStack
    extends OperandStack {
        @Override
        protected NullStack copy() {
            return new NullStack();
        }

        @Override
        public void push(TypeBinding typeBinding) {
        }

        @Override
        public void push(int localSlot) {
        }

        @Override
        public void push(char[] typeName) {
        }

        @Override
        public TypeBinding pop() {
            return TypeBinding.VOID;
        }

        @Override
        public void pop(int nSlots) {
        }

        @Override
        public TypeBinding pop(OperandCategory category) {
            return TypeBinding.VOID;
        }

        @Override
        public TypeBinding pop(TypeBinding top) {
            return TypeBinding.VOID;
        }

        @Override
        public void pop2() {
        }

        @Override
        public TypeBinding peek() {
            return TypeBinding.VOID;
        }

        @Override
        public TypeBinding peek(TypeBinding top) {
            return TypeBinding.VOID;
        }

        @Override
        public TypeBinding get(int index) {
            return TypeBinding.VOID;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean depthEquals(int expected) {
            return true;
        }

        @Override
        public void cast(TypeBinding castedType) {
        }

        @Override
        public void xaload() {
        }

        @Override
        public void xastore() {
        }

        @Override
        public void dup2() {
        }

        @Override
        public void dup_x1() {
        }

        @Override
        public void dup_x2() {
        }

        @Override
        public void dup2_x1() {
        }

        @Override
        public void dup2_x2() {
        }
    }

    static enum OperandCategory {
        ONE,
        TWO;

    }
}

