/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.gradle.compile.CompletionVisitor;
import com.microsoft.gradle.utils.CompletionUtils;
import com.microsoft.gradle.utils.LSPUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class MavenCentralCompletionHandler {
    private static String sequence = "2";
    private static String URL_BASIC_SEARCH = "https://search.maven.org/solrsearch/select?q=";

    public List<CompletionItem> getDependencyCompletionItems(CompletionVisitor.DependencyItem dependency, Position position) {
        Range range = new Range(dependency.getRange().getStart(), position);
        String validText = LSPUtils.getStringBeforePosition(dependency.getText(), dependency.getRange(), position);
        String[] validTexts = validText.split(":", -1);
        switch (validTexts.length) {
            case 1: {
                return this.getGroupIdCompletions(validTexts[0], range);
            }
            case 2: {
                return this.getArtifactIdCompletions(validTexts[0], range);
            }
            case 3: {
                return this.getVersionCompletions(validTexts[0], validTexts[1], range);
            }
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> getGroupIdCompletions(String group, Range range) {
        if (group.length() < 3) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(URL_BASIC_SEARCH);
        builder.append(group);
        builder.append("&rows=50&wt=json");
        return this.getDependenciesFromRestAPI(builder.toString(), DependencyCompletionKind.GROUPID, range);
    }

    private List<CompletionItem> getArtifactIdCompletions(String group, Range range) {
        if (group.length() < 3) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(URL_BASIC_SEARCH);
        builder.append("g:%22");
        builder.append(group);
        builder.append("%22&rows=50&wt=json");
        return this.getDependenciesFromRestAPI(builder.toString(), DependencyCompletionKind.ARTIFACTID, range);
    }

    private List<CompletionItem> getVersionCompletions(String group, String artifact, Range range) {
        if (group.length() < 3 || artifact.length() < 3) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(URL_BASIC_SEARCH);
        builder.append("g:%22");
        builder.append(group);
        builder.append("%22+AND+a:%22");
        builder.append(artifact);
        builder.append("%22&core=gav&rows=50&wt=json");
        return this.getDependenciesFromRestAPI(builder.toString(), DependencyCompletionKind.VERSION, range);
    }

    private List<CompletionItem> getDependenciesFromRestAPI(String url, DependencyCompletionKind kind, Range range) {
        ArrayList<CompletionItem> arrayList;
        InputStreamReader reader = new InputStreamReader(new URL(url).openStream());
        try {
            JsonObject jsonResult = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            JsonObject response = jsonResult.getAsJsonObject("response");
            JsonArray docs = response.getAsJsonArray("docs");
            ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
            for (int i = 0; i < docs.size(); ++i) {
                JsonElement element = docs.get(i);
                if (!(element instanceof JsonObject)) continue;
                CompletionItem completionItem = new CompletionItem();
                String groupId = ((JsonObject)element).get("g").getAsJsonPrimitive().getAsString();
                String artifactId = ((JsonObject)element).get("a").getAsJsonPrimitive().getAsString();
                ArrayList<Object> arguments = new ArrayList<Object>();
                if (kind == DependencyCompletionKind.GROUPID) {
                    TextEdit textEdit = new TextEdit(range, groupId + ":");
                    completionItem.setTextEdit(Either.forLeft((Object)textEdit));
                    completionItem.setLabel(groupId);
                    completionItem.setKind(CompletionItemKind.Module);
                    completionItem.setDetail("GroupID: " + groupId);
                    completionItem.setCommand(new Command(CompletionUtils.completionTitle, CompletionUtils.completionCommand));
                    arguments.add(CompletionUtils.CompletionKinds.DEPENDENCY_GROUP.toString());
                    arguments.add(groupId);
                } else if (kind == DependencyCompletionKind.ARTIFACTID) {
                    int character = range.getStart().getCharacter() + groupId.length() + 1;
                    Range replaceRange = new Range(new Position(range.getStart().getLine(), character), range.getEnd());
                    TextEdit textEdit = new TextEdit(replaceRange, artifactId + ":");
                    completionItem.setTextEdit(Either.forLeft((Object)textEdit));
                    completionItem.setLabel(artifactId);
                    completionItem.setKind(CompletionItemKind.Module);
                    completionItem.setDetail("ArtifactID: " + artifactId);
                    completionItem.setCommand(new Command(CompletionUtils.completionTitle, CompletionUtils.completionCommand));
                    arguments.add(CompletionUtils.CompletionKinds.DEPENDENCY_ARTIFACT.toString());
                    arguments.add(groupId + ":" + artifactId);
                } else if (kind == DependencyCompletionKind.VERSION) {
                    String version = ((JsonObject)element).get("v").getAsJsonPrimitive().getAsString();
                    String timestampValue = ((JsonObject)element).get("timestamp").getAsJsonPrimitive().getAsString();
                    Timestamp timestamp = new Timestamp(Long.parseLong(timestampValue));
                    Date date = new Date(timestamp.getTime());
                    int character = range.getStart().getCharacter() + groupId.length() + 1 + artifactId.length() + 1;
                    Range replaceRange = new Range(new Position(range.getStart().getLine(), character), range.getEnd());
                    TextEdit textEdit = new TextEdit(replaceRange, version);
                    completionItem.setTextEdit(Either.forLeft((Object)textEdit));
                    completionItem.setLabel(version);
                    completionItem.setKind(CompletionItemKind.Constant);
                    completionItem.setDetail("Updated: " + date.toString());
                    arguments.add(CompletionUtils.CompletionKinds.DEPENDENCY_VERSION.toString());
                    arguments.add(groupId + ":" + artifactId + ":" + version);
                }
                completionItem.setCommand(new Command(CompletionUtils.completionTitle, CompletionUtils.completionCommand, arguments));
                completionItem.setSortText(sequence + String.format("%08d", i));
                completions.add(completionItem);
            }
            arrayList = completions;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private static enum DependencyCompletionKind {
        GROUPID,
        ARTIFACTID,
        VERSION;

    }
}

