/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.Bundles;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class MavenEmbeddedRuntime
extends AbstractMavenRuntime {
    private static final String MAVEN_CORE_POM_PROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    private static final String MAVEN_EXECUTOR_CLASS = MavenCli.class.getName();
    public static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static final String M2E_SL4J_BINDING_HEADER = "M2E-SLF4JBinding";
    private List<String> launcherClasspath;
    private List<String> classpath;
    private final String mavenVersion;
    private final Bundle mavenRuntimeBundle;
    private static final List<String> CLASSPATH_CONSIDERED_REQUIREMENT_NAMESPACES = List.of("osgi.wiring.bundle", "osgi.wiring.package");

    public MavenEmbeddedRuntime(Bundle bundle, String name, String version) {
        super(name);
        this.mavenRuntimeBundle = bundle;
        this.mavenVersion = version;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getLocation() {
        return "EMBEDDED";
    }

    @Override
    public boolean isAvailable() {
        return this.mavenRuntimeBundle.getState() >= 4;
    }

    @Override
    public void createLauncherConfiguration(AbstractMavenRuntime.IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
        this.initClasspath();
        collector.addRealm("]launcher");
        for (String entry : this.launcherClasspath) {
            collector.addArchiveEntry(entry);
        }
        collector.addRealm(PLEXUS_CLASSWORLD_NAME);
        this.collectExtensions(collector, monitor);
        for (String entry : this.classpath) {
            if (entry.contains("plexus-build-api")) continue;
            collector.addArchiveEntry(entry);
        }
    }

    private synchronized void initClasspath() {
        if (this.classpath == null) {
            LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
            this.addBundleClasspathEntries(allEntries, this.mavenRuntimeBundle, true);
            allEntries.add(MavenEmbeddedRuntime.getEmbeddedSLF4JBinding(this.mavenRuntimeBundle));
            Set<String> noDependencyBundles = Set.of("org.slf4j.api", "slf4j.api");
            Set<Bundle> bundles = this.getRequiredBundles(this.mavenRuntimeBundle, noDependencyBundles);
            for (Bundle bundle : bundles) {
                this.addBundleClasspathEntries(allEntries, bundle, false);
            }
            ArrayList cp = new ArrayList();
            ArrayList<String> lcp = new ArrayList<String>();
            for (String entry : allEntries) {
                ArrayList<String> path = entry.contains("plexus-classworlds") ? lcp : cp;
                path.add(entry);
            }
            this.classpath = List.copyOf(cp);
            this.launcherClasspath = List.copyOf(lcp);
        }
    }

    private void addBundleClasspathEntries(Set<String> entries, Bundle bundle, boolean addFragments) {
        Bundle[] fragments;
        entries.addAll(Bundles.getClasspathEntries(bundle));
        if (addFragments && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                entries.addAll(Bundles.getClasspathEntries(fragment));
                ++n2;
            }
        }
    }

    private static String getEmbeddedSLF4JBinding(Bundle mavenBundle) {
        String bindingPath = (String)mavenBundle.getHeaders().get(M2E_SL4J_BINDING_HEADER);
        Objects.requireNonNull(bindingPath, () -> "Missing 'M2E-SLF4JBinding' header in embedded Maven-runtime bundle");
        String bindingJarPath = Bundles.getClasspathEntryPath(mavenBundle, bindingPath);
        return Objects.requireNonNull(bindingJarPath, () -> "M2E-SLF4JBinding '" + bindingPath + "' not found");
    }

    private Set<Bundle> getRequiredBundles(Bundle root, Set<String> noDependencyBundles) {
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        ArrayDeque<Bundle> pending = new ArrayDeque<Bundle>();
        pending.add(root);
        while (!pending.isEmpty()) {
            Bundle bundle = (Bundle)pending.remove();
            if (noDependencyBundles.contains(bundle.getSymbolicName())) continue;
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            for (String namespace : CLASSPATH_CONSIDERED_REQUIREMENT_NAMESPACES) {
                for (BundleWire wire : wiring.getRequiredWires(namespace)) {
                    Bundle requiredBundle = wire.getProvider().getBundle();
                    if (requiredBundle.getBundleId() == 0L || !bundles.add(requiredBundle)) continue;
                    pending.add(requiredBundle);
                }
            }
        }
        return bundles;
    }

    public String toString() {
        return this.mavenRuntimeBundle != null ? this.getVersion() + "/" + String.valueOf(this.mavenRuntimeBundle.getVersion()) : "org.eclipse.m2e.maven.runtime";
    }

    @Override
    public synchronized String getVersion() {
        if (this.mavenVersion != null) {
            return this.mavenVersion;
        }
        return Messages.MavenEmbeddedRuntime_unknown;
    }

    public static String getMavenVersionFromBundle(Bundle bundle) {
        BundleWiring bundleWiring;
        if (bundle != null && (bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class)) != null) {
            ClassLoader mavenCL = bundleWiring.getClassLoader();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream stream = mavenCL.getResourceAsStream(MAVEN_CORE_POM_PROPERTIES);){
                    if (stream != null) {
                        Properties pomProperties = new Properties();
                        pomProperties.load(stream);
                        return pomProperties.getProperty("version");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

