/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.os.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.test.lib.process.OutputAnalyzer;

public class HugePageConfiguration {
    Set<ExplicitHugePageConfig> _explicitHugePageConfigurations;
    long _explicitDefaultHugePageSize = -1L;
    THPMode _thpMode;
    long _thpPageSize;
    ShmemTHPMode _shmemThpMode;

    public Set<ExplicitHugePageConfig> getExplicitHugePageConfigurations() {
        return this._explicitHugePageConfigurations;
    }

    public long getExplicitDefaultHugePageSize() {
        return this._explicitDefaultHugePageSize;
    }

    public THPMode getThpMode() {
        return this._thpMode;
    }

    public long getThpPageSize() {
        return this._thpPageSize;
    }

    public long getThpPageSizeOrFallback() {
        long pageSize = this.getThpPageSize();
        if (pageSize != 0L) {
            return pageSize;
        }
        pageSize = this.getExplicitDefaultHugePageSize();
        if (pageSize != 0L) {
            return Math.min(pageSize, 0x1000000L);
        }
        return 0x200000L;
    }

    public boolean supportsTHP() {
        return this._thpMode == THPMode.always || this._thpMode == THPMode.madvise;
    }

    public ShmemTHPMode getShmemThpMode() {
        return this._shmemThpMode;
    }

    public boolean supportsExplicitHugePages() {
        return this._explicitDefaultHugePageSize > 0L && this._explicitHugePageConfigurations.size() > 0;
    }

    public HugePageConfiguration(Set<ExplicitHugePageConfig> explicitHugePageConfigurations, long explicitDefaultHugePageSize, THPMode _thpMode, long _thpPageSize, ShmemTHPMode _shmemThpMode) {
        this._explicitHugePageConfigurations = explicitHugePageConfigurations;
        this._explicitDefaultHugePageSize = explicitDefaultHugePageSize;
        this._thpMode = _thpMode;
        this._thpPageSize = _thpPageSize;
        this._shmemThpMode = _shmemThpMode;
    }

    public String toString() {
        return "Configuration{_explicitHugePageConfigurations=" + String.valueOf(this._explicitHugePageConfigurations) + ", _explicitDefaultHugePageSize=" + this._explicitDefaultHugePageSize + ", _thpMode=" + String.valueOf((Object)this._thpMode) + ", _thpPageSize=" + this._thpPageSize + ", _shmemThpMode=" + String.valueOf((Object)this._shmemThpMode) + "}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._explicitDefaultHugePageSize, this._thpPageSize, this._explicitHugePageConfigurations, this._thpMode, this._shmemThpMode});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HugePageConfiguration that = (HugePageConfiguration)o;
        return this._explicitDefaultHugePageSize == that._explicitDefaultHugePageSize && this._thpPageSize == that._thpPageSize && Objects.equals(this._explicitHugePageConfigurations, that._explicitHugePageConfigurations) && this._thpMode == that._thpMode && this._shmemThpMode == that._shmemThpMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readDefaultHugePageSizeFromOS() {
        Pattern pat = Pattern.compile("Hugepagesize: *(\\d+) +kB");
        try (Scanner scanner = new Scanner(new File("/proc/meminfo"));){
            Matcher mat;
            do {
                if (!scanner.hasNextLine()) return 0L;
            } while (!(mat = pat.matcher(scanner.nextLine())).matches());
            scanner.close();
            long l = Long.parseLong(mat.group(1)) * 1024L;
            return l;
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open /proc/meminfo");
        }
        return 0L;
    }

    private static Set<ExplicitHugePageConfig> readSupportedHugePagesFromOS() throws IOException {
        TreeSet<ExplicitHugePageConfig> hugePageConfigs = new TreeSet<ExplicitHugePageConfig>();
        Pattern pat = Pattern.compile("hugepages-(\\d+)kB");
        File[] subdirs = new File("/sys/kernel/mm/hugepages").listFiles();
        if (subdirs != null) {
            for (File subdir : subdirs) {
                String s;
                BufferedReader reader;
                String name = subdir.getName();
                Matcher mat = pat.matcher(name);
                if (!mat.matches()) continue;
                ExplicitHugePageConfig config = new ExplicitHugePageConfig();
                config.pageSize = Long.parseLong(mat.group(1)) * 1024L;
                try (FileReader fr = new FileReader(subdir.getAbsolutePath() + "/nr_hugepages");){
                    reader = new BufferedReader(fr);
                    try {
                        s = reader.readLine();
                        config.nr_hugepages = Long.parseLong(s);
                    }
                    finally {
                        reader.close();
                    }
                }
                fr = new FileReader(subdir.getAbsolutePath() + "/nr_overcommit_hugepages");
                try {
                    reader = new BufferedReader(fr);
                    try {
                        s = reader.readLine();
                        config.nr_overcommit_hugepages = Long.parseLong(s);
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    fr.close();
                }
                hugePageConfigs.add(config);
            }
        }
        return hugePageConfigs;
    }

    private static THPMode readTHPModeFromOS() {
        THPMode mode;
        block15: {
            mode = THPMode.never;
            String file = "/sys/kernel/mm/transparent_hugepage/enabled";
            try (FileReader fr = new FileReader(file);
                 BufferedReader reader = new BufferedReader(fr);){
                String s = reader.readLine();
                if (s.contains("[never]")) {
                    mode = THPMode.never;
                    break block15;
                }
                if (s.contains("[always]")) {
                    mode = THPMode.always;
                    break block15;
                }
                if (s.contains("[madvise]")) {
                    mode = THPMode.madvise;
                    break block15;
                }
                throw new RuntimeException("Unexpected content of " + file + ": " + s);
            }
            catch (IOException e) {
                System.out.println("Failed to read " + file);
                mode = THPMode.never;
            }
        }
        return mode;
    }

    private static long readTHPPageSizeFromOS() {
        long pagesize = 0L;
        String file = "/sys/kernel/mm/transparent_hugepage/hpage_pmd_size";
        try (FileReader fr = new FileReader(file);
             BufferedReader reader = new BufferedReader(fr);){
            String s = reader.readLine();
            pagesize = Long.parseLong(s);
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return pagesize;
    }

    private static ShmemTHPMode readShmemTHPModeFromOS() {
        ShmemTHPMode mode;
        block18: {
            mode = ShmemTHPMode.unknown;
            String file = "/sys/kernel/mm/transparent_hugepage/shmem_enabled";
            try (FileReader fr = new FileReader(file);
                 BufferedReader reader = new BufferedReader(fr);){
                String s = reader.readLine();
                if (s.contains("[always]")) {
                    mode = ShmemTHPMode.always;
                    break block18;
                }
                if (s.contains("[within_size]")) {
                    mode = ShmemTHPMode.within_size;
                    break block18;
                }
                if (s.contains("[advise]")) {
                    mode = ShmemTHPMode.advise;
                    break block18;
                }
                if (s.contains("[never]")) {
                    mode = ShmemTHPMode.never;
                    break block18;
                }
                if (s.contains("[deny]")) {
                    mode = ShmemTHPMode.deny;
                    break block18;
                }
                if (s.contains("[force]")) {
                    mode = ShmemTHPMode.force;
                    break block18;
                }
                throw new RuntimeException("Unexpected content of " + file + ": " + s);
            }
            catch (IOException e) {
                System.out.println("Failed to read " + file);
            }
        }
        return mode;
    }

    public static HugePageConfiguration readFromOS() throws IOException {
        return new HugePageConfiguration(HugePageConfiguration.readSupportedHugePagesFromOS(), HugePageConfiguration.readDefaultHugePageSizeFromOS(), HugePageConfiguration.readTHPModeFromOS(), HugePageConfiguration.readTHPPageSizeFromOS(), HugePageConfiguration.readShmemTHPModeFromOS());
    }

    public static long parseSIUnit(String num, String unit) {
        long n = Long.parseLong(num);
        return switch (unit) {
            case "K" -> n * 1024L;
            case "M" -> n * 1024L * 1024L;
            case "G" -> n * 1024L * 1024L * 1024L;
            default -> throw new RuntimeException("Invalid unit " + unit);
        };
    }

    public static HugePageConfiguration readFromJVMLog(OutputAnalyzer output) {
        TreeSet<ExplicitHugePageConfig> explicitHugePageConfigs = new TreeSet<ExplicitHugePageConfig>();
        long defaultHugepageSize = 0L;
        THPMode thpMode = THPMode.never;
        ShmemTHPMode shmemThpMode = ShmemTHPMode.unknown;
        long thpPageSize = 0L;
        Pattern patternHugepageSize = Pattern.compile(".*\\[pagesize] *hugepage size: (\\d+)([KMG])");
        Pattern patternDefaultHugepageSize = Pattern.compile(".*\\[pagesize] *default hugepage size: (\\d+)([KMG]) *");
        Pattern patternTHPPageSize = Pattern.compile(".*\\[pagesize] *  THP pagesize: (\\d+)([KMG])");
        Pattern patternTHPMode = Pattern.compile(".*\\[pagesize] *  THP mode: (\\S+)");
        Pattern patternShmemTHPMode = Pattern.compile(".*\\[pagesize] *Shared memory THP mode: (\\S+)");
        List<String> lines = output.asLines();
        for (String s : lines) {
            Matcher mat = patternHugepageSize.matcher(s);
            if (mat.matches()) {
                ExplicitHugePageConfig config = new ExplicitHugePageConfig();
                config.pageSize = HugePageConfiguration.parseSIUnit(mat.group(1), mat.group(2));
                explicitHugePageConfigs.add(config);
                continue;
            }
            if (defaultHugepageSize == 0L && (mat = patternDefaultHugepageSize.matcher(s)).matches()) {
                defaultHugepageSize = HugePageConfiguration.parseSIUnit(mat.group(1), mat.group(2));
                continue;
            }
            if (thpPageSize == 0L && (mat = patternTHPPageSize.matcher(s)).matches()) {
                thpPageSize = HugePageConfiguration.parseSIUnit(mat.group(1), mat.group(2));
                continue;
            }
            mat = patternTHPMode.matcher(s);
            if (mat.matches()) {
                thpMode = THPMode.valueOf(mat.group(1));
            }
            if (!(mat = patternShmemTHPMode.matcher(s)).matches()) continue;
            shmemThpMode = ShmemTHPMode.valueOf(mat.group(1));
        }
        return new HugePageConfiguration(explicitHugePageConfigs, defaultHugepageSize, thpMode, thpPageSize, shmemThpMode);
    }

    public static enum THPMode {
        always,
        never,
        madvise;

    }

    public static enum ShmemTHPMode {
        always,
        within_size,
        advise,
        never,
        deny,
        force,
        unknown;

    }

    public static class ExplicitHugePageConfig
    implements Comparable<ExplicitHugePageConfig> {
        public long pageSize = -1L;
        public long nr_hugepages = -1L;
        public long nr_overcommit_hugepages = -1L;

        public int hashCode() {
            return Objects.hash(this.pageSize);
        }

        public String toString() {
            return "ExplicitHugePageConfig{pageSize=" + this.pageSize + ", nr_hugepages=" + this.nr_hugepages + ", nr_overcommit_hugepages=" + this.nr_overcommit_hugepages + "}";
        }

        @Override
        public int compareTo(ExplicitHugePageConfig o) {
            return (int)(this.pageSize - o.pageSize);
        }
    }
}

