/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.MojoExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;

public class PackagingTypeFilter
implements Predicate<LifecycleMappingMetadata> {
    private final List<LifecycleMappingFilter> filters;

    public PackagingTypeFilter(List<MappingMetadataSource> metadataSources, String packagingType) {
        this.filters = metadataSources.stream().flatMap(s -> s.getFilters().stream()).filter(filter -> filter.getPackagingTypes().contains(packagingType)).toList();
    }

    @Override
    public boolean test(LifecycleMappingMetadata metadata) {
        return MojoExecutionFilter.anyMatch(metadata.getSource(), this.filters);
    }
}

