/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.validation.JSPActionValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPContentValidator;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPActionSourceValidator
extends JSPActionValidator
implements ISourceValidator {
    private IDocument fDocument;
    private boolean fEnableSourceValidation;
    private IContentType fJSPFContentType = null;

    public void connect(IDocument document) {
        this.fDocument = document;
        IFile file = null;
        IStructuredModel model = null;
        try {
            String baseLocation;
            Path basePath;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && (basePath = new Path(baseLocation = model.getBaseLocation())).segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath)).exists()) {
                file = null;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        this.fEnableSourceValidation = file != null && this.isBatchValidatorPreferenceEnabled(file) && this.shouldValidate(file) && this.fragmentCheck(file);
    }

    public void disconnect(IDocument document) {
        this.fDocument = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (helper == null || this.fDocument == null || !this.fEnableSourceValidation) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        if (model == null) {
            return;
        }
        try {
            ITextFileBuffer fb = FileBufferModelManager.getInstance().getBuffer(this.fDocument);
            if (fb == null) {
                return;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fb.getLocation());
            if (file == null || !file.exists()) {
                return;
            }
            this.performValidation(file, reporter, model, dirtyRegion);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private ValidationConfiguration getValidationConfiguration(IFile file) {
        IProject project;
        ProjectConfiguration configuration = null;
        if (file != null && (project = file.getProject()) != null) {
            try {
                ProjectConfiguration projectConfiguration;
                configuration = projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
                if (projectConfiguration == null || projectConfiguration.useGlobalPreference()) {
                    configuration = ConfigurationManager.getManager().getGlobalConfiguration();
                }
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return configuration;
    }

    private boolean isBatchValidatorPreferenceEnabled(IFile file) {
        ValidatorMetaData metadata;
        if (file == null) {
            return true;
        }
        boolean enabled = true;
        ValidationConfiguration configuration = this.getValidationConfiguration(file);
        if (configuration != null && (metadata = ValidationRegistryReader.getReader().getValidatorMetaData(JSPContentValidator.class.getName())) != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
            enabled = false;
        }
        return enabled;
    }

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = Boolean.valueOf(JSPFContentProperties.getProperty((String)"validateFragments", (IResource)file, (boolean)true)).booleanValue())) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFragment(IFile file) {
        boolean isFragment = false;
        InputStream is = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                is = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(is, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            }
            if (contentDescription != null) {
                String fileCtId = contentDescription.getContentType().getId();
                isFragment = fileCtId != null && ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT.equals(fileCtId);
            }
        }
        catch (IOException iOException) {
            if (is == null) return isFragment;
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        catch (CoreException coreException) {
            try {
                if (is == null) return isFragment;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        if (is == null) return isFragment;
        try {
            is.close();
            return isFragment;
        }
        catch (Exception exception) {}
        return isFragment;
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }
}

