/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.api.tools.ui.internal.use.ArchivePatternPage;
import org.eclipse.pde.api.tools.ui.internal.use.DescriptionPatternPage;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.api.tools.ui.internal.use.PatternSelectionPage;
import org.eclipse.pde.api.tools.ui.internal.use.ReportPatternPage;
import org.eclipse.pde.api.tools.ui.internal.use.UsePatternPage;

public class PatternWizard
extends Wizard {
    private String pattern = null;
    private int kind = -1;

    public PatternWizard(String pattern, int kind) {
        this.setWindowTitle(Messages.PatternWizard_use_scan_patterns);
        this.pattern = pattern;
        this.kind = kind;
    }

    public void addPages() {
        if (this.pattern == null) {
            this.addPage((IWizardPage)new PatternSelectionPage());
            this.addPage((IWizardPage)new DescriptionPatternPage(null));
            this.addPage((IWizardPage)new ArchivePatternPage(null));
            this.addPage((IWizardPage)new ReportPatternPage(null, -1));
        } else {
            switch (this.kind) {
                case 1: 
                case 2: {
                    this.addPage((IWizardPage)new DescriptionPatternPage(this.pattern));
                    break;
                }
                case 3: {
                    this.addPage((IWizardPage)new ArchivePatternPage(this.pattern));
                    break;
                }
                case 4: 
                case 5: {
                    this.addPage((IWizardPage)new ReportPatternPage(this.pattern, this.kind));
                    break;
                }
            }
        }
    }

    public boolean performFinish() {
        IWizardPage page = this.getStartingPage();
        UsePatternPage upage = null;
        upage = page instanceof PatternSelectionPage ? (UsePatternPage)this.getPage(((PatternSelectionPage)page).nextPage()) : (UsePatternPage)page;
        this.pattern = upage.getPattern();
        this.kind = upage.getKind();
        return true;
    }

    public boolean canFinish() {
        String name = this.getStartingPage().getName();
        if (!name.equals("select")) {
            return this.getStartingPage().isPageComplete();
        }
        IWizardPage page = this.getStartingPage().getNextPage();
        if (page != null) {
            return page.isPageComplete();
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getKind() {
        return this.kind;
    }
}

