/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class ContentModelGroupSection
extends AbstractSection {
    private final String SEQUENCE = DTDPropertiesMessages._UI_SEQUENCE;
    private final String CHOICE = DTDPropertiesMessages._UI_CHOICE;
    private final String MODEL_GROUP = DTDPropertiesMessages._UI_LABEL_MODEL_GROUP;
    private CCombo modelGroupCombo;
    private String[] modelGroupComboValues = new String[]{this.SEQUENCE, this.CHOICE};

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel cLabel = this.getWidgetFactory().createCLabel(composite, this.MODEL_GROUP);
        Point p = cLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        cLabel.setLayoutData((Object)data);
        this.modelGroupCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment((Control)cLabel, -5);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.modelGroupCombo.setLayoutData((Object)data);
        this.modelGroupCombo.addSelectionListener((SelectionListener)this);
        this.modelGroupCombo.setItems(this.modelGroupComboValues);
    }

    @Override
    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (input != null && input instanceof CMGroupNode) {
            CMGroupNode node = (CMGroupNode)input;
            char modelType = node.getConnector();
            if ('|' == modelType) {
                this.modelGroupCombo.setText(this.CHOICE);
            } else if (',' == modelType) {
                this.modelGroupCombo.setText(this.SEQUENCE);
            }
        }
        this.setListenerEnabled(true);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.modelGroupCombo && (input = this.getInput()) instanceof CMGroupNode) {
            CMGroupNode node = (CMGroupNode)input;
            if (this.CHOICE.equals(this.modelGroupCombo.getText())) {
                node.setConnector('|');
            } else if (this.SEQUENCE.equals(this.modelGroupCombo.getText())) {
                node.setConnector(',');
            }
        }
    }
}

