/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AbstractCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class FunctionFormatter
extends AbstractCSSSourceFormatter {
    FunctionFormatter() {
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        int end;
        ICSSNode prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (start > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = null;
            if (exceptFor == null) {
                regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            } else {
                String pickupType = "DECLARATION_VALUE_OPERATOR";
                if (prev == null || child == null) {
                    pickupType = null;
                }
                regions = this.getRegions(structuredDocument, new FormatRegion(start, end - start), exceptFor, pickupType);
            }
            int i = 0;
            while (i < regions.length) {
                this.appendSpaceBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 2, stgy));
                ++i;
            }
        } else if (prev != null && child != null) {
            source.append(",");
        }
        this.appendSpaceBefore(node, toAppend, source);
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || FunctionFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 2, stgy));
            ++i;
        }
    }

    @Override
    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                this.appendSpaceBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 2, stgy));
                ++i;
            }
        } else {
            source.append(")");
        }
    }

    @Override
    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || FunctionFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 2, stgy));
            ++i;
        }
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end;
        int start = ((IndexedRegion)node).getStartOffset();
        int n = end = node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getFirstChild()).getStartOffset() : this.getChildInsertPos(node);
        if (end > 0) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedPropValueRegion(regions[i], stgy));
                ++i;
            }
        } else {
            String func = this.getFunc();
            if (CSSCorePlugin.getDefault().getPluginPreferences().getInt("propValueCase") == 2) {
                func = func.toUpperCase();
            }
            source.append(func);
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || FunctionFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropValueRegion(regions[i], stgy));
            ++i;
        }
        if (FunctionFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    @Override
    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
            if (flatNode.getRegionAtCharacterOffset(n - 1).getType() == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
                return n - 1;
            }
            return n;
        }
        return -1;
    }

    protected abstract String getFunc();
}

