/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.LocationPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class LocationPredicateImpl
extends PredicateImpl
implements LocationPredicate {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    private Pattern compiledPattern;

    protected LocationPredicateImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.LOCATION_PREDICATE;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPatternGen(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public void setPattern(String newPattern) {
        this.setPatternGen(newPattern);
        this.compiledPattern = null;
    }

    private Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = this.getPattern(this.getPattern());
        }
        return this.compiledPattern;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean matches(IResource resource) {
        IPath location;
        if (resource != null && (location = resource.getLocation()) != null) {
            return this.getCompiledPattern().matcher(location.toPortableString()).matches();
        }
        return false;
    }
}

