/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.java.annotation;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.AbstractManagedAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public class OrderAnnotation
extends AbstractManagedAnnotation {
    protected static final ApiFunction<?, ITypeNameSupplier> TYPE_NAME = new ApiFunction(IScoutApi.class, IScoutAnnotationApi::Order);

    public static double valueOf(IAnnotatable owner, boolean isBean) {
        Optional first = owner.annotations().withManagedWrapper(OrderAnnotation.class).first();
        if (first.isPresent()) {
            return ((OrderAnnotation)((Object)first.orElseThrow())).value();
        }
        if (isBean) {
            return 5000.0;
        }
        return 9.876543212345678E16;
    }

    public static double getNewViewOrderValue(IType declaringType, ITypeNameSupplier orderDefinitionType, int pos) {
        return OrderAnnotation.getNewViewOrderValue(declaringType, orderDefinitionType.fqn(), pos);
    }

    public static double getNewViewOrderValue(IType declaringType, CharSequence orderDefinitionType, int pos) {
        IType[] siblings = OrderAnnotation.findSiblingsAfterPos(declaringType, pos, orderDefinitionType);
        Double orderValueBefore = OrderAnnotation.getOrderAnnotationValue((IAnnotatable)siblings[0]);
        Double orderValueAfter = OrderAnnotation.getOrderAnnotationValue((IAnnotatable)siblings[1]);
        return OrderAnnotation.getNewViewOrderValue(orderValueBefore, orderValueAfter);
    }

    public static double getNewViewOrderValue(Double orderValueBefore, Double orderValueAfter) {
        if (orderValueBefore != null && orderValueAfter == null) {
            double orderValueBeforeAsDouble = orderValueBefore;
            OrderAnnotation.validateOrderRange(orderValueBeforeAsDouble);
            double v = Math.ceil(orderValueBeforeAsDouble / 1000.0) * 1000.0;
            return v + 1000.0;
        }
        if (orderValueBefore == null && orderValueAfter != null) {
            double orderValueAfterAsDouble = orderValueAfter;
            OrderAnnotation.validateOrderRange(orderValueAfterAsDouble);
            double v = Math.floor(orderValueAfterAsDouble / 1000.0) * 1000.0;
            if (v > 1000.0) {
                return 1000.0;
            }
            return v - 1000.0;
        }
        if (orderValueBefore != null && orderValueAfter != null) {
            double a = orderValueBefore;
            double b = orderValueAfter;
            OrderAnnotation.validateOrderRange(a);
            OrderAnnotation.validateOrderRange(b);
            return OrderAnnotation.getOrderValueInBetween(a, b);
        }
        return 1000.0;
    }

    private static void validateOrderRange(double order) {
        if (order > 9.876543212345678E16) {
            NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
            f.setGroupingUsed(false);
            String orderAsString = f.format(order);
            SdkLog.warning((CharSequence)"The @Order value {} is very large and therefore may not be precise enough. It is recommended to use a lower value.", (Object[])new Object[]{orderAsString});
        }
    }

    static Double getOrderAnnotationValue(IAnnotatable sibling) {
        if (sibling == null) {
            return null;
        }
        return OrderAnnotation.valueOf(sibling, false);
    }

    static Iterable<IType> getOrderedInnerTypes(IType declaringType, CharSequence orderDefinitionType) {
        return ((HierarchyInnerTypeQuery)declaringType.innerTypes().withInstanceOf(orderDefinitionType)).stream().filter(candidate -> !Flags.isAbstract((int)candidate.flags()))::iterator;
    }

    static IType[] findSiblingsAfterPos(IType declaringType, int pos, CharSequence orderDefinitionType) {
        IType prev = null;
        for (IType t : OrderAnnotation.getOrderedInnerTypes(declaringType, orderDefinitionType)) {
            if (((SourceRange)t.source().orElseThrow()).start() > pos) {
                return new IType[]{prev, t};
            }
            prev = t;
        }
        return new IType[]{prev, null};
    }

    static double getOrderValueInBetween(double a, double b) {
        double low = Math.min(a, b);
        double high = Math.max(a, b);
        double dif = high - low;
        double lowFloor = Math.floor(low);
        double lowCeil = Math.ceil(low);
        double highFloor = Math.floor(high);
        double nextIntLow = Math.min(lowCeil, highFloor);
        double prevIntHigh = Math.max(lowCeil, highFloor);
        if ((int)low % 1000 == 0 && low + 1000.0 < high) {
            return low + 1000.0;
        }
        if (OrderAnnotation.isDoubleDifferent(lowFloor, highFloor) && (OrderAnnotation.isDoubleDifferent(lowFloor, low) && OrderAnnotation.isDoubleDifferent(highFloor, high) || dif > 1.0)) {
            double intDif = prevIntHigh - nextIntLow;
            if (!OrderAnnotation.isDoubleDifferent(intDif, 1.0)) {
                return prevIntHigh;
            }
            return nextIntLow + Math.floor(intDif / 2.0);
        }
        return low + dif / 2.0;
    }

    static boolean isDoubleDifferent(double d1, double d2) {
        return CoreUtils.isDoubleDifferent((double)d1, (double)d2, (double)1.0E-10);
    }

    public static String convertToJavaSource(double order) {
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        f.setGroupingUsed(false);
        Object newOrderStr = Strings.removeSuffix((String)f.format(order), (CharSequence)".0");
        if (order > 2.147483647E9 && ((String)newOrderStr).indexOf(46) < 0) {
            newOrderStr = (String)newOrderStr + "d";
        }
        return newOrderStr;
    }

    public double value() {
        return (Double)this.getValueFrom(IScoutApi.class, api -> api.Order().valueElementName(), Double.TYPE, null);
    }
}

