/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.universal.IUniversalIntroConstants;
import org.eclipse.ui.internal.intro.universal.UniversalIntroPlugin;

public class Log
implements IUniversalIntroConstants {
    public static final boolean DEBUG = false;
    public static boolean logWarning = false;
    public static boolean logInfo = false;
    public static boolean logPerformance = false;
    private static final ILog pluginLog = UniversalIntroPlugin.getDefault().getLog();

    static {
        if (UniversalIntroPlugin.getDefault().isDebugging()) {
            logWarning = true;
            logInfo = Log.getDebugOption("/trace/logInfo");
            logPerformance = Log.getDebugOption("/trace/logPerformance");
        }
    }

    private static boolean getDebugOption(String option) {
        return "true".equalsIgnoreCase(Platform.getDebugOption((String)("org.eclipse.ui.intro.universal" + option)));
    }

    public static synchronized void error(String message, Throwable ex) {
        pluginLog.error(message, ex);
    }

    public static synchronized void info(String message) {
        if (!logInfo) {
            return;
        }
        pluginLog.info(message);
    }

    public static synchronized void forcedInfo(String message) {
        pluginLog.info(message);
    }

    public static synchronized void warning(String message) {
        if (!logWarning) {
            return;
        }
        pluginLog.warn(message);
    }

    public static synchronized void debugMessage(String className, String message) {
    }
}

