/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ShowRefactoringHistoryWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public final class ShowRefactoringHistoryAction
implements IWorkbenchWindowActionDelegate {
    private static final int SIZING_WIZARD_HEIGHT = 560;
    private static final int SIZING_WIZARD_WIDTH = 480;
    private IWorkbenchWindow fWindow = null;

    private static void showRefactoringHistoryWizard(IWorkbenchWindow window) {
        Assert.isNotNull((Object)window);
        ShowRefactoringHistoryWizard wizard = new ShowRefactoringHistoryWizard();
        IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (context == null) {
            context = PlatformUI.getWorkbench().getProgressService();
        }
        try {
            context.run(false, true, monitor -> {
                IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                try {
                    service.connect();
                    wizard.setRefactoringHistory(service.getWorkspaceHistory(monitor));
                }
                finally {
                    service.disconnect();
                }
            });
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
        }
        catch (InterruptedException exception) {
            return;
        }
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard){

            protected final void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.getButton(16).setText(IDialogConstants.OK_LABEL);
            }
        };
        dialog.create();
        dialog.getShell().setSize(Math.max(480, dialog.getShell().getSize().x), 560);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.refactoring_show_history_page");
        dialog.open();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow != null) {
            ShowRefactoringHistoryAction.showRefactoringHistoryWizard(this.fWindow);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

