/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.css.sac;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.css.sac.AbstractSACParserFactory;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.w3c.css.sac.Parser;

public final class SACParserFactory
extends AbstractSACParserFactory {
    private static Map<String, @Nullable String> parsers = new HashMap<String, String>();

    static {
        SACParserFactory.registerSACParser("org.w3c.flute.parser.Parser");
        SACParserFactory.registerSACParser("org.w3c.flute.parser.CSS3Parser");
        SACParserFactory.registerSACParser("com.steadystate.css.parser.SACParser");
        SACParserFactory.registerSACParser("org.apache.batik.css.parser.Parser");
    }

    public SACParserFactory() {
        super.setPreferredParserName("org.apache.batik.css.parser.Parser");
    }

    @Override
    public Parser makeParser(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException {
        String classNameParser = parsers.get(name);
        if (classNameParser != null) {
            Class<?> classParser = NullSafetyHelper.castNonNull(super.getClass().getClassLoader()).loadClass(classNameParser);
            try {
                return (Parser)classParser.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                throw (InstantiationException)new InstantiationException().initCause(ex);
            }
        }
        throw new IllegalAccessException("SAC parser with name=" + name + " was not registered into SAC parser factory.");
    }

    private static void registerSACParser(String parser) {
        SACParserFactory.registerSACParser(parser, parser);
    }

    private static void registerSACParser(String name, String classNameParser) {
        parsers.put(name, classNameParser);
    }
}

