/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskRepositoryPropertyTester
extends PropertyTester {
    private static final String PROPERTY_CONNECTOR_KIND = "connectorKind";
    private static final String PROPERTY_USER_MANAGED = "userManaged";
    private static final String PROPERTY_DISCONNECTED = "disconnected";

    private boolean equals(boolean value, Object expectedValue) {
        return Boolean.valueOf(value).equals(expectedValue);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof TaskRepository) {
            TaskRepository repository = (TaskRepository)receiver;
            if (PROPERTY_CONNECTOR_KIND.equals(property)) {
                return repository.getConnectorKind().equals(expectedValue);
            }
            if (PROPERTY_USER_MANAGED.equals(property)) {
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                return this.equals(connector != null && connector.isUserManaged(), expectedValue);
            }
            if (PROPERTY_DISCONNECTED.equals(property)) {
                return this.equals(!repository.isOffline(), expectedValue);
            }
        }
        return false;
    }
}

