/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.xsl.ui.internal.Messages;

class NewXSLFileWizardPage
extends WizardNewFileCreationPage {
    private static final String XSLExtension = ".xsl";
    private IContentType fContentType;
    private List fValidExtensions = null;

    public NewXSLFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setFileName(this.getUnusedFilename("NewStylesheet", selection));
    }

    private String getUnusedFilename(String prefix, IStructuredSelection selection) {
        String name = String.valueOf(prefix) + XSLExtension;
        if (selection.isEmpty()) {
            return name;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IContainer) {
            IContainer c = (IContainer)element;
            int i = 0;
            while (true) {
                if (c.findMember(name) == null) {
                    return name;
                }
                name = String.valueOf(prefix) + ++i + XSLExtension;
            }
        }
        return null;
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)Messages.NewXSLFileWizardExtensionError, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(Messages.NewXSLFileAlreadExistsError);
                    return false;
                }
            }
        }
        return true;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        String ext = "xsl";
        newFileName.append(".");
        newFileName.append(ext);
        return newFileName.toString();
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.xml.core.xslsource");
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }
}

