/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyWSDLCommand
extends AbstractDataModelOperation {
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String destinationURI;
    private Definition def;
    private Vector ignoreList;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        CopyWSDLRunnable copyWSDLRunnable = new CopyWSDLRunnable(env);
        try {
            ResourceUtils.getWorkspace().run((IWorkspaceRunnable)copyWSDLRunnable, null);
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    private void copyWSDL(IEnvironment env, String uri, String destURI, String destLocalname) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        try {
            Definition definition = this.webServicesParser.getWSDLDefinitionVerbose(uri);
            this.copyWSDL(env, uri, destURI, destLocalname, definition);
        }
        catch (WSDLException wSDLException) {
            this.copyXMLSchema(env, uri, destURI);
        }
    }

    private void copyWSDL(IEnvironment env, String uri, String destURI, String destLocalname, Definition definition) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        if (!this.needToCopy(uri = this.normalize(uri))) {
            return;
        }
        destURI = this.normalize(destURI);
        String baseURI = this.getBaseURI(uri);
        if (destLocalname == null || destLocalname.length() <= 0) {
            destLocalname = this.getLocalname(uri);
        }
        StringBuffer destinationFileURI = new StringBuffer(this.addTrailingSeparator(destURI));
        destinationFileURI.append(destLocalname);
        WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        OutputStream os = env.getURIFactory().newURI(destinationFileURI.toString()).getOutputStream();
        wsdlWriter.writeWSDL(definition, os);
        os.close();
        Map imports = definition.getImports();
        for (List list : imports.values()) {
            for (Import wsdlImport : list) {
                String wsdlImportURI = wsdlImport.getLocationURI();
                if (!this.isRelative(wsdlImportURI)) continue;
                String importBaseURI = new StringBuffer(baseURI).append(wsdlImportURI).toString();
                String wsdlImportBaseURI = this.getBaseURI(wsdlImportURI);
                StringBuffer importDestURI = new StringBuffer(destURI);
                if (wsdlImportBaseURI != null) {
                    importDestURI.append(wsdlImportBaseURI);
                }
                this.copyWSDL(env, importBaseURI, importDestURI.toString(), this.getLocalname(wsdlImportURI));
            }
        }
        Types types = definition.getTypes();
        if (types != null) {
            List schemas = types.getExtensibilityElements();
            for (ExtensibilityElement extElement : schemas) {
                XSDSchema xsdSchema;
                UnknownExtensibilityElement schemaElement;
                if (extElement instanceof UnknownExtensibilityElement) {
                    schemaElement = (UnknownExtensibilityElement)extElement;
                    xsdSchema = null;
                    try {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    }
                    catch (Throwable throwable) {}
                    this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
                } else if (extElement instanceof XSDSchemaExtensibilityElementImpl) {
                    schemaElement = (XSDSchemaExtensibilityElementImpl)extElement;
                    xsdSchema = null;
                    try {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    }
                    catch (Throwable throwable) {}
                    this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
                }
                if (!(extElement instanceof Schema)) continue;
                schemaElement = (Schema)extElement;
                xsdSchema = null;
                try {
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                }
                catch (Throwable throwable) {}
                this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
            }
        }
    }

    private String getBaseURI(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(0, index + 1);
        }
        return null;
    }

    private String getLocalname(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(index + 1);
        }
        return uri;
    }

    private String addTrailingSeparator(String s) {
        if (!s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    private boolean isRelative(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void copyXMLSchema(IEnvironment env, String uri, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (!this.needToCopy(uri = this.normalize(uri))) {
            return;
        }
        destURI = this.normalize(destURI);
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)uri);
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream((String)uri);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        if (xsdSchema != null) {
            Element e = xsdSchema.getElement();
            DOMSource domSource = new DOMSource(e);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            OutputStream os = env.getURIFactory().newURI(new StringBuffer(destURI).append(this.getLocalname(uri)).toString()).getOutputStream();
            serializer.transform(domSource, new StreamResult(os));
            os.close();
            this.copyXMLSchema(env, xsdSchema, this.getBaseURI(uri), destURI);
        }
    }

    private void copyXMLSchema(IEnvironment env, XSDSchema xsdSchema, String baseURI, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            for (Object content : xsdSchemaContents) {
                XSDSchemaDirective xsdSchemaDirective;
                String xsdSchemaDirectiveLocation;
                if (!(content instanceof XSDSchemaDirective) || (xsdSchemaDirectiveLocation = (xsdSchemaDirective = (XSDSchemaDirective)content).getSchemaLocation()) == null || !this.isRelative(xsdSchemaDirectiveLocation)) continue;
                String directiveURI = new StringBuffer(baseURI).append(xsdSchemaDirectiveLocation).toString();
                String directiveBaseURI = this.getBaseURI(xsdSchemaDirectiveLocation);
                StringBuffer directiveDestURI = new StringBuffer(destURI);
                if (directiveBaseURI != null) {
                    directiveDestURI.append(directiveBaseURI);
                }
                this.copyXMLSchema(env, directiveURI, directiveDestURI.toString());
            }
        }
    }

    private boolean needToCopy(String normalizedURI) {
        if (this.ignoreList.contains(normalizedURI)) {
            return false;
        }
        this.ignoreList.add(normalizedURI);
        return true;
    }

    private String normalize(String uri) {
        boolean normalized = false;
        while (!normalized) {
            int dir = uri.indexOf("/..");
            if (dir == -1) {
                normalized = true;
                continue;
            }
            String first = uri.substring(0, dir);
            String second = uri.substring(dir + 3);
            int newIndex = first.lastIndexOf("/");
            if (newIndex == -1) {
                normalized = true;
                continue;
            }
            first = first.substring(0, newIndex);
            uri = String.valueOf(first) + second;
        }
        return uri;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDestinationURI(String destinationURI) {
        this.destinationURI = destinationURI;
    }

    public void setDefinition(Definition def) {
        this.def = def;
    }

    private class CopyWSDLRunnable
    implements IWorkspaceRunnable {
        private IEnvironment environment = null;

        protected CopyWSDLRunnable(IEnvironment env) {
            this.environment = env;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            CopyWSDLCommand.this.ignoreList = new Vector();
            if (CopyWSDLCommand.this.def == null) {
                CopyWSDLCommand.this.def = CopyWSDLCommand.this.webServicesParser.getWSDLDefinition(CopyWSDLCommand.this.wsdlURI);
            }
            try {
                CopyWSDLCommand.this.copyWSDL(this.environment, CopyWSDLCommand.this.wsdlURI, CopyWSDLCommand.this.getBaseURI(CopyWSDLCommand.this.destinationURI), CopyWSDLCommand.this.getLocalname(CopyWSDLCommand.this.destinationURI), CopyWSDLCommand.this.def);
            }
            catch (Throwable e) {
                throw new CoreException(StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_COPY_WSDL, (Object[])new String[]{CopyWSDLCommand.this.wsdlURI, CopyWSDLCommand.this.destinationURI}), (Throwable)e));
            }
        }
    }
}

