/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.StringTokenizer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpaJpqlHyperlinkBuilder;
import org.eclipse.persistence.jpa.jpql.BaseDeclarationIdentificationVariableFinder;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

public class GenericJpaJpqlHyperlinkBuilder
extends JpaJpqlHyperlinkBuilder {
    private RangeVariableDeclarationVisitor rangeVariableDeclarationVisitor;

    public GenericJpaJpqlHyperlinkBuilder(JpaJpqlQueryHelper queryHelper, NamedQuery namedQuery, QueryPosition queryPosition) {
        super(queryHelper, namedQuery, queryPosition);
    }

    protected RangeVariableDeclarationVisitor buildRangeVariableDeclarationVisitor() {
        return new RangeVariableDeclarationVisitor();
    }

    protected final IdentificationVariable findVirtualIdentificationVariable(AbstractSchemaName expression) {
        BaseDeclarationIdentificationVariableFinder visitor = new BaseDeclarationIdentificationVariableFinder();
        expression.accept((ExpressionVisitor)visitor);
        return visitor.expression;
    }

    protected final boolean isRangeVariableDeclaration(Expression expression) {
        RangeVariableDeclarationVisitor visitor = this.rangeVariableDeclarationVisitor();
        expression.accept((ExpressionVisitor)visitor);
        try {
            boolean bl = visitor.rangeVariableDeclaration;
            return bl;
        }
        finally {
            visitor.rangeVariableDeclaration = false;
        }
    }

    protected final RangeVariableDeclarationVisitor rangeVariableDeclarationVisitor() {
        if (this.rangeVariableDeclarationVisitor == null) {
            this.rangeVariableDeclarationVisitor = this.buildRangeVariableDeclarationVisitor();
        }
        return this.rangeVariableDeclarationVisitor;
    }

    public void visit(AbstractSchemaName expression) {
        String text = expression.getText();
        Entity entity = this.getEntityNamed(text);
        if (entity != null) {
            if (entity.getMappingFileRoot() == null) {
                IType type = this.getType(entity.getPersistentType().getName());
                this.addOpenDeclarationHyperlink(type, this.buildRegion((Expression)expression));
            }
        } else {
            IType type = this.getType(text);
            if (type.isResolvable()) {
                this.addOpenDeclarationHyperlink(type, this.buildRegion((Expression)expression));
            } else {
                this.visitDerivedPathExpression(expression);
            }
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        if (!expression.startsWithDot() && this.isRangeVariableDeclaration((Expression)expression)) {
            IType type = this.getType(expression.toActualText());
            if (type.isResolvable()) {
                this.addOpenDeclarationHyperlink(type, this.buildRegion((Expression)expression));
            } else {
                this.visitPathExpression((AbstractPathExpression)expression);
            }
        } else {
            this.visitPathExpression((AbstractPathExpression)expression);
        }
    }

    public void visit(ConstructorExpression expression) {
        IType type;
        String className = expression.getClassName();
        int length = className.length();
        int startOffset = 3 + (expression.hasSpaceAfterNew() ? 1 : 0);
        int startPosition = expression.getOffset() + startOffset;
        int endPosition = startPosition + length;
        int position = this.getPosition();
        if (position >= startPosition && position <= endPosition && (type = this.getType(className)).isResolvable()) {
            IRegion region = this.buildRegion((Expression)expression, startOffset, length);
            this.addOpenDeclarationHyperlink(type, region);
        }
    }

    public void visit(EntityTypeLiteral expression) {
        String text = expression.getEntityTypeName();
        Entity entity = this.getEntityNamed(text);
        if (entity != null) {
            IType type = this.getType(entity.getPersistentType().getName());
            this.addOpenDeclarationHyperlink(type, this.buildRegion((Expression)expression));
        }
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitPathExpression((AbstractPathExpression)expression);
    }

    protected void visitDerivedPathExpression(AbstractSchemaName expression) {
        String text = expression.getText();
        int position = this.getPosition();
        int offset = expression.getOffset();
        int length = 0;
        Resolver resolver = null;
        if (text.indexOf(".") == -1) {
            String variableName;
            IdentificationVariable identificationVariable = this.findVirtualIdentificationVariable(expression);
            String string = variableName = identificationVariable != null ? identificationVariable.getText() : null;
            if (StringTools.isBlank((String)variableName)) {
                return;
            }
            resolver = this.getQueryContext().getResolver(variableName);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, ".");
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            if (resolver == null) {
                if (position <= offset + length + 1) {
                    return;
                }
                resolver = this.getQueryContext().getDeclarationResolver().getChild(path);
                if (resolver == null) {
                    break;
                }
            } else {
                IMapping mapping;
                Resolver childResolver = resolver.getChild(path);
                if (childResolver == null) {
                    childResolver = new StateFieldResolver(resolver, path);
                    resolver.addChild(path, childResolver);
                }
                if ((mapping = childResolver.getMapping()) == null) break;
                if (position <= offset + length + path.length()) {
                    this.addFieldHyperlinks((Expression)expression, mapping, length);
                    break;
                }
                resolver = childResolver;
            }
            length += path.length() + 1;
        }
    }

    protected void visitPathExpression(AbstractPathExpression expression) {
        if (expression.startsWithDot()) {
            return;
        }
        int position = this.getPosition();
        int offset = expression.getOffset();
        String fullPath = expression.toActualText();
        IType enumType = this.getQueryContext().getTypeRepository().getEnumType(fullPath);
        if (enumType != null) {
            int stopIndex = expression.pathSize() - 1;
            String enumConstant = expression.getPath(stopIndex);
            int enumTypeLength = expression.toParsedText(0, stopIndex).length();
            if (position <= offset + enumTypeLength) {
                this.addOpenDeclarationHyperlink(enumType, this.buildRegion((Expression)expression, 0, enumTypeLength));
            } else {
                String[] stringArray = enumType.getEnumConstants();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String constantName = stringArray[n2];
                    if (enumConstant.equals(constantName)) {
                        this.addFieldHyperlinks((Expression)expression, enumType, enumType, constantName, enumTypeLength + 1);
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            Resolver resolver;
            Expression identificationVariable = expression.getIdentificationVariable();
            int length = 0;
            if (!expression.hasVirtualIdentificationVariable()) {
                String variable = identificationVariable.toActualText();
                length = variable.length();
                if (position <= offset + length + 1) {
                    return;
                }
                ++length;
            }
            if ((resolver = this.getQueryContext().getResolver(identificationVariable)) == null) {
                return;
            }
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = expression.pathSize();
            while (index < count) {
                IMapping mapping;
                String path = expression.getPath(index);
                Resolver childResolver = resolver.getChild(path);
                if (childResolver == null) {
                    childResolver = new StateFieldResolver(resolver, path);
                    resolver.addChild(path, childResolver);
                }
                if ((mapping = childResolver.getMapping()) == null) break;
                if (position <= offset + length + path.length()) {
                    this.addFieldHyperlinks((Expression)expression, mapping, length);
                    break;
                }
                length += path.length() + 1;
                resolver = childResolver;
                ++index;
            }
        }
    }

    protected class RangeVariableDeclarationVisitor
    extends AbstractTraverseParentVisitor {
        protected boolean rangeVariableDeclaration;

        protected RangeVariableDeclarationVisitor() {
        }

        public void visit(RangeVariableDeclaration expression) {
            this.rangeVariableDeclaration = true;
        }
    }
}

