/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1008
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1008(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            String action;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionFailException("notApplicable");
            }
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionFailException();
            }
            if (this.validator.isFault(doc)) {
                throw new AssertionFailException("notApplicable");
            }
            if (!this.validator.containsSoapBodyWithChild(doc)) {
                throw new AssertionNotApplicableException();
            }
            Document docRequest = entryContext.getRequestDocument();
            OperationSignature.OperationMatch match = OperationSignature.matchOperation(docRequest, action = this.validator.getSoapAction(entryContext.getRequest().getHTTPHeaders()), binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator));
            if (match == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = match.getOperation();
            if (!"rpc".equals(match.getOperationStyle())) {
                throw new AssertionFailException("notApplicable");
            }
            NodeList soapBodyList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (soapBodyList.getLength() == 0 || soapBodyList.getLength() > 1) {
                throw new AssertionFailException();
            }
            Element soapBodyElem = (Element)soapBodyList.item(0);
            this.result = null;
            Element soapOperation = XMLUtils.getFirstChild(soapBodyElem);
            if (soapOperation == null) {
                throw new AssertionFailException();
            }
            Message operationMessage = null;
            List extElements = null;
            if ("request".equals(entryContext.getMessageEntry().getType())) {
                operationMessage = bindingOperation.getOperation().getInput().getMessage();
                if (bindingOperation.getBindingInput() != null) {
                    extElements = bindingOperation.getBindingInput().getExtensibilityElements();
                }
            } else if ("response".equals(entryContext.getMessageEntry().getType())) {
                operationMessage = bindingOperation.getOperation().getOutput().getMessage();
                if (bindingOperation.getBindingOutput() != null) {
                    extElements = bindingOperation.getBindingOutput().getExtensibilityElements();
                }
            }
            if (!this.validator.isLiteral(extElements)) {
                throw new AssertionFailException("notApplicable");
            }
            Element soapMessagePart = XMLUtils.getFirstChild(soapOperation);
            if (soapMessagePart == null) {
                throw new AssertionPassException();
            }
            while (true) {
                if (soapMessagePart == null) {
                    this.result = "passed";
                    break;
                }
                if (soapMessagePart.getNamespaceURI() != null || "".equals(soapMessagePart.getNamespaceURI())) {
                    throw new AssertionFailException();
                }
                String typesTargetNS = this.getTypeNS(operationMessage, soapMessagePart.getLocalName());
                if (typesTargetNS == null) {
                    throw new AssertionFailException();
                }
                if (!this.checkChildrenNamespace(soapMessagePart, typesTargetNS)) {
                    throw new AssertionFailException();
                }
                soapMessagePart = XMLUtils.getNextSibling(soapMessagePart);
            }
        }
        catch (AssertionFailException e) {
            this.result = e.getMessage() != null && e.getMessage().length() > 0 ? e.getMessage() : "failed";
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result == "failed") {
            this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getTypeNS(Message message, String partName) {
        Part part = message.getPart(partName);
        if (part == null) {
            return null;
        }
        return part.getTypeName().getNamespaceURI();
    }

    private boolean checkChildrenNamespace(Element node, String typesTargetNS) {
        NodeList parts = node.getElementsByTagName("*");
        int i = 0;
        while (i < parts.getLength()) {
            Element part = (Element)parts.item(i);
            if (!typesTargetNS.equals(part.getNamespaceURI())) {
                return false;
            }
            if (!this.checkChildrenNamespace(part, typesTargetNS)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

