/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

public enum DSAnnotationVersion {
    V1_0("1.0", "http://www.osgi.org/xmlns/scr/v1.0.0"),
    V1_1("1.1", "http://www.osgi.org/xmlns/scr/v1.1.0"),
    V1_2("1.2", "http://www.osgi.org/xmlns/scr/v1.2.0"),
    V1_3("1.3", "http://www.osgi.org/xmlns/scr/v1.3.0"),
    V1_4("1.4", "http://www.osgi.org/xmlns/scr/v1.4.0"),
    V1_5("1.5", "http://www.osgi.org/xmlns/scr/v1.5.0");

    public static final DSAnnotationVersion DEFAULT_VERSION;
    private final String namespace;
    private final String version;

    static {
        DEFAULT_VERSION = V1_4;
    }

    private DSAnnotationVersion(String version, String namespace) {
        this.version = version;
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DSAnnotationVersion max(DSAnnotationVersion other) {
        if (this.compareTo(other) < 0) {
            return other;
        }
        return this;
    }

    public boolean isEqualOrHigherThan(DSAnnotationVersion other) {
        return other.compareTo(this) >= 0;
    }

    public static DSAnnotationVersion fromNamespace(String namespace) {
        DSAnnotationVersion[] dSAnnotationVersionArray = DSAnnotationVersion.values();
        int n = dSAnnotationVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DSAnnotationVersion value = dSAnnotationVersionArray[n2];
            if (value.namespace.equals(namespace)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public String getSpecificationVersion() {
        return this.version;
    }

    public String toString() {
        return this.version + " - " + this.namespace;
    }
}

