/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlFactory;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class AuthorizationIdentifierASALoader {
    protected AuthorizationIdentifier authId;
    protected Connection conn;
    protected ICatalogObject catalogObj;

    public AuthorizationIdentifierASALoader(AuthorizationIdentifier catalogAuthId) {
        this.authId = catalogAuthId;
        this.catalogObj = (ICatalogObject)catalogAuthId;
        this.conn = this.catalogObj.getConnection();
    }

    public final void loadPrivilegs(EList privileges) {
        boolean deliver = this.authId.eDeliver();
        this.authId.eSetDeliver(false);
        privileges.clear();
        this.loadTablePrivilegs((List)privileges);
        this.loadTableColumnPrivilege((List)privileges);
        this.loadRoutinePrivileges((List)privileges);
        this.authId.eSetDeliver(deliver);
    }

    public final void loadAuthInfo() {
        boolean deliver;
        block6: {
            deliver = this.authId.eDeliver();
            this.authId.eSetDeliver(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("select remarks from sysuserperms where user_name = ?");
                    stmt.setString(1, this.authId.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String remarks = rs.getString(1);
                        this.authId.setDescription(remarks);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.authId.eSetDeliver(deliver);
    }

    protected void loadTableColumnPrivilege(List privileges) {
        block11: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("SELECT TRIM(T.table_name) as table_name, TRIM(U.user_name) as Table_Owner, TRIM(C.column_name), P.privilege_type, P.is_grantable, G.user_name as Grantor FROM sys.systable T join sys.SYSUSERPERMS U on T.creator = U.user_id join sys.syscolperm P on P.table_id = T.table_id join sys.sysuserperms E on P.grantee = E.user_id and E.user_name = ? join sys.syscolumn C on  C.table_id = T.table_id and C.column_id = P.column_id join sysuserperms G on G.user_id = P.grantor");
                    stmt.setString(1, this.authId.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        String ownerName = rs.getString(2);
                        String columnName = rs.getString(3);
                        int privilegeType = rs.getInt(4);
                        boolean isGrantable = rs.getString(5).equals("Y");
                        String grantorName = rs.getString(6);
                        Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), ownerName);
                        Table table = (Table)SybaseASACatalogUtils.findElement((Collection)schema.getTables(), tableName);
                        Column col = (Column)SybaseASACatalogUtils.findElement((Collection)table.getColumns(), columnName);
                        SybasePrivilege p = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
                        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName);
                        String action = null;
                        switch (privilegeType) {
                            case 1: {
                                action = "select";
                                break;
                            }
                            case 8: {
                                action = "update";
                                break;
                            }
                            case 16: {
                                action = "reference";
                            }
                        }
                        p.setAction(action);
                        p.setGrantable(isGrantable);
                        p.setObject((SQLObject)col);
                        p.setGrantor(grantor);
                        p.setGrantee(this.authId);
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    protected void loadRoutinePrivileges(List privileges) {
        block6: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("SELECT TRIM(F.proc_name) as proc_name, TRIM(U.user_name) as user_name, IFNULL( R.parm_id, 'N', 'Y' ) AS \"function\", IFNULL( P.grantee, 'N', 'Y' ) AS executeauth FROM SYS.SYSPROCEDURE F JOIN SYS.SYSUSERPERMS U ON U.user_id = F.creator LEFT OUTER JOIN SYS.SYSPROCPARM R ON R.proc_id = F.proc_id AND R.parm_type = 4 LEFT OUTER JOIN SYS.SYSUSERPERMS E ON E.user_name = ? LEFT OUTER JOIN SYS.SYSPROCPERM P ON P.proc_id = F.proc_id AND P.grantee = E.user_id ORDER BY F.proc_name, U.user_name");
                    stmt.setString(1, this.authId.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String routineName = rs.getString(1);
                        String ownerName = rs.getString(2);
                        boolean isExcutable = rs.getString(4).equals("Y");
                        if (!isExcutable) continue;
                        Privilege p = SQLAccessControlFactory.eINSTANCE.createPrivilege();
                        Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), ownerName);
                        Routine r = (Routine)SybaseASACatalogUtils.findElement((Collection)schema.getRoutines(), routineName);
                        p.setObject((SQLObject)r);
                        p.setAction("execute");
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    protected void loadTablePrivilegs(List privileges) {
        block11: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("SELECT TRIM(T.table_name) as table_name, TRIM(U.user_name) AS Table_Owner, P.selectauth, P.insertauth, P.deleteauth, P.updateauth, P.alterauth, P.referenceauth, G.user_name as Grantor, P.updatecols, P.stable_id FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator LEFT OUTER JOIN SYS.SYSUSERPERMS E ON E.user_name = ? LEFT OUTER JOIN SYS.SYSTABLEPERM P ON P.stable_id = T.table_id AND P.grantee = E.user_id LEFT JOIN SYS.SYSUSERPERMS G ON P.grantor = G.user_id where P.stable_id <> null ORDER BY T.table_name, U.user_name");
                    stmt.setString(1, this.authId.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Privilege p;
                        String tableName = rs.getString(1);
                        String tableOwner = rs.getString(2);
                        char selectAuth = SybaseASACatalogUtils.getCharValue(rs.getString(3));
                        char insertAuth = SybaseASACatalogUtils.getCharValue(rs.getString(4));
                        char deleteAuth = SybaseASACatalogUtils.getCharValue(rs.getString(5));
                        char updateAuth = SybaseASACatalogUtils.getCharValue(rs.getString(6));
                        char alterAuth = SybaseASACatalogUtils.getCharValue(rs.getString(7));
                        char referenceAuth = SybaseASACatalogUtils.getCharValue(rs.getString(8));
                        String grantorName = rs.getString(9);
                        SybaseASACatalogUtils.getCharValue(rs.getString(10));
                        SQLObject obj = null;
                        if (selectAuth == 'Y' || selectAuth == 'G') {
                            p = this.createTablePrivilege(selectAuth, "select", grantorName, tableOwner, tableName, obj);
                            privileges.add(p);
                        }
                        if (insertAuth == 'Y' || insertAuth == 'G') {
                            p = this.createTablePrivilege(insertAuth, "insert", grantorName, tableOwner, tableName, obj);
                            privileges.add(p);
                        }
                        if (deleteAuth == 'Y' || deleteAuth == 'G') {
                            p = this.createTablePrivilege(deleteAuth, "delete", grantorName, tableOwner, tableName, obj);
                            privileges.add(p);
                        }
                        if (updateAuth == 'Y' || updateAuth == 'G') {
                            p = this.createTablePrivilege(updateAuth, "update", grantorName, tableOwner, tableName, obj);
                            privileges.add(p);
                        }
                        if (alterAuth == 'Y' || alterAuth == 'G') {
                            p = this.createTablePrivilege(alterAuth, "alter", grantorName, tableOwner, tableName, obj);
                            privileges.add(p);
                        }
                        if (referenceAuth != 'Y' && referenceAuth != 'G') continue;
                        p = this.createTablePrivilege(referenceAuth, "reference", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    private Privilege createTablePrivilege(char authChar, String action, String grantorName, String tableOwner, String tableName, SQLObject obj) {
        SybasePrivilege result = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
        result.setGrantable(authChar == 'G');
        result.setAction(action);
        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName);
        result.setGrantor(grantor);
        result.setGrantee(this.authId);
        if (obj == null) {
            obj = this.findSQLObject(tableOwner, tableName, true);
        }
        result.setObject(obj);
        return result;
    }

    private SQLObject findSQLObject(String tableOwner, String tableName, boolean isTable) {
        Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), tableOwner);
        SQLObject result = null;
        result = isTable ? (SQLObject)SybaseASACatalogUtils.findElement((Collection)schema.getTables(), tableName) : (SQLObject)SybaseASACatalogUtils.findElement((Collection)schema.getRoutines(), tableName);
        return result;
    }
}

