/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DispatcherType implements Enumerator
{
    FORWARD_LITERAL(0, "FORWARD", "FORWARD"),
    INCLUDE_LITERAL(1, "INCLUDE", "INCLUDE"),
    REQUEST_LITERAL(2, "REQUEST", "REQUEST"),
    ASYNC_LITERAL(3, "ASYNC", "ASYNC"),
    ERROR_LITERAL(4, "ERROR", "ERROR");

    public static final int FORWARD = 0;
    public static final int INCLUDE = 1;
    public static final int REQUEST = 2;
    public static final int ASYNC = 3;
    public static final int ERROR = 4;
    private static final DispatcherType[] VALUES_ARRAY;
    public static final List<DispatcherType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DispatcherType[]{FORWARD_LITERAL, INCLUDE_LITERAL, REQUEST_LITERAL, ASYNC_LITERAL, ERROR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DispatcherType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DispatcherType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DispatcherType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DispatcherType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DispatcherType get(int value) {
        switch (value) {
            case 0: {
                return FORWARD_LITERAL;
            }
            case 1: {
                return INCLUDE_LITERAL;
            }
            case 2: {
                return REQUEST_LITERAL;
            }
            case 3: {
                return ASYNC_LITERAL;
            }
            case 4: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private DispatcherType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

