/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.breakpoints.provisional.OtherBreakpointCategory;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BreakpointsContentProvider
implements ITreeContentProvider,
IPropertyChangeListener {
    private IBreakpointOrganizer[] fOrganizers = null;
    private BreakpointsViewer fViewer;
    private Object[] fElements;
    private boolean fDisposed = false;

    public Object[] getChildren(Object parentElement) {
        if (parentElement.equals(DebugPlugin.getDefault().getBreakpointManager())) {
            return this.fElements;
        }
        if (parentElement instanceof BreakpointContainer) {
            return ((BreakpointContainer)parentElement).getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDisposed = true;
        this.fElements = null;
        this.setOrganizers(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (BreakpointsViewer)viewer;
        if (newInput != null) {
            this.reorganize();
        }
    }

    public void setOrganizers(IBreakpointOrganizer[] organizers) {
        IBreakpointOrganizer organizer;
        int n;
        int n2;
        IBreakpointOrganizer[] iBreakpointOrganizerArray;
        if (this.fOrganizers != null) {
            iBreakpointOrganizerArray = this.fOrganizers;
            n2 = this.fOrganizers.length;
            n = 0;
            while (n < n2) {
                organizer = iBreakpointOrganizerArray[n];
                organizer.removePropertyChangeListener(this);
                ++n;
            }
        }
        this.fOrganizers = organizers;
        if (organizers != null && organizers.length == 0) {
            this.fOrganizers = null;
        }
        if (this.fOrganizers != null) {
            iBreakpointOrganizerArray = this.fOrganizers;
            n2 = this.fOrganizers.length;
            n = 0;
            while (n < n2) {
                organizer = iBreakpointOrganizerArray[n];
                organizer.addPropertyChangeListener(this);
                ++n;
            }
        }
        if (!this.fDisposed) {
            this.fViewer.getControl().setRedraw(false);
            IBreakpoint[] breakpoints = null;
            if (this.isShowingGroups()) {
                breakpoints = this.fViewer.getVisibleBreakpoints();
            }
            this.reorganize();
            if (this.isShowingGroups() && breakpoints != null) {
                Object[] objectArray = this.fElements;
                int n3 = this.fElements.length;
                n2 = 0;
                while (n2 < n3) {
                    Object element = objectArray[n2];
                    BreakpointContainer container = (BreakpointContainer)element;
                    IBreakpoint[] iBreakpointArray = breakpoints;
                    int n4 = breakpoints.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IBreakpoint breakpoint = iBreakpointArray[n5];
                        if (container.contains(breakpoint)) {
                            this.fViewer.expandToLevel(container, -1);
                            this.fViewer.updateCheckedState(container);
                            break;
                        }
                        ++n5;
                    }
                    ++n2;
                }
            }
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public BreakpointContainer[] getRoots(IBreakpoint breakpoint) {
        if (this.isShowingGroups()) {
            ArrayList<BreakpointContainer> list = new ArrayList<BreakpointContainer>();
            Object[] objectArray = this.fElements;
            int n = this.fElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                BreakpointContainer container = (BreakpointContainer)element;
                if (container.contains(breakpoint)) {
                    list.add(container);
                }
                ++n2;
            }
            return list.toArray(new BreakpointContainer[list.size()]);
        }
        return null;
    }

    IBreakpointOrganizer[] getOrganizers() {
        return this.fOrganizers;
    }

    protected void reorganize() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        if (this.fOrganizers == null) {
            this.fElements = breakpoints;
        } else {
            IBreakpointOrganizer organizer = this.fOrganizers[0];
            HashMap<IAdaptable, BreakpointContainer> categoriesToContainers = new HashMap<IAdaptable, BreakpointContainer>();
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IAdaptable[] categories = organizer.getCategories(breakpoint);
                if (categories == null || categories.length == 0) {
                    categories = OtherBreakpointCategory.getCategories(organizer);
                }
                IAdaptable[] iAdaptableArray = categories;
                int n3 = categories.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable category = iAdaptableArray[n4];
                    BreakpointContainer container = (BreakpointContainer)categoriesToContainers.get(category);
                    if (container == null) {
                        IBreakpointOrganizer[] nesting = null;
                        if (this.fOrganizers.length > 1) {
                            nesting = new IBreakpointOrganizer[this.fOrganizers.length - 1];
                            System.arraycopy(this.fOrganizers, 1, nesting, 0, nesting.length);
                        }
                        container = new BreakpointContainer(category, organizer, nesting);
                        categoriesToContainers.put(category, container);
                    }
                    container.addBreakpoint(breakpoint);
                    ++n4;
                }
                ++n2;
            }
            IAdaptable[] emptyCategories = organizer.getCategories();
            if (emptyCategories != null) {
                IAdaptable[] iAdaptableArray = emptyCategories;
                int n5 = emptyCategories.length;
                n = 0;
                while (n < n5) {
                    IAdaptable emptyCategory = iAdaptableArray[n];
                    BreakpointContainer container = (BreakpointContainer)categoriesToContainers.get(emptyCategory);
                    if (container == null) {
                        container = new BreakpointContainer(emptyCategory, organizer, null);
                        categoriesToContainers.put(emptyCategory, container);
                    }
                    ++n;
                }
            }
            this.fElements = categoriesToContainers.values().toArray();
        }
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IBreakpointOrganizerDelegate.P_CATEGORY_CHANGED)) {
            this.reorganize();
        }
    }

    protected BreakpointContainer[] getContainers(IBreakpoint breakpoint) {
        if (this.isShowingGroups()) {
            IAdaptable[] categories = this.fOrganizers[0].getCategories(breakpoint);
            if (categories == null || categories.length == 0) {
                categories = OtherBreakpointCategory.getCategories(this.fOrganizers[0]);
            }
            BreakpointContainer[] containers = new BreakpointContainer[categories.length];
            int index = 0;
            Object[] objectArray = this.fElements;
            int n = this.fElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                BreakpointContainer container = (BreakpointContainer)element;
                IAdaptable[] iAdaptableArray = categories;
                int n3 = categories.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable category = iAdaptableArray[n4];
                    if (container.getCategory().equals(category)) {
                        containers[index] = container;
                        ++index;
                    }
                    ++n4;
                }
                ++n2;
            }
            return containers;
        }
        return null;
    }

    protected boolean isShowingGroups() {
        return this.fOrganizers != null;
    }
}

