/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring;

abstract class SimilarFinderVisitor
extends ASTVisitor {
    protected final ExtractFunctionRefactoring refactoring;
    protected final NodeContainer extractedNodes;
    protected NodeContainer similarContainer;
    protected final List<IASTStatement> stmtToReplace = new ArrayList<IASTStatement>();
    private final List<IASTNode> trail;
    private final List<IASTNode> statements;
    private int statementCount;

    SimilarFinderVisitor(ExtractFunctionRefactoring refactoring, NodeContainer extractedNodes, List<IASTNode> trail, List<IASTNode> statements) {
        this.refactoring = refactoring;
        this.extractedNodes = extractedNodes;
        this.trail = trail;
        this.statements = statements;
        this.similarContainer = new NodeContainer();
        this.shouldVisitStatements = true;
    }

    public int visit(IASTStatement statement) {
        if (!this.isInSelection(statement) && this.refactoring.isStatementInTrail(statement, this.trail)) {
            this.stmtToReplace.add(statement);
            this.similarContainer.add((IASTNode)statement);
            ++this.statementCount;
            if (this.statementCount == this.statements.size()) {
                boolean similarOnReturnWays = true;
                for (NameInformation nameInfo : this.similarContainer.getParameterCandidates()) {
                    Integer nameOrderNumber;
                    if (!this.refactoring.names.containsKey(nameInfo.getDeclarationName().getRawSignature()) || !this.refactoring.nameTrail.containsValue(nameOrderNumber = this.refactoring.names.get(nameInfo.getDeclarationName().getRawSignature()))) continue;
                    String orgName = null;
                    boolean found = false;
                    for (Map.Entry<String, Integer> entry : this.refactoring.nameTrail.entrySet()) {
                        if (!entry.getValue().equals(nameOrderNumber)) continue;
                        orgName = entry.getKey();
                        break;
                    }
                    if (orgName != null) {
                        for (NameInformation orgNameInfo : this.extractedNodes.getParameterCandidates()) {
                            if (!orgName.equals(orgNameInfo.getDeclarationName().getRawSignature()) || !orgNameInfo.isOutput() && nameInfo.isOutput()) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    similarOnReturnWays = false;
                }
                if (similarOnReturnWays) {
                    this.foundSimilar();
                }
                this.clear();
            }
            return 1;
        }
        this.clear();
        return super.visit(statement);
    }

    protected abstract void foundSimilar();

    private boolean isInSelection(IASTStatement stmt) {
        List<IASTNode> nodes = this.extractedNodes.getNodesToWrite();
        for (IASTNode node : nodes) {
            if (!node.equals(stmt)) continue;
            return true;
        }
        return false;
    }

    private void clear() {
        this.statementCount = 0;
        this.refactoring.names.clear();
        this.similarContainer = new NodeContainer();
        this.refactoring.namesCounter.setObject(ExtractFunctionRefactoring.NULL_INTEGER);
        this.refactoring.trailPos.setObject(ExtractFunctionRefactoring.NULL_INTEGER);
        this.stmtToReplace.clear();
    }
}

